# -*- coding: utf-8 -*-

import sys
import glob
import subprocess
import os.path as op

import mne

mne_bin_dir = op.dirname(mne.__file__)
valid_commands = sorted(glob.glob(op.join(mne_bin_dir,
                                          'commands', 'mne_*.py')))
valid_commands = [c.split(op.sep)[-1][4:-3] for c in valid_commands]


def print_help():
    print("Usage : mne command options\n")
    print("Accepted commands :\n")
    for c in valid_commands:
        print("\t- %s" % c)
    print("\nExample : mne browse_raw --raw sample_audvis_raw.fif")
    print("\nGetting help example : mne compute_proj_eog -h")
    sys.exit(0)

if len(sys.argv) == 1:
    print_help()
elif ("help" in sys.argv[1] or "-h" in sys.argv[1]):
    print_help()
elif sys.argv[1] == "--version":
    print("MNE %s" % mne.__version__)
elif sys.argv[1] not in valid_commands:
    print('Invalid command: "%s"\n' % sys.argv[1])
    print_help()
    sys.exit(0)
else:
    cmd = sys.argv[1]
    cmd_path = op.join(mne_bin_dir, 'commands', 'mne_%s.py' % cmd)
    sys.exit(subprocess.call([sys.executable, cmd_path] + sys.argv[2:]))
