# This file allows users to call find_package(MLIR) and pick up our targets.

# Compute the installation prefix from this LLVMConfig.cmake file location.
get_filename_component(MLIR_INSTALL_PREFIX "${CMAKE_CURRENT_LIST_FILE}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)

find_package(LLVM REQUIRED CONFIG
             HINTS "${MLIR_INSTALL_PREFIX}/lib/cmake/llvm")

set(MLIR_EXPORTED_TARGETS "MLIRAnalysis;MLIRPresburger;MLIRAffineToStandard;MLIRArithmeticToLLVM;MLIRArithmeticToSPIRV;MLIRArmNeon2dToIntr;MLIRAsyncToLLVM;MLIRBufferizationToMemRef;MLIRComplexToLLVM;MLIRComplexToStandard;MLIRGPUToGPURuntimeTransforms;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRGPUToVulkanTransforms;MLIRLinalgToLLVM;MLIRLinalgToSPIRV;MLIRLinalgToStandard;MLIRLLVMCommonConversion;MLIRMathToLibm;MLIRMathToLLVM;MLIRMathToSPIRV;MLIRMemRefToLLVM;MLIRMemRefToSPIRV;MLIROpenACCToLLVM;MLIROpenACCToSCF;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRReconcileUnrealizedCasts;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRSCFToStandard;MLIRShapeToStandard;MLIRSPIRVToLLVM;MLIRStandardToLLVM;MLIRStandardToSPIRV;MLIRTosaToLinalg;MLIRTosaToSCF;MLIRTosaToStandard;MLIRVectorToROCDL;MLIRVectorToLLVM;MLIRVectorToGPU;MLIRVectorToSCF;MLIRVectorToSPIRV;MLIRAffineAnalysis;MLIRAffine;MLIRAffineTransforms;MLIRAffineUtils;MLIRArithmetic;MLIRArithmeticTransforms;MLIRArmNeon;MLIRArmSVE;MLIRArmSVETransforms;MLIRAsync;MLIRAsyncTransforms;MLIRAMX;MLIRAMXTransforms;MLIRBufferization;MLIRBufferizationTransforms;MLIRComplex;MLIRDLTI;MLIREmitC;MLIRGPUOps;MLIRGPUTransforms;MLIRLinalgAnalysis;MLIRAffineBufferizableOpInterfaceImpl;MLIRLinalgBufferizableOpInterfaceImpl;MLIRModuleBufferization;MLIRLinalg;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMIR;MLIRNVVMIR;MLIRROCDLIR;MLIRMath;MLIRMathTransforms;MLIRMemRef;MLIRMemRefTransforms;MLIRMemRefUtils;MLIROpenACC;MLIROpenMP;MLIRPDL;MLIRPDLInterp;MLIRQuant;MLIRSCF;MLIRSCFTransforms;MLIRSCFUtils;MLIRShape;MLIRShapeOpsTransforms;MLIRSparseTensor;MLIRSparseTensorTransforms;MLIRSparseTensorPipelines;MLIRSparseTensorUtils;MLIRSPIRV;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRStandard;MLIRStandardOpsTransforms;MLIRTensor;MLIRTensorInferTypeOpInterfaceImpl;MLIRTensorTilingInterfaceImpl;MLIRTensorTransforms;MLIRTensorUtils;MLIRTosa;MLIRTosaTransforms;MLIRDialectUtils;MLIRVector;MLIRVectorTransforms;MLIRVectorUtils;MLIRX86Vector;MLIRX86VectorTransforms;MLIRDialect;MLIRExecutionEngine;MLIRJitRunner;mlir_c_runner_utils;mlir_runner_utils;mlir_async_runtime;MLIRIR;MLIRCallInterfaces;MLIRCastInterfaces;MLIRControlFlowInterfaces;MLIRCopyOpInterface;MLIRDataLayoutInterfaces;MLIRDerivedAttributeOpInterface;MLIRInferTypeOpInterface;MLIRSideEffectInterfaces;MLIRTilingInterface;MLIRVectorInterfaces;MLIRViewLikeInterface;MLIRLoopLikeInterface;MLIRParser;MLIRPass;MLIRReduce;MLIRRewrite;MLIRSupport;MLIROptLib;MLIRTableGen;MLIRTargetCpp;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRArmNeonToLLVMIRTranslation;MLIRArmSVEToLLVMIRTranslation;MLIRAMXToLLVMIRTranslation;MLIRLLVMToLLVMIRTranslation;MLIRNVVMToLLVMIRTranslation;MLIROpenACCToLLVMIRTranslation;MLIROpenMPToLLVMIRTranslation;MLIRROCDLToLLVMIRTranslation;MLIRX86VectorToLLVMIRTranslation;MLIRTargetLLVMIRExport;MLIRToLLVMIRTranslationRegistration;MLIRTargetLLVMIRImport;MLIRLspServerLib;MLIRReduceLib;MLIRPDLLAST;MLIRPDLLParser;MLIRTransformUtils;MLIRTransforms;MLIRTranslation;MLIRCAPIDebug;obj.MLIRCAPIDebug;MLIRCAPIAsync;obj.MLIRCAPIAsync;MLIRCAPIGPU;obj.MLIRCAPIGPU;MLIRCAPILLVM;obj.MLIRCAPILLVM;MLIRCAPILinalg;obj.MLIRCAPILinalg;MLIRCAPISCF;obj.MLIRCAPISCF;MLIRCAPIShape;obj.MLIRCAPIShape;MLIRCAPISparseTensor;obj.MLIRCAPISparseTensor;MLIRCAPIStandard;obj.MLIRCAPIStandard;MLIRCAPITensor;obj.MLIRCAPITensor;MLIRCAPIQuant;obj.MLIRCAPIQuant;MLIRCAPIPDL;obj.MLIRCAPIPDL;MLIRCAPIConversion;obj.MLIRCAPIConversion;MLIRCAPIExecutionEngine;obj.MLIRCAPIExecutionEngine;MLIRCAPIInterfaces;obj.MLIRCAPIInterfaces;MLIRCAPIIR;obj.MLIRCAPIIR;MLIRCAPIRegistration;obj.MLIRCAPIRegistration;MLIRCAPITransforms;obj.MLIRCAPITransforms;MLIRMlirOptMain")
set(MLIR_CMAKE_DIR "${MLIR_INSTALL_PREFIX}/lib/cmake/mlir")
set(MLIR_INCLUDE_DIRS "${MLIR_INSTALL_PREFIX}/include")
set(MLIR_TABLEGEN_EXE "mlir-tblgen")
set(MLIR_INSTALL_AGGREGATE_OBJECTS "1")
set(MLIR_ENABLE_BINDINGS_PYTHON "0")

# For mlir_tablegen()
set(MLIR_INCLUDE_DIR "D:/bld/mlir-split_1655743278336/work/build/include")
set(MLIR_MAIN_SRC_DIR "D:/bld/mlir-split_1655743278336/work/mlir")

set_property(GLOBAL PROPERTY MLIR_ALL_LIBS "MLIRAnalysis;MLIRPresburger;MLIRAffineToStandard;MLIRArithmeticToLLVM;MLIRArithmeticToSPIRV;MLIRArmNeon2dToIntr;MLIRAsyncToLLVM;MLIRBufferizationToMemRef;MLIRComplexToLLVM;MLIRComplexToStandard;MLIRGPUToGPURuntimeTransforms;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRGPUToVulkanTransforms;MLIRLinalgToLLVM;MLIRLinalgToSPIRV;MLIRLinalgToStandard;MLIRLLVMCommonConversion;MLIRMathToLibm;MLIRMathToLLVM;MLIRMathToSPIRV;MLIRMemRefToLLVM;MLIRMemRefToSPIRV;MLIROpenACCToLLVM;MLIROpenACCToSCF;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRReconcileUnrealizedCasts;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRSCFToStandard;MLIRShapeToStandard;MLIRSPIRVToLLVM;MLIRStandardToLLVM;MLIRStandardToSPIRV;MLIRTosaToLinalg;MLIRTosaToSCF;MLIRTosaToStandard;MLIRVectorToROCDL;MLIRVectorToLLVM;MLIRVectorToGPU;MLIRVectorToSCF;MLIRVectorToSPIRV;MLIRAffineAnalysis;MLIRAffine;MLIRAffineTransforms;MLIRAffineUtils;MLIRArithmetic;MLIRArithmeticTransforms;MLIRArmNeon;MLIRArmSVE;MLIRArmSVETransforms;MLIRAsync;MLIRAsyncTransforms;MLIRAMX;MLIRAMXTransforms;MLIRBufferization;MLIRBufferizationTransforms;MLIRComplex;MLIRDLTI;MLIREmitC;MLIRGPUOps;MLIRGPUTransforms;MLIRLinalgAnalysis;MLIRAffineBufferizableOpInterfaceImpl;MLIRLinalgBufferizableOpInterfaceImpl;MLIRModuleBufferization;MLIRLinalg;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMIR;MLIRNVVMIR;MLIRROCDLIR;MLIRMath;MLIRMathTransforms;MLIRMemRef;MLIRMemRefTransforms;MLIRMemRefUtils;MLIROpenACC;MLIROpenMP;MLIRPDL;MLIRPDLInterp;MLIRQuant;MLIRSCF;MLIRSCFTransforms;MLIRSCFUtils;MLIRShape;MLIRShapeOpsTransforms;MLIRSparseTensor;MLIRSparseTensorTransforms;MLIRSparseTensorPipelines;MLIRSparseTensorUtils;MLIRSPIRV;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRStandard;MLIRStandardOpsTransforms;MLIRTensor;MLIRTensorInferTypeOpInterfaceImpl;MLIRTensorTilingInterfaceImpl;MLIRTensorTransforms;MLIRTensorUtils;MLIRTosa;MLIRTosaTransforms;MLIRDialectUtils;MLIRVector;MLIRVectorTransforms;MLIRVectorUtils;MLIRX86Vector;MLIRX86VectorTransforms;MLIRDialect;MLIRExecutionEngine;MLIRJitRunner;mlir_c_runner_utils;mlir_runner_utils;mlir_async_runtime;MLIRIR;MLIRCallInterfaces;MLIRCastInterfaces;MLIRControlFlowInterfaces;MLIRCopyOpInterface;MLIRDataLayoutInterfaces;MLIRDerivedAttributeOpInterface;MLIRInferTypeOpInterface;MLIRSideEffectInterfaces;MLIRTilingInterface;MLIRVectorInterfaces;MLIRViewLikeInterface;MLIRLoopLikeInterface;MLIRParser;MLIRPass;MLIRReduce;MLIRRewrite;MLIRSupport;MLIROptLib;MLIRTableGen;MLIRTargetCpp;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRArmNeonToLLVMIRTranslation;MLIRArmSVEToLLVMIRTranslation;MLIRAMXToLLVMIRTranslation;MLIRLLVMToLLVMIRTranslation;MLIRNVVMToLLVMIRTranslation;MLIROpenACCToLLVMIRTranslation;MLIROpenMPToLLVMIRTranslation;MLIRROCDLToLLVMIRTranslation;MLIRX86VectorToLLVMIRTranslation;MLIRTargetLLVMIRExport;MLIRToLLVMIRTranslationRegistration;MLIRTargetLLVMIRImport;MLIRLspServerLib;MLIRReduceLib;MLIRPDLLAST;MLIRPDLLParser;MLIRTransformUtils;MLIRTransforms;MLIRTranslation;MLIRCAPIDebug;obj.MLIRCAPIDebug;MLIRCAPIAsync;obj.MLIRCAPIAsync;MLIRCAPIGPU;obj.MLIRCAPIGPU;MLIRCAPILLVM;obj.MLIRCAPILLVM;MLIRCAPILinalg;obj.MLIRCAPILinalg;MLIRCAPISCF;obj.MLIRCAPISCF;MLIRCAPIShape;obj.MLIRCAPIShape;MLIRCAPISparseTensor;obj.MLIRCAPISparseTensor;MLIRCAPIStandard;obj.MLIRCAPIStandard;MLIRCAPITensor;obj.MLIRCAPITensor;MLIRCAPIQuant;obj.MLIRCAPIQuant;MLIRCAPIPDL;obj.MLIRCAPIPDL;MLIRCAPIConversion;obj.MLIRCAPIConversion;MLIRCAPIExecutionEngine;obj.MLIRCAPIExecutionEngine;MLIRCAPIInterfaces;obj.MLIRCAPIInterfaces;MLIRCAPIIR;obj.MLIRCAPIIR;MLIRCAPIRegistration;obj.MLIRCAPIRegistration;MLIRCAPITransforms;obj.MLIRCAPITransforms;MLIRMlirOptMain")
set_property(GLOBAL PROPERTY MLIR_DIALECT_LIBS "MLIRAffineAnalysis;MLIRAffine;MLIRAffineTransforms;MLIRAffineUtils;MLIRArithmetic;MLIRArithmeticTransforms;MLIRArmNeon;MLIRArmSVE;MLIRArmSVETransforms;MLIRAsync;MLIRAsyncTransforms;MLIRAMX;MLIRAMXTransforms;MLIRBufferization;MLIRBufferizationTransforms;MLIRComplex;MLIRDLTI;MLIREmitC;MLIRGPUOps;MLIRGPUTransforms;MLIRLinalgAnalysis;MLIRAffineBufferizableOpInterfaceImpl;MLIRLinalgBufferizableOpInterfaceImpl;MLIRModuleBufferization;MLIRLinalg;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMIR;MLIRNVVMIR;MLIRROCDLIR;MLIRMath;MLIRMathTransforms;MLIRMemRef;MLIRMemRefTransforms;MLIRMemRefUtils;MLIROpenACC;MLIROpenMP;MLIRPDL;MLIRPDLInterp;MLIRQuant;MLIRSCF;MLIRSCFTransforms;MLIRSCFUtils;MLIRShape;MLIRShapeOpsTransforms;MLIRSparseTensor;MLIRSparseTensorTransforms;MLIRSparseTensorPipelines;MLIRSparseTensorUtils;MLIRSPIRV;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRStandard;MLIRStandardOpsTransforms;MLIRTensor;MLIRTensorInferTypeOpInterfaceImpl;MLIRTensorTilingInterfaceImpl;MLIRTensorTransforms;MLIRTensorUtils;MLIRTosa;MLIRTosaTransforms;MLIRVector;MLIRVectorTransforms;MLIRVectorUtils;MLIRX86Vector;MLIRX86VectorTransforms")
set_property(GLOBAL PROPERTY MLIR_CONVERSION_LIBS "MLIRAffineToStandard;MLIRArithmeticToLLVM;MLIRArithmeticToSPIRV;MLIRArmNeon2dToIntr;MLIRAsyncToLLVM;MLIRBufferizationToMemRef;MLIRComplexToLLVM;MLIRComplexToStandard;MLIRGPUToGPURuntimeTransforms;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRGPUToVulkanTransforms;MLIRLinalgToLLVM;MLIRLinalgToSPIRV;MLIRLinalgToStandard;MLIRLLVMCommonConversion;MLIRMathToLibm;MLIRMathToLLVM;MLIRMathToSPIRV;MLIRMemRefToLLVM;MLIRMemRefToSPIRV;MLIROpenACCToLLVM;MLIROpenACCToSCF;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRReconcileUnrealizedCasts;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRSCFToStandard;MLIRShapeToStandard;MLIRSPIRVToLLVM;MLIRStandardToLLVM;MLIRStandardToSPIRV;MLIRTosaToLinalg;MLIRTosaToSCF;MLIRTosaToStandard;MLIRVectorToROCDL;MLIRVectorToLLVM;MLIRVectorToGPU;MLIRVectorToSCF;MLIRVectorToSPIRV")
set_property(GLOBAL PROPERTY MLIR_TRANSLATION_LIBS "MLIRTargetCpp;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRArmNeonToLLVMIRTranslation;MLIRArmSVEToLLVMIRTranslation;MLIRAMXToLLVMIRTranslation;MLIRLLVMToLLVMIRTranslation;MLIRNVVMToLLVMIRTranslation;MLIROpenACCToLLVMIRTranslation;MLIROpenMPToLLVMIRTranslation;MLIRROCDLToLLVMIRTranslation;MLIRX86VectorToLLVMIRTranslation;MLIRTargetLLVMIRExport;MLIRToLLVMIRTranslationRegistration;MLIRTargetLLVMIRImport")

# Provide all our library targets to users.
# More specifically, configure MLIR so that it can be directly included in a top
# level CMakeLists.txt, but also so that it can be imported via `find_package`.
# This is based on how LLVM handles exports.
if(NOT TARGET MLIRSupport)
  include("${MLIR_CMAKE_DIR}/MLIRTargets.cmake")
endif()

# By creating these targets here, subprojects that depend on MLIR's
# tablegen-generated headers can always depend on these targets whether building
# in-tree with MLIR or not.
if(NOT TARGET mlir-tablegen-targets)
  add_custom_target(mlir-tablegen-targets)
endif()
if(NOT TARGET mlir-headers)
  add_custom_target(mlir-headers)
endif()
if(NOT TARGET mlir-generic-headers)
  add_custom_target(mlir-generic-headers)
endif()
if(NOT TARGET mlir-doc)
  add_custom_target(mlir-doc)
endif()
