# This file allows users to call find_package(MLIR) and pick up our targets.


# Compute the installation prefix from this MLIRConfig.cmake file location.
get_filename_component(MLIR_INSTALL_PREFIX "${CMAKE_CURRENT_LIST_FILE}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)

find_package(LLVM REQUIRED CONFIG
             HINTS "${MLIR_INSTALL_PREFIX}/lib/cmake/llvm")

set(MLIR_EXPORTED_TARGETS "MLIRAnalysis;MLIRLoopAnalysis;MLIRPresburger;MLIRAffineToStandard;MLIRArmNeonToLLVM;MLIRAsyncToLLVM;MLIRAVX512ToLLVM;MLIRComplexToLLVM;MLIRGPUToGPURuntimeTransforms;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRGPUToVulkanTransforms;MLIRLinalgToLLVM;MLIRLinalgToSPIRV;MLIRLinalgToStandard;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRSCFToStandard;MLIRShapeToStandard;MLIRSPIRVToLLVM;MLIRStandardToLLVM;MLIRStandardToSPIRV;MLIRTosaToLinalg;MLIRArmSVEToLLVM;MLIRVectorToROCDL;MLIRVectorToLLVM;MLIRVectorToSCF;MLIRVectorToSPIRV;MLIRAffine;MLIRAffineEDSC;MLIRAffineTransforms;MLIRAffineUtils;MLIRArmNeon;MLIRArmSVE;MLIRAsync;MLIRAsyncTransforms;MLIRAVX512;MLIRComplex;MLIRGPU;MLIRLinalgAnalysis;MLIRLinalgEDSC;MLIRLinalg;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMIR;MLIRLLVMAVX512;MLIRLLVMArmNeon;MLIRLLVMArmSVE;MLIRNVVMIR;MLIRROCDLIR;MLIROpenACC;MLIROpenMP;MLIRPDL;MLIRPDLInterp;MLIRQuant;MLIRSCF;MLIRSCFTransforms;MLIRSDBM;MLIRShape;MLIRShapeOpsTransforms;MLIRSPIRV;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRStandard;MLIRStandardOpsTransforms;MLIRTensor;MLIRTensorTransforms;MLIRTosa;MLIRTosaTransforms;MLIRVector;MLIRDialect;MLIREDSC;MLIRExecutionEngine;MLIRJitRunner;mlir_c_runner_utils;mlir_c_runner_utils_static;mlir_runner_utils;mlir_async_runtime;MLIRIR;MLIRCallInterfaces;MLIRCastInterfaces;MLIRControlFlowInterfaces;MLIRCopyOpInterface;MLIRDerivedAttributeOpInterface;MLIRInferTypeOpInterface;MLIRLoopLikeInterface;MLIRSideEffectInterfaces;MLIRVectorInterfaces;MLIRViewLikeInterface;MLIRParser;MLIRPass;MLIRReduce;MLIRRewrite;MLIRSupport;MLIROptLib;MLIRTableGen;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRTargetLLVMIRModuleTranslation;MLIRTargetAVX512;MLIRTargetLLVMIR;MLIRTargetArmNeon;MLIRTargetArmSVE;MLIRTargetNVVMIR;MLIRTargetROCDLIR;MLIRTransformUtils;MLIRTransforms;MLIRTranslation;MLIRCAPIIR;MLIRCAPIRegistration;MLIRCAPILinalg;MLIRCAPISCF;MLIRCAPIShape;MLIRCAPIStandard;MLIRCAPITensor;MLIRCAPITransforms;MLIRPublicAPI;MLIRMlirOptMain")
set(MLIR_CMAKE_DIR "${MLIR_INSTALL_PREFIX}/lib/cmake/mlir")
set(MLIR_INCLUDE_DIRS "${MLIR_INSTALL_PREFIX}/include")
set(MLIR_TABLEGEN_EXE "mlir-tblgen")

# For mlir_tablegen()
set(MLIR_INCLUDE_DIR "D:/bld/mlir-split_1626381301083/work/build/include")
set(MLIR_MAIN_SRC_DIR "D:/bld/mlir-split_1626381301083/work/mlir")

set_property(GLOBAL PROPERTY MLIR_ALL_LIBS "MLIRAnalysis;MLIRLoopAnalysis;MLIRPresburger;MLIRAffineToStandard;MLIRArmNeonToLLVM;MLIRAsyncToLLVM;MLIRAVX512ToLLVM;MLIRComplexToLLVM;MLIRGPUToGPURuntimeTransforms;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRGPUToVulkanTransforms;MLIRLinalgToLLVM;MLIRLinalgToSPIRV;MLIRLinalgToStandard;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRSCFToStandard;MLIRShapeToStandard;MLIRSPIRVToLLVM;MLIRStandardToLLVM;MLIRStandardToSPIRV;MLIRTosaToLinalg;MLIRArmSVEToLLVM;MLIRVectorToROCDL;MLIRVectorToLLVM;MLIRVectorToSCF;MLIRVectorToSPIRV;MLIRAffine;MLIRAffineEDSC;MLIRAffineTransforms;MLIRAffineUtils;MLIRArmNeon;MLIRArmSVE;MLIRAsync;MLIRAsyncTransforms;MLIRAVX512;MLIRComplex;MLIRGPU;MLIRLinalgAnalysis;MLIRLinalgEDSC;MLIRLinalg;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMIR;MLIRLLVMAVX512;MLIRLLVMArmNeon;MLIRLLVMArmSVE;MLIRNVVMIR;MLIRROCDLIR;MLIROpenACC;MLIROpenMP;MLIRPDL;MLIRPDLInterp;MLIRQuant;MLIRSCF;MLIRSCFTransforms;MLIRSDBM;MLIRShape;MLIRShapeOpsTransforms;MLIRSPIRV;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRStandard;MLIRStandardOpsTransforms;MLIRTensor;MLIRTensorTransforms;MLIRTosa;MLIRTosaTransforms;MLIRVector;MLIRDialect;MLIREDSC;MLIRExecutionEngine;MLIRJitRunner;mlir_c_runner_utils;mlir_c_runner_utils_static;mlir_runner_utils;mlir_async_runtime;MLIRIR;MLIRCallInterfaces;MLIRCastInterfaces;MLIRControlFlowInterfaces;MLIRCopyOpInterface;MLIRDerivedAttributeOpInterface;MLIRInferTypeOpInterface;MLIRLoopLikeInterface;MLIRSideEffectInterfaces;MLIRVectorInterfaces;MLIRViewLikeInterface;MLIRParser;MLIRPass;MLIRReduce;MLIRRewrite;MLIRSupport;MLIROptLib;MLIRTableGen;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRTargetLLVMIRModuleTranslation;MLIRTargetAVX512;MLIRTargetLLVMIR;MLIRTargetArmNeon;MLIRTargetArmSVE;MLIRTargetNVVMIR;MLIRTargetROCDLIR;MLIRTransformUtils;MLIRTransforms;MLIRTranslation;MLIRCAPIIR;MLIRCAPIRegistration;MLIRCAPILinalg;MLIRCAPISCF;MLIRCAPIShape;MLIRCAPIStandard;MLIRCAPITensor;MLIRCAPITransforms;MLIRPublicAPI;MLIRMlirOptMain")
set_property(GLOBAL PROPERTY MLIR_DIALECT_LIBS "MLIRAffine;MLIRAffineEDSC;MLIRAffineTransforms;MLIRAffineUtils;MLIRArmNeon;MLIRArmSVE;MLIRAsync;MLIRAsyncTransforms;MLIRAVX512;MLIRComplex;MLIRGPU;MLIRLinalgAnalysis;MLIRLinalgEDSC;MLIRLinalg;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMIR;MLIRLLVMAVX512;MLIRLLVMArmNeon;MLIRLLVMArmSVE;MLIRNVVMIR;MLIRROCDLIR;MLIROpenACC;MLIROpenMP;MLIRPDL;MLIRPDLInterp;MLIRQuant;MLIRSCF;MLIRSCFTransforms;MLIRSDBM;MLIRShape;MLIRShapeOpsTransforms;MLIRSPIRV;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRStandard;MLIRStandardOpsTransforms;MLIRTensor;MLIRTensorTransforms;MLIRTosa;MLIRTosaTransforms;MLIRVector")
set_property(GLOBAL PROPERTY MLIR_CONVERSION_LIBS "MLIRAffineToStandard;MLIRArmNeonToLLVM;MLIRAsyncToLLVM;MLIRAVX512ToLLVM;MLIRComplexToLLVM;MLIRGPUToGPURuntimeTransforms;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRGPUToVulkanTransforms;MLIRLinalgToLLVM;MLIRLinalgToSPIRV;MLIRLinalgToStandard;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRSCFToStandard;MLIRShapeToStandard;MLIRSPIRVToLLVM;MLIRStandardToLLVM;MLIRStandardToSPIRV;MLIRTosaToLinalg;MLIRArmSVEToLLVM;MLIRVectorToROCDL;MLIRVectorToLLVM;MLIRVectorToSCF;MLIRVectorToSPIRV")
set_property(GLOBAL PROPERTY MLIR_TRANSLATION_LIBS "MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRTargetLLVMIRModuleTranslation;MLIRTargetAVX512;MLIRTargetLLVMIR;MLIRTargetArmNeon;MLIRTargetArmSVE;MLIRTargetNVVMIR;MLIRTargetROCDLIR")

# Provide all our library targets to users.
include("${MLIR_CMAKE_DIR}/MLIRTargets.cmake")

# By creating these targets here, subprojects that depend on MLIR's
# tablegen-generated headers can always depend on these targets whether building
# in-tree with MLIR or not.
if(NOT TARGET mlir-tablegen-targets)
  add_custom_target(mlir-tablegen-targets)
endif()
if(NOT TARGET mlir-headers)
  add_custom_target(mlir-headers)
endif()
if(NOT TARGET mlir-generic-headers)
  add_custom_target(mlir-generic-headers)
endif()
if(NOT TARGET mlir-doc)
  add_custom_target(mlir-doc)
endif()
