/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Interface Declarations                                                     *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
class OffsetSizeAndStrideOpInterface;
namespace detail {
struct OffsetSizeAndStrideOpInterfaceInterfaceTraits {
  struct Concept {
    unsigned (*getOffsetSizeAndStrideStartOperandIndex)(::mlir::Operation *);
    std::array<unsigned, 3> (*getArrayAttrRanks)(::mlir::Operation *);
    OperandRange (*offsets)(::mlir::Operation *);
    OperandRange (*sizes)(::mlir::Operation *);
    OperandRange (*strides)(::mlir::Operation *);
    ArrayAttr (*static_offsets)(::mlir::Operation *);
    ArrayAttr (*static_sizes)(::mlir::Operation *);
    ArrayAttr (*static_strides)(::mlir::Operation *);
    SmallVector<OpFoldResult, 4> (*getMixedOffsets)(::mlir::Operation *);
    SmallVector<OpFoldResult, 4> (*getMixedSizes)(::mlir::Operation *);
    SmallVector<OpFoldResult, 4> (*getMixedStrides)(::mlir::Operation *);
    bool (*isDynamicOffset)(::mlir::Operation *, unsigned);
    bool (*isDynamicSize)(::mlir::Operation *, unsigned);
    bool (*isDynamicStride)(::mlir::Operation *, unsigned);
    int64_t (*getStaticOffset)(::mlir::Operation *, unsigned);
    int64_t (*getStaticSize)(::mlir::Operation *, unsigned);
    int64_t (*getStaticStride)(::mlir::Operation *, unsigned);
    unsigned (*getIndexOfDynamicOffset)(::mlir::Operation *, unsigned);
    unsigned (*getIndexOfDynamicSize)(::mlir::Operation *, unsigned);
    unsigned (*getIndexOfDynamicStride)(::mlir::Operation *, unsigned);
    unsigned (*getNumDynamicEntriesUpToIdx)(::mlir::Operation *, ArrayAttr, llvm::function_ref<bool(int64_t)>, unsigned);
    Value (*getDynamicOffset)(::mlir::Operation *, unsigned);
    Value (*getDynamicSize)(::mlir::Operation *, unsigned);
    Value (*getDynamicStride)(::mlir::Operation *, unsigned);
  };
  template<typename ConcreteOp>
  class Model : public Concept {
  public:
    Model() : Concept{getOffsetSizeAndStrideStartOperandIndex, getArrayAttrRanks, offsets, sizes, strides, static_offsets, static_sizes, static_strides, getMixedOffsets, getMixedSizes, getMixedStrides, isDynamicOffset, isDynamicSize, isDynamicStride, getStaticOffset, getStaticSize, getStaticStride, getIndexOfDynamicOffset, getIndexOfDynamicSize, getIndexOfDynamicStride, getNumDynamicEntriesUpToIdx, getDynamicOffset, getDynamicSize, getDynamicStride} {}

    static inline unsigned getOffsetSizeAndStrideStartOperandIndex(::mlir::Operation *tablegen_opaque_val);
    static inline std::array<unsigned, 3> getArrayAttrRanks(::mlir::Operation *tablegen_opaque_val);
    static inline OperandRange offsets(::mlir::Operation *tablegen_opaque_val);
    static inline OperandRange sizes(::mlir::Operation *tablegen_opaque_val);
    static inline OperandRange strides(::mlir::Operation *tablegen_opaque_val);
    static inline ArrayAttr static_offsets(::mlir::Operation *tablegen_opaque_val);
    static inline ArrayAttr static_sizes(::mlir::Operation *tablegen_opaque_val);
    static inline ArrayAttr static_strides(::mlir::Operation *tablegen_opaque_val);
    static inline SmallVector<OpFoldResult, 4> getMixedOffsets(::mlir::Operation *tablegen_opaque_val);
    static inline SmallVector<OpFoldResult, 4> getMixedSizes(::mlir::Operation *tablegen_opaque_val);
    static inline SmallVector<OpFoldResult, 4> getMixedStrides(::mlir::Operation *tablegen_opaque_val);
    static inline bool isDynamicOffset(::mlir::Operation *tablegen_opaque_val, unsigned idx);
    static inline bool isDynamicSize(::mlir::Operation *tablegen_opaque_val, unsigned idx);
    static inline bool isDynamicStride(::mlir::Operation *tablegen_opaque_val, unsigned idx);
    static inline int64_t getStaticOffset(::mlir::Operation *tablegen_opaque_val, unsigned idx);
    static inline int64_t getStaticSize(::mlir::Operation *tablegen_opaque_val, unsigned idx);
    static inline int64_t getStaticStride(::mlir::Operation *tablegen_opaque_val, unsigned idx);
    static inline unsigned getIndexOfDynamicOffset(::mlir::Operation *tablegen_opaque_val, unsigned idx);
    static inline unsigned getIndexOfDynamicSize(::mlir::Operation *tablegen_opaque_val, unsigned idx);
    static inline unsigned getIndexOfDynamicStride(::mlir::Operation *tablegen_opaque_val, unsigned idx);
    static inline unsigned getNumDynamicEntriesUpToIdx(::mlir::Operation *tablegen_opaque_val, ArrayAttr attr, llvm::function_ref<bool(int64_t)> isDynamic, unsigned idx);
    static inline Value getDynamicOffset(::mlir::Operation *tablegen_opaque_val, unsigned idx);
    static inline Value getDynamicSize(::mlir::Operation *tablegen_opaque_val, unsigned idx);
    static inline Value getDynamicStride(::mlir::Operation *tablegen_opaque_val, unsigned idx);
  };
};
} // end namespace detail
class OffsetSizeAndStrideOpInterface : public ::mlir::OpInterface<OffsetSizeAndStrideOpInterface, detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits> {
public:
  using ::mlir::OpInterface<OffsetSizeAndStrideOpInterface, detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits>::OpInterface;
  template <typename ConcreteOp>
  struct OffsetSizeAndStrideOpInterfaceTrait : public ::mlir::OpInterface<OffsetSizeAndStrideOpInterface, detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits>::Trait<ConcreteOp> {
    OperandRange offsets() {
      return (*static_cast<ConcreteOp *>(this)).offsets();
    }
    OperandRange sizes() {
      return (*static_cast<ConcreteOp *>(this)).sizes();
    }
    OperandRange strides() {
      return (*static_cast<ConcreteOp *>(this)).strides();
    }
    ArrayAttr static_offsets() {
      return (*static_cast<ConcreteOp *>(this)).static_offsets();
    }
    ArrayAttr static_sizes() {
      return (*static_cast<ConcreteOp *>(this)).static_sizes();
    }
    ArrayAttr static_strides() {
      return (*static_cast<ConcreteOp *>(this)).static_strides();
    }
    SmallVector<OpFoldResult, 4> getMixedOffsets() {
      SmallVector<OpFoldResult, 4> res;
        std::array<unsigned, 3> ranks = (*static_cast<ConcreteOp *>(this)).getArrayAttrRanks();
        unsigned numDynamic = 0;
        unsigned count = ranks[getOffsetOperandGroupPosition()];
        for (unsigned idx = 0; idx < count; ++idx) {
          if (isDynamicOffset(idx))
            res.push_back((*static_cast<ConcreteOp *>(this)).offsets()[numDynamic++]);
          else
            res.push_back((*static_cast<ConcreteOp *>(this)).static_offsets()[idx]);
        }
        return res;
    }
    SmallVector<OpFoldResult, 4> getMixedSizes() {
      SmallVector<OpFoldResult, 4> res;
        std::array<unsigned, 3> ranks = (*static_cast<ConcreteOp *>(this)).getArrayAttrRanks();
        unsigned numDynamic = 0;
        unsigned count = ranks[getSizeOperandGroupPosition()];
        for (unsigned idx = 0; idx < count; ++idx) {
          if (isDynamicSize(idx))
            res.push_back((*static_cast<ConcreteOp *>(this)).sizes()[numDynamic++]);
          else
            res.push_back((*static_cast<ConcreteOp *>(this)).static_sizes()[idx]);
        }
        return res;
    }
    SmallVector<OpFoldResult, 4> getMixedStrides() {
      SmallVector<OpFoldResult, 4> res;
        std::array<unsigned, 3> ranks = (*static_cast<ConcreteOp *>(this)).getArrayAttrRanks();
        unsigned numDynamic = 0;
        unsigned count = ranks[getStrideOperandGroupPosition()];
        for (unsigned idx = 0; idx < count; ++idx) {
          if (isDynamicStride(idx))
            res.push_back((*static_cast<ConcreteOp *>(this)).strides()[numDynamic++]);
          else
            res.push_back((*static_cast<ConcreteOp *>(this)).static_strides()[idx]);
        }
        return res;
    }
    bool isDynamicOffset(unsigned idx) {
      APInt v = *(static_offsets()
          .template getAsValueRange<IntegerAttr>().begin() + idx);
        return ShapedType::isDynamicStrideOrOffset(v.getSExtValue());
    }
    bool isDynamicSize(unsigned idx) {
      APInt v = *(static_sizes()
          .template getAsValueRange<IntegerAttr>().begin() + idx);
        return ShapedType::isDynamic(v.getSExtValue());
    }
    bool isDynamicStride(unsigned idx) {
      APInt v = *(static_strides()
          .template getAsValueRange<IntegerAttr>().begin() + idx);
        return ShapedType::isDynamicStrideOrOffset(v.getSExtValue());
    }
    int64_t getStaticOffset(unsigned idx) {
      assert(!(*static_cast<ConcreteOp *>(this)).isDynamicOffset(idx) && "expected static offset");
        APInt v = *(static_offsets().
          template getAsValueRange<IntegerAttr>().begin() + idx);
        return v.getSExtValue();
    }
    int64_t getStaticSize(unsigned idx) {
      assert(!(*static_cast<ConcreteOp *>(this)).isDynamicSize(idx) && "expected static size");
        APInt v = *(static_sizes().
          template getAsValueRange<IntegerAttr>().begin() + idx);
        return v.getSExtValue();
    }
    int64_t getStaticStride(unsigned idx) {
      assert(!(*static_cast<ConcreteOp *>(this)).isDynamicStride(idx) && "expected static stride");
        APInt v = *(static_strides().
          template getAsValueRange<IntegerAttr>().begin() + idx);
        return v.getSExtValue();
    }
    unsigned getIndexOfDynamicOffset(unsigned idx) {
      assert((*static_cast<ConcreteOp *>(this)).isDynamicOffset(idx) && "expected dynamic offset");
        auto numDynamic = getNumDynamicEntriesUpToIdx(
          static_offsets().template cast<ArrayAttr>(),
          ShapedType::isDynamicStrideOrOffset,
          idx);
        return (*static_cast<ConcreteOp *>(this)).getOffsetSizeAndStrideStartOperandIndex() + numDynamic;
    }
    unsigned getIndexOfDynamicSize(unsigned idx) {
      assert((*static_cast<ConcreteOp *>(this)).isDynamicSize(idx) && "expected dynamic size");
        auto numDynamic = getNumDynamicEntriesUpToIdx(
          static_sizes().template cast<ArrayAttr>(), ShapedType::isDynamic, idx);
        return (*static_cast<ConcreteOp *>(this)).getOffsetSizeAndStrideStartOperandIndex() +
          offsets().size() + numDynamic;
    }
    unsigned getIndexOfDynamicStride(unsigned idx) {
      assert((*static_cast<ConcreteOp *>(this)).isDynamicStride(idx) && "expected dynamic stride");
        auto numDynamic = getNumDynamicEntriesUpToIdx(
          static_strides().template cast<ArrayAttr>(),
          ShapedType::isDynamicStrideOrOffset,
          idx);
        return (*static_cast<ConcreteOp *>(this)).getOffsetSizeAndStrideStartOperandIndex() +
          offsets().size() + sizes().size() + numDynamic;
    }
    unsigned getNumDynamicEntriesUpToIdx(ArrayAttr attr, llvm::function_ref<bool(int64_t)> isDynamic, unsigned idx) {
      return std::count_if(
          attr.getValue().begin(), attr.getValue().begin() + idx,
          [&](Attribute attr) {
            return isDynamic(attr.cast<IntegerAttr>().getInt());
          });
    }
    Value getDynamicOffset(unsigned idx) {
      return (*static_cast<ConcreteOp *>(this)).getOperand(getIndexOfDynamicOffset(idx));
    }
    Value getDynamicSize(unsigned idx) {
      return (*static_cast<ConcreteOp *>(this)).getOperand(getIndexOfDynamicSize(idx));
    }
    Value getDynamicStride(unsigned idx) {
      return (*static_cast<ConcreteOp *>(this)).getOperand(getIndexOfDynamicStride(idx));
    }
    static ::mlir::LogicalResult verifyTrait(::mlir::Operation *op) {
      return mlir::verify(cast<OffsetSizeAndStrideOpInterface>(op));
    }
  };
  template <typename ConcreteOp>
  struct Trait : public OffsetSizeAndStrideOpInterfaceTrait<ConcreteOp> {};
  unsigned getOffsetSizeAndStrideStartOperandIndex();
  std::array<unsigned, 3> getArrayAttrRanks();
  OperandRange offsets();
  OperandRange sizes();
  OperandRange strides();
  ArrayAttr static_offsets();
  ArrayAttr static_sizes();
  ArrayAttr static_strides();
  SmallVector<OpFoldResult, 4> getMixedOffsets();
  SmallVector<OpFoldResult, 4> getMixedSizes();
  SmallVector<OpFoldResult, 4> getMixedStrides();
  bool isDynamicOffset(unsigned idx);
  bool isDynamicSize(unsigned idx);
  bool isDynamicStride(unsigned idx);
  int64_t getStaticOffset(unsigned idx);
  int64_t getStaticSize(unsigned idx);
  int64_t getStaticStride(unsigned idx);
  unsigned getIndexOfDynamicOffset(unsigned idx);
  unsigned getIndexOfDynamicSize(unsigned idx);
  unsigned getIndexOfDynamicStride(unsigned idx);
  unsigned getNumDynamicEntriesUpToIdx(ArrayAttr attr, llvm::function_ref<bool(int64_t)> isDynamic, unsigned idx);
  Value getDynamicOffset(unsigned idx);
  Value getDynamicSize(unsigned idx);
  Value getDynamicStride(unsigned idx);

    static unsigned getOffsetOperandGroupPosition() { return 0; }
    static unsigned getSizeOperandGroupPosition() { return 1; }
    static unsigned getStrideOperandGroupPosition() { return 2; }
    static StringRef getStaticOffsetsAttrName() {
      return "static_offsets";
    }
    static StringRef getStaticSizesAttrName() {
      return "static_sizes";
    }
    static StringRef getStaticStridesAttrName() {
      return "static_strides";
    }
    static ArrayRef<StringRef> getSpecialAttrNames() {
      static SmallVector<StringRef, 4> names{
        OffsetSizeAndStrideOpInterface::getStaticOffsetsAttrName(),
        OffsetSizeAndStrideOpInterface::getStaticSizesAttrName(),
        OffsetSizeAndStrideOpInterface::getStaticStridesAttrName(),
        OpTrait::AttrSizedOperandSegments<void>::getOperandSegmentSizeAttr()};
      return names;
   }
  
};
template<typename ConcreteOp>
unsigned detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::getOffsetSizeAndStrideStartOperandIndex(::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getOffsetSizeAndStrideStartOperandIndex();
}
template<typename ConcreteOp>
std::array<unsigned, 3> detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::getArrayAttrRanks(::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getArrayAttrRanks();
}
template<typename ConcreteOp>
OperandRange detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::offsets(::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).offsets();
}
template<typename ConcreteOp>
OperandRange detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::sizes(::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).sizes();
}
template<typename ConcreteOp>
OperandRange detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::strides(::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).strides();
}
template<typename ConcreteOp>
ArrayAttr detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::static_offsets(::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).static_offsets();
}
template<typename ConcreteOp>
ArrayAttr detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::static_sizes(::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).static_sizes();
}
template<typename ConcreteOp>
ArrayAttr detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::static_strides(::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).static_strides();
}
template<typename ConcreteOp>
SmallVector<OpFoldResult, 4> detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::getMixedOffsets(::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getMixedOffsets();
}
template<typename ConcreteOp>
SmallVector<OpFoldResult, 4> detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::getMixedSizes(::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getMixedSizes();
}
template<typename ConcreteOp>
SmallVector<OpFoldResult, 4> detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::getMixedStrides(::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getMixedStrides();
}
template<typename ConcreteOp>
bool detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::isDynamicOffset(::mlir::Operation *tablegen_opaque_val, unsigned idx) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).isDynamicOffset(idx);
}
template<typename ConcreteOp>
bool detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::isDynamicSize(::mlir::Operation *tablegen_opaque_val, unsigned idx) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).isDynamicSize(idx);
}
template<typename ConcreteOp>
bool detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::isDynamicStride(::mlir::Operation *tablegen_opaque_val, unsigned idx) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).isDynamicStride(idx);
}
template<typename ConcreteOp>
int64_t detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::getStaticOffset(::mlir::Operation *tablegen_opaque_val, unsigned idx) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getStaticOffset(idx);
}
template<typename ConcreteOp>
int64_t detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::getStaticSize(::mlir::Operation *tablegen_opaque_val, unsigned idx) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getStaticSize(idx);
}
template<typename ConcreteOp>
int64_t detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::getStaticStride(::mlir::Operation *tablegen_opaque_val, unsigned idx) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getStaticStride(idx);
}
template<typename ConcreteOp>
unsigned detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::getIndexOfDynamicOffset(::mlir::Operation *tablegen_opaque_val, unsigned idx) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getIndexOfDynamicOffset(idx);
}
template<typename ConcreteOp>
unsigned detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::getIndexOfDynamicSize(::mlir::Operation *tablegen_opaque_val, unsigned idx) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getIndexOfDynamicSize(idx);
}
template<typename ConcreteOp>
unsigned detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::getIndexOfDynamicStride(::mlir::Operation *tablegen_opaque_val, unsigned idx) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getIndexOfDynamicStride(idx);
}
template<typename ConcreteOp>
unsigned detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::getNumDynamicEntriesUpToIdx(::mlir::Operation *tablegen_opaque_val, ArrayAttr attr, llvm::function_ref<bool(int64_t)> isDynamic, unsigned idx) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getNumDynamicEntriesUpToIdx(attr, isDynamic, idx);
}
template<typename ConcreteOp>
Value detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::getDynamicOffset(::mlir::Operation *tablegen_opaque_val, unsigned idx) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getDynamicOffset(idx);
}
template<typename ConcreteOp>
Value detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::getDynamicSize(::mlir::Operation *tablegen_opaque_val, unsigned idx) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getDynamicSize(idx);
}
template<typename ConcreteOp>
Value detail::OffsetSizeAndStrideOpInterfaceInterfaceTraits::Model<ConcreteOp>::getDynamicStride(::mlir::Operation *tablegen_opaque_val, unsigned idx) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getDynamicStride(idx);
}
} // namespace mlir
namespace mlir {
class ViewLikeOpInterface;
namespace detail {
struct ViewLikeOpInterfaceInterfaceTraits {
  struct Concept {
    Value (*getViewSource)(::mlir::Operation *);
  };
  template<typename ConcreteOp>
  class Model : public Concept {
  public:
    Model() : Concept{getViewSource} {}

    static inline Value getViewSource(::mlir::Operation *tablegen_opaque_val);
  };
};
} // end namespace detail
class ViewLikeOpInterface : public ::mlir::OpInterface<ViewLikeOpInterface, detail::ViewLikeOpInterfaceInterfaceTraits> {
public:
  using ::mlir::OpInterface<ViewLikeOpInterface, detail::ViewLikeOpInterfaceInterfaceTraits>::OpInterface;
  template <typename ConcreteOp>
  struct ViewLikeOpInterfaceTrait : public ::mlir::OpInterface<ViewLikeOpInterface, detail::ViewLikeOpInterfaceInterfaceTraits>::Trait<ConcreteOp> {
  };
  template <typename ConcreteOp>
  struct Trait : public ViewLikeOpInterfaceTrait<ConcreteOp> {};
  Value getViewSource();
};
template<typename ConcreteOp>
Value detail::ViewLikeOpInterfaceInterfaceTraits::Model<ConcreteOp>::getViewSource(::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getViewSource();
}
} // namespace mlir
