/* Autogenerated by mlir-tblgen; don't manually edit */
#ifdef GEN_PASS_CLASSES

//===----------------------------------------------------------------------===//
// SCFBufferize
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class SCFBufferizeBase : public ::mlir::FunctionPass {
public:
  SCFBufferizeBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  SCFBufferizeBase(const SCFBufferizeBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "scf-bufferize"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "SCFBufferize"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// SCFForLoopSpecialization
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class SCFForLoopSpecializationBase : public ::mlir::FunctionPass {
public:
  SCFForLoopSpecializationBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  SCFForLoopSpecializationBase(const SCFForLoopSpecializationBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "for-loop-specialization"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "SCFForLoopSpecialization"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// SCFParallelLoopFusion
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class SCFParallelLoopFusionBase : public ::mlir::OperationPass<> {
public:
  SCFParallelLoopFusionBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  SCFParallelLoopFusionBase(const SCFParallelLoopFusionBase &) : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "parallel-loop-fusion"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "SCFParallelLoopFusion"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// SCFParallelLoopSpecialization
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class SCFParallelLoopSpecializationBase : public ::mlir::FunctionPass {
public:
  SCFParallelLoopSpecializationBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  SCFParallelLoopSpecializationBase(const SCFParallelLoopSpecializationBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "parallel-loop-specialization"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "SCFParallelLoopSpecialization"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// SCFParallelLoopTiling
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class SCFParallelLoopTilingBase : public ::mlir::FunctionPass {
public:
  SCFParallelLoopTilingBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  SCFParallelLoopTilingBase(const SCFParallelLoopTilingBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "parallel-loop-tiling"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "SCFParallelLoopTiling"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<AffineDialect>();

  }

protected:
  ::mlir::Pass::ListOption<int64_t> tileSizes{*this, "parallel-loop-tile-sizes", ::llvm::cl::desc("Factors to tile parallel loops by"), llvm::cl::ZeroOrMore, llvm::cl::MiscFlags::CommaSeparated};
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// SCFBufferize Registration
//===----------------------------------------------------------------------===//

inline void registerSCFBufferizePass() {
  ::mlir::registerPass("scf-bufferize", "Bufferize the scf dialect.", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createSCFBufferizePass();
  });
}

//===----------------------------------------------------------------------===//
// SCFForLoopSpecialization Registration
//===----------------------------------------------------------------------===//

inline void registerSCFForLoopSpecializationPass() {
  ::mlir::registerPass("for-loop-specialization", "Specialize `for` loops for vectorization", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createForLoopSpecializationPass();
  });
}

//===----------------------------------------------------------------------===//
// SCFParallelLoopFusion Registration
//===----------------------------------------------------------------------===//

inline void registerSCFParallelLoopFusionPass() {
  ::mlir::registerPass("parallel-loop-fusion", "Fuse adjacent parallel loops", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createParallelLoopFusionPass();
  });
}

//===----------------------------------------------------------------------===//
// SCFParallelLoopSpecialization Registration
//===----------------------------------------------------------------------===//

inline void registerSCFParallelLoopSpecializationPass() {
  ::mlir::registerPass("parallel-loop-specialization", "Specialize parallel loops for vectorization", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createParallelLoopSpecializationPass();
  });
}

//===----------------------------------------------------------------------===//
// SCFParallelLoopTiling Registration
//===----------------------------------------------------------------------===//

inline void registerSCFParallelLoopTilingPass() {
  ::mlir::registerPass("parallel-loop-tiling", "Tile parallel loops", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createParallelLoopTilingPass();
  });
}

//===----------------------------------------------------------------------===//
// SCF Registration
//===----------------------------------------------------------------------===//

inline void registerSCFPasses() {
  registerSCFBufferizePass();
  registerSCFForLoopSpecializationPass();
  registerSCFParallelLoopFusionPass();
  registerSCFParallelLoopSpecializationPass();
  registerSCFParallelLoopTilingPass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
