
    ArrayAttr MatmulOp::iterator_types() {
      return Builder(getContext()).getStrArrayAttr(SmallVector<StringRef, 8>{ getParallelIteratorTypeName(), getParallelIteratorTypeName(), getReductionIteratorTypeName() });
    }
  // This is temporary until we transition out of manually specified ops that
  // should be auto-generated with linalg-ods-gen.
  ArrayAttr MatmulOp::indexing_maps() {
    MLIRContext *context = getContext();
    AffineExpr d0, d1, d2;
    bindDims(context, d0, d1, d2);
    
	auto s0 = getAffineSymbolExpr(0, context); (void)s0;
	auto s1 = getAffineSymbolExpr(1, context); (void)s1;
	auto s2 = getAffineSymbolExpr(2, context); (void)s2;
	auto map0 = AffineMap::get(3, 3, {d0, d2}, context);
	map0 = map0.replaceDimsAndSymbols({}, { s0, s1, s2 }, 3, 0);
	map0 = simplifyAffineMap(map0);
	auto map1 = AffineMap::get(3, 3, {d2, d1}, context);
	map1 = map1.replaceDimsAndSymbols({}, { s0, s1, s2 }, 3, 0);
	map1 = simplifyAffineMap(map1);
	auto map2 = AffineMap::get(3, 3, {d0, d1}, context);
	map2 = map2.replaceDimsAndSymbols({}, { s0, s1, s2 }, 3, 0);
	map2 = simplifyAffineMap(map2);
    return Builder(context).getAffineMapArrayAttr({ map0, map1, map2 });
  }
  void MatmulOp::regionBuilder(Block &block) {
    using namespace edsc;
    using namespace intrinsics;
    auto args = block.getArguments();
    Value _0(args[0]), _1(args[1]), _2(args[2]);
    
    Value _4 = std_mulf(_0, _1);
    Value _5 = std_addf(_2, _4);
    (linalg_yield(ValueRange{ _5 }));
  }
    void MatmulOp::getCanonicalizationPatterns(
        OwningRewritePatternList &results,
        MLIRContext *context) {
      results.insert<EraseDeadLinalgOp>();
      results.insert<FoldTensorCastOp>();
    }
    LogicalResult MatmulOp::fold(ArrayRef<Attribute>,
                            SmallVectorImpl<OpFoldResult> &) {
      return foldMemRefCast(*this);
    }
    void MatmulOp::getEffects(SmallVectorImpl<
        SideEffects::EffectInstance<MemoryEffects::Effect> >&effects) {
      getGenericEffectsImpl(effects,
        getOperation()->getResults(), getInputBuffers(), getOutputBuffers());
    }

    ArrayAttr MatvecOp::iterator_types() {
      return Builder(getContext()).getStrArrayAttr(SmallVector<StringRef, 8>{ getParallelIteratorTypeName(), getReductionIteratorTypeName() });
    }
  // This is temporary until we transition out of manually specified ops that
  // should be auto-generated with linalg-ods-gen.
  ArrayAttr MatvecOp::indexing_maps() {
    MLIRContext *context = getContext();
    AffineExpr d0, d1;
    bindDims(context, d0, d1);
    
	auto s0 = getAffineSymbolExpr(0, context); (void)s0;
	auto s1 = getAffineSymbolExpr(1, context); (void)s1;
	auto map0 = AffineMap::get(2, 2, {d0, d1}, context);
	map0 = map0.replaceDimsAndSymbols({}, { s0, s1 }, 2, 0);
	map0 = simplifyAffineMap(map0);
	auto map1 = AffineMap::get(2, 2, {d1}, context);
	map1 = map1.replaceDimsAndSymbols({}, { s0, s1 }, 2, 0);
	map1 = simplifyAffineMap(map1);
	auto map2 = AffineMap::get(2, 2, {d0}, context);
	map2 = map2.replaceDimsAndSymbols({}, { s0, s1 }, 2, 0);
	map2 = simplifyAffineMap(map2);
    return Builder(context).getAffineMapArrayAttr({ map0, map1, map2 });
  }
  void MatvecOp::regionBuilder(Block &block) {
    using namespace edsc;
    using namespace intrinsics;
    auto args = block.getArguments();
    Value _0(args[0]), _1(args[1]), _2(args[2]);
    
    Value _4 = std_mulf(_0, _1);
    Value _5 = std_addf(_2, _4);
    (linalg_yield(ValueRange{ _5 }));
  }
    void MatvecOp::getCanonicalizationPatterns(
        OwningRewritePatternList &results,
        MLIRContext *context) {
      results.insert<EraseDeadLinalgOp>();
      results.insert<FoldTensorCastOp>();
    }
    LogicalResult MatvecOp::fold(ArrayRef<Attribute>,
                            SmallVectorImpl<OpFoldResult> &) {
      return foldMemRefCast(*this);
    }
    void MatvecOp::getEffects(SmallVectorImpl<
        SideEffects::EffectInstance<MemoryEffects::Effect> >&effects) {
      getGenericEffectsImpl(effects,
        getOperation()->getResults(), getInputBuffers(), getOutputBuffers());
    }

    ArrayAttr VecmatOp::iterator_types() {
      return Builder(getContext()).getStrArrayAttr(SmallVector<StringRef, 8>{ getParallelIteratorTypeName(), getReductionIteratorTypeName() });
    }
  // This is temporary until we transition out of manually specified ops that
  // should be auto-generated with linalg-ods-gen.
  ArrayAttr VecmatOp::indexing_maps() {
    MLIRContext *context = getContext();
    AffineExpr d0, d1;
    bindDims(context, d0, d1);
    
	auto s0 = getAffineSymbolExpr(0, context); (void)s0;
	auto s1 = getAffineSymbolExpr(1, context); (void)s1;
	auto map0 = AffineMap::get(2, 2, {d1}, context);
	map0 = map0.replaceDimsAndSymbols({}, { s0, s1 }, 2, 0);
	map0 = simplifyAffineMap(map0);
	auto map1 = AffineMap::get(2, 2, {d1, d0}, context);
	map1 = map1.replaceDimsAndSymbols({}, { s0, s1 }, 2, 0);
	map1 = simplifyAffineMap(map1);
	auto map2 = AffineMap::get(2, 2, {d0}, context);
	map2 = map2.replaceDimsAndSymbols({}, { s0, s1 }, 2, 0);
	map2 = simplifyAffineMap(map2);
    return Builder(context).getAffineMapArrayAttr({ map0, map1, map2 });
  }
  void VecmatOp::regionBuilder(Block &block) {
    using namespace edsc;
    using namespace intrinsics;
    auto args = block.getArguments();
    Value _0(args[0]), _1(args[1]), _2(args[2]);
    
    Value _4 = std_mulf(_0, _1);
    Value _5 = std_addf(_2, _4);
    (linalg_yield(ValueRange{ _5 }));
  }
    void VecmatOp::getCanonicalizationPatterns(
        OwningRewritePatternList &results,
        MLIRContext *context) {
      results.insert<EraseDeadLinalgOp>();
      results.insert<FoldTensorCastOp>();
    }
    LogicalResult VecmatOp::fold(ArrayRef<Attribute>,
                            SmallVectorImpl<OpFoldResult> &) {
      return foldMemRefCast(*this);
    }
    void VecmatOp::getEffects(SmallVectorImpl<
        SideEffects::EffectInstance<MemoryEffects::Effect> >&effects) {
      getGenericEffectsImpl(effects,
        getOperation()->getResults(), getInputBuffers(), getOutputBuffers());
    }

    ArrayAttr DotOp::iterator_types() {
      return Builder(getContext()).getStrArrayAttr(SmallVector<StringRef, 8>{ getReductionIteratorTypeName() });
    }
  // This is temporary until we transition out of manually specified ops that
  // should be auto-generated with linalg-ods-gen.
  ArrayAttr DotOp::indexing_maps() {
    MLIRContext *context = getContext();
    AffineExpr d0;
    bindDims(context, d0);
    
	auto s0 = getAffineSymbolExpr(0, context); (void)s0;
	auto map0 = AffineMap::get(1, 1, {d0}, context);
	map0 = map0.replaceDimsAndSymbols({}, { s0 }, 1, 0);
	map0 = simplifyAffineMap(map0);
	auto map1 = AffineMap::get(1, 1, {d0}, context);
	map1 = map1.replaceDimsAndSymbols({}, { s0 }, 1, 0);
	map1 = simplifyAffineMap(map1);
	auto map2 = AffineMap::get(1, 1, {}, context);
	map2 = map2.replaceDimsAndSymbols({}, { s0 }, 1, 0);
	map2 = simplifyAffineMap(map2);
    return Builder(context).getAffineMapArrayAttr({ map0, map1, map2 });
  }
  void DotOp::regionBuilder(Block &block) {
    using namespace edsc;
    using namespace intrinsics;
    auto args = block.getArguments();
    Value _0(args[0]), _1(args[1]), _2(args[2]);
    
    Value _4 = std_mulf(_0, _1);
    Value _5 = std_addf(_2, _4);
    (linalg_yield(ValueRange{ _5 }));
  }
    void DotOp::getCanonicalizationPatterns(
        OwningRewritePatternList &results,
        MLIRContext *context) {
      results.insert<EraseDeadLinalgOp>();
      results.insert<FoldTensorCastOp>();
    }
    LogicalResult DotOp::fold(ArrayRef<Attribute>,
                            SmallVectorImpl<OpFoldResult> &) {
      return foldMemRefCast(*this);
    }
    void DotOp::getEffects(SmallVectorImpl<
        SideEffects::EffectInstance<MemoryEffects::Effect> >&effects) {
      getGenericEffectsImpl(effects,
        getOperation()->getResults(), getInputBuffers(), getOutputBuffers());
    }

    ArrayAttr BatchMatmulOp::iterator_types() {
      return Builder(getContext()).getStrArrayAttr(SmallVector<StringRef, 8>{ getParallelIteratorTypeName(), getParallelIteratorTypeName(), getParallelIteratorTypeName(), getReductionIteratorTypeName() });
    }
  // This is temporary until we transition out of manually specified ops that
  // should be auto-generated with linalg-ods-gen.
  ArrayAttr BatchMatmulOp::indexing_maps() {
    MLIRContext *context = getContext();
    AffineExpr d0, d1, d2, d3;
    bindDims(context, d0, d1, d2, d3);
    
	auto s0 = getAffineSymbolExpr(0, context); (void)s0;
	auto s1 = getAffineSymbolExpr(1, context); (void)s1;
	auto s2 = getAffineSymbolExpr(2, context); (void)s2;
	auto s3 = getAffineSymbolExpr(3, context); (void)s3;
	auto map0 = AffineMap::get(4, 4, {d0, d1, d3}, context);
	map0 = map0.replaceDimsAndSymbols({}, { s0, s1, s2, s3 }, 4, 0);
	map0 = simplifyAffineMap(map0);
	auto map1 = AffineMap::get(4, 4, {d0, d3, d2}, context);
	map1 = map1.replaceDimsAndSymbols({}, { s0, s1, s2, s3 }, 4, 0);
	map1 = simplifyAffineMap(map1);
	auto map2 = AffineMap::get(4, 4, {d0, d1, d2}, context);
	map2 = map2.replaceDimsAndSymbols({}, { s0, s1, s2, s3 }, 4, 0);
	map2 = simplifyAffineMap(map2);
    return Builder(context).getAffineMapArrayAttr({ map0, map1, map2 });
  }
  void BatchMatmulOp::regionBuilder(Block &block) {
    using namespace edsc;
    using namespace intrinsics;
    auto args = block.getArguments();
    Value _0(args[0]), _1(args[1]), _2(args[2]);
    
    Value _4 = std_mulf(_0, _1);
    Value _5 = std_addf(_2, _4);
    (linalg_yield(ValueRange{ _5 }));
  }
    void BatchMatmulOp::getCanonicalizationPatterns(
        OwningRewritePatternList &results,
        MLIRContext *context) {
      results.insert<EraseDeadLinalgOp>();
      results.insert<FoldTensorCastOp>();
    }
    LogicalResult BatchMatmulOp::fold(ArrayRef<Attribute>,
                            SmallVectorImpl<OpFoldResult> &) {
      return foldMemRefCast(*this);
    }
    void BatchMatmulOp::getEffects(SmallVectorImpl<
        SideEffects::EffectInstance<MemoryEffects::Effect> >&effects) {
      getGenericEffectsImpl(effects,
        getOperation()->getResults(), getInputBuffers(), getOutputBuffers());
    }

    ArrayAttr ConvWOp::iterator_types() {
      return Builder(getContext()).getStrArrayAttr(SmallVector<StringRef, 8>{ getParallelIteratorTypeName(), getReductionIteratorTypeName() });
    }
  // This is temporary until we transition out of manually specified ops that
  // should be auto-generated with linalg-ods-gen.
  ArrayAttr ConvWOp::indexing_maps() {
    MLIRContext *context = getContext();
    AffineExpr d0, d1;
    bindDims(context, d0, d1);
    
	auto s0 = getAffineSymbolExpr(0, context); (void)s0;
	auto s1 = getAffineSymbolExpr(1, context); (void)s1;
	auto map0 = AffineMap::get(2, 2, {d0 + d1}, context);
	map0 = map0.replaceDimsAndSymbols({}, { s0, s1 }, 2, 0);
	map0 = simplifyAffineMap(map0);
	auto map1 = AffineMap::get(2, 2, {d1}, context);
	map1 = map1.replaceDimsAndSymbols({}, { s0, s1 }, 2, 0);
	map1 = simplifyAffineMap(map1);
	auto map2 = AffineMap::get(2, 2, {d0}, context);
	map2 = map2.replaceDimsAndSymbols({}, { s0, s1 }, 2, 0);
	map2 = simplifyAffineMap(map2);
    return Builder(context).getAffineMapArrayAttr({ map0, map1, map2 });
  }
  void ConvWOp::regionBuilder(Block &block) {
    using namespace edsc;
    using namespace intrinsics;
    auto args = block.getArguments();
    Value _0(args[0]), _1(args[1]), _2(args[2]);
    
    Value _4 = std_mulf(_0, _1);
    Value _5 = std_addf(_2, _4);
    (linalg_yield(ValueRange{ _5 }));
  }
    void ConvWOp::getCanonicalizationPatterns(
        OwningRewritePatternList &results,
        MLIRContext *context) {
      results.insert<EraseDeadLinalgOp>();
      results.insert<FoldTensorCastOp>();
    }
    LogicalResult ConvWOp::fold(ArrayRef<Attribute>,
                            SmallVectorImpl<OpFoldResult> &) {
      return foldMemRefCast(*this);
    }
    void ConvWOp::getEffects(SmallVectorImpl<
        SideEffects::EffectInstance<MemoryEffects::Effect> >&effects) {
      getGenericEffectsImpl(effects,
        getOperation()->getResults(), getInputBuffers(), getOutputBuffers());
    }

    ArrayAttr ConvNWCOp::iterator_types() {
      return Builder(getContext()).getStrArrayAttr(SmallVector<StringRef, 8>{ getParallelIteratorTypeName(), getParallelIteratorTypeName(), getParallelIteratorTypeName(), getReductionIteratorTypeName(), getParallelIteratorTypeName() });
    }
  // This is temporary until we transition out of manually specified ops that
  // should be auto-generated with linalg-ods-gen.
  ArrayAttr ConvNWCOp::indexing_maps() {
    MLIRContext *context = getContext();
    AffineExpr d0, d1, d2, d3, d4;
    bindDims(context, d0, d1, d2, d3, d4);
    
	auto s0 = getAffineSymbolExpr(0, context); (void)s0;
	auto s1 = getAffineSymbolExpr(1, context); (void)s1;
	auto s2 = getAffineSymbolExpr(2, context); (void)s2;
	auto s3 = getAffineSymbolExpr(3, context); (void)s3;
	auto s4 = getAffineSymbolExpr(4, context); (void)s4;
	auto map0 = AffineMap::get(5, 5, {d0, d1 + d3, d4}, context);
	map0 = map0.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4 }, 5, 0);
	map0 = simplifyAffineMap(map0);
	auto map1 = AffineMap::get(5, 5, {d2, d3, d4}, context);
	map1 = map1.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4 }, 5, 0);
	map1 = simplifyAffineMap(map1);
	auto map2 = AffineMap::get(5, 5, {d0, d1, d2}, context);
	map2 = map2.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4 }, 5, 0);
	map2 = simplifyAffineMap(map2);
    return Builder(context).getAffineMapArrayAttr({ map0, map1, map2 });
  }
  void ConvNWCOp::regionBuilder(Block &block) {
    using namespace edsc;
    using namespace intrinsics;
    auto args = block.getArguments();
    Value _0(args[0]), _1(args[1]), _2(args[2]);
    
    Value _4 = std_mulf(_0, _1);
    Value _5 = std_addf(_2, _4);
    (linalg_yield(ValueRange{ _5 }));
  }
    void ConvNWCOp::getCanonicalizationPatterns(
        OwningRewritePatternList &results,
        MLIRContext *context) {
      results.insert<EraseDeadLinalgOp>();
      results.insert<FoldTensorCastOp>();
    }
    LogicalResult ConvNWCOp::fold(ArrayRef<Attribute>,
                            SmallVectorImpl<OpFoldResult> &) {
      return foldMemRefCast(*this);
    }
    void ConvNWCOp::getEffects(SmallVectorImpl<
        SideEffects::EffectInstance<MemoryEffects::Effect> >&effects) {
      getGenericEffectsImpl(effects,
        getOperation()->getResults(), getInputBuffers(), getOutputBuffers());
    }

    ArrayAttr ConvNCWOp::iterator_types() {
      return Builder(getContext()).getStrArrayAttr(SmallVector<StringRef, 8>{ getParallelIteratorTypeName(), getParallelIteratorTypeName(), getParallelIteratorTypeName(), getReductionIteratorTypeName(), getParallelIteratorTypeName() });
    }
  // This is temporary until we transition out of manually specified ops that
  // should be auto-generated with linalg-ods-gen.
  ArrayAttr ConvNCWOp::indexing_maps() {
    MLIRContext *context = getContext();
    AffineExpr d0, d1, d2, d3, d4;
    bindDims(context, d0, d1, d2, d3, d4);
    
	auto s0 = getAffineSymbolExpr(0, context); (void)s0;
	auto s1 = getAffineSymbolExpr(1, context); (void)s1;
	auto s2 = getAffineSymbolExpr(2, context); (void)s2;
	auto s3 = getAffineSymbolExpr(3, context); (void)s3;
	auto s4 = getAffineSymbolExpr(4, context); (void)s4;
	auto map0 = AffineMap::get(5, 5, {d0, d4, d2 + d3}, context);
	map0 = map0.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4 }, 5, 0);
	map0 = simplifyAffineMap(map0);
	auto map1 = AffineMap::get(5, 5, {d1, d4, d3}, context);
	map1 = map1.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4 }, 5, 0);
	map1 = simplifyAffineMap(map1);
	auto map2 = AffineMap::get(5, 5, {d0, d1, d2}, context);
	map2 = map2.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4 }, 5, 0);
	map2 = simplifyAffineMap(map2);
    return Builder(context).getAffineMapArrayAttr({ map0, map1, map2 });
  }
  void ConvNCWOp::regionBuilder(Block &block) {
    using namespace edsc;
    using namespace intrinsics;
    auto args = block.getArguments();
    Value _0(args[0]), _1(args[1]), _2(args[2]);
    
    Value _4 = std_mulf(_0, _1);
    Value _5 = std_addf(_2, _4);
    (linalg_yield(ValueRange{ _5 }));
  }
    void ConvNCWOp::getCanonicalizationPatterns(
        OwningRewritePatternList &results,
        MLIRContext *context) {
      results.insert<EraseDeadLinalgOp>();
      results.insert<FoldTensorCastOp>();
    }
    LogicalResult ConvNCWOp::fold(ArrayRef<Attribute>,
                            SmallVectorImpl<OpFoldResult> &) {
      return foldMemRefCast(*this);
    }
    void ConvNCWOp::getEffects(SmallVectorImpl<
        SideEffects::EffectInstance<MemoryEffects::Effect> >&effects) {
      getGenericEffectsImpl(effects,
        getOperation()->getResults(), getInputBuffers(), getOutputBuffers());
    }

    ArrayAttr ConvHWOp::iterator_types() {
      return Builder(getContext()).getStrArrayAttr(SmallVector<StringRef, 8>{ getParallelIteratorTypeName(), getParallelIteratorTypeName(), getReductionIteratorTypeName(), getReductionIteratorTypeName() });
    }
  // This is temporary until we transition out of manually specified ops that
  // should be auto-generated with linalg-ods-gen.
  ArrayAttr ConvHWOp::indexing_maps() {
    MLIRContext *context = getContext();
    AffineExpr d0, d1, d2, d3;
    bindDims(context, d0, d1, d2, d3);
    
	auto s0 = getAffineSymbolExpr(0, context); (void)s0;
	auto s1 = getAffineSymbolExpr(1, context); (void)s1;
	auto s2 = getAffineSymbolExpr(2, context); (void)s2;
	auto s3 = getAffineSymbolExpr(3, context); (void)s3;
	auto map0 = AffineMap::get(4, 4, {d0 + d2, d1 + d3}, context);
	map0 = map0.replaceDimsAndSymbols({}, { s0, s1, s2, s3 }, 4, 0);
	map0 = simplifyAffineMap(map0);
	auto map1 = AffineMap::get(4, 4, {d2, d3}, context);
	map1 = map1.replaceDimsAndSymbols({}, { s0, s1, s2, s3 }, 4, 0);
	map1 = simplifyAffineMap(map1);
	auto map2 = AffineMap::get(4, 4, {d0, d1}, context);
	map2 = map2.replaceDimsAndSymbols({}, { s0, s1, s2, s3 }, 4, 0);
	map2 = simplifyAffineMap(map2);
    return Builder(context).getAffineMapArrayAttr({ map0, map1, map2 });
  }
  void ConvHWOp::regionBuilder(Block &block) {
    using namespace edsc;
    using namespace intrinsics;
    auto args = block.getArguments();
    Value _0(args[0]), _1(args[1]), _2(args[2]);
    
    Value _4 = std_mulf(_0, _1);
    Value _5 = std_addf(_2, _4);
    (linalg_yield(ValueRange{ _5 }));
  }
    void ConvHWOp::getCanonicalizationPatterns(
        OwningRewritePatternList &results,
        MLIRContext *context) {
      results.insert<EraseDeadLinalgOp>();
      results.insert<FoldTensorCastOp>();
    }
    LogicalResult ConvHWOp::fold(ArrayRef<Attribute>,
                            SmallVectorImpl<OpFoldResult> &) {
      return foldMemRefCast(*this);
    }
    void ConvHWOp::getEffects(SmallVectorImpl<
        SideEffects::EffectInstance<MemoryEffects::Effect> >&effects) {
      getGenericEffectsImpl(effects,
        getOperation()->getResults(), getInputBuffers(), getOutputBuffers());
    }

    ArrayAttr ConvNHWCOp::iterator_types() {
      return Builder(getContext()).getStrArrayAttr(SmallVector<StringRef, 8>{ getParallelIteratorTypeName(), getParallelIteratorTypeName(), getParallelIteratorTypeName(), getParallelIteratorTypeName(), getReductionIteratorTypeName(), getReductionIteratorTypeName(), getParallelIteratorTypeName() });
    }
  // This is temporary until we transition out of manually specified ops that
  // should be auto-generated with linalg-ods-gen.
  ArrayAttr ConvNHWCOp::indexing_maps() {
    MLIRContext *context = getContext();
    AffineExpr d0, d1, d2, d3, d4, d5, d6;
    bindDims(context, d0, d1, d2, d3, d4, d5, d6);
    
	auto s0 = getAffineSymbolExpr(0, context); (void)s0;
	auto s1 = getAffineSymbolExpr(1, context); (void)s1;
	auto s2 = getAffineSymbolExpr(2, context); (void)s2;
	auto s3 = getAffineSymbolExpr(3, context); (void)s3;
	auto s4 = getAffineSymbolExpr(4, context); (void)s4;
	auto s5 = getAffineSymbolExpr(5, context); (void)s5;
	auto s6 = getAffineSymbolExpr(6, context); (void)s6;
	auto map0 = AffineMap::get(7, 7, {d0, d1 + d4, d2 + d5, d6}, context);
	map0 = map0.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4, s5, s6 }, 7, 0);
	map0 = simplifyAffineMap(map0);
	auto map1 = AffineMap::get(7, 7, {d3, d4, d5, d6}, context);
	map1 = map1.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4, s5, s6 }, 7, 0);
	map1 = simplifyAffineMap(map1);
	auto map2 = AffineMap::get(7, 7, {d0, d1, d2, d3}, context);
	map2 = map2.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4, s5, s6 }, 7, 0);
	map2 = simplifyAffineMap(map2);
    return Builder(context).getAffineMapArrayAttr({ map0, map1, map2 });
  }
  void ConvNHWCOp::regionBuilder(Block &block) {
    using namespace edsc;
    using namespace intrinsics;
    auto args = block.getArguments();
    Value _0(args[0]), _1(args[1]), _2(args[2]);
    
    Value _4 = std_mulf(_0, _1);
    Value _5 = std_addf(_2, _4);
    (linalg_yield(ValueRange{ _5 }));
  }
    void ConvNHWCOp::getCanonicalizationPatterns(
        OwningRewritePatternList &results,
        MLIRContext *context) {
      results.insert<EraseDeadLinalgOp>();
      results.insert<FoldTensorCastOp>();
    }
    LogicalResult ConvNHWCOp::fold(ArrayRef<Attribute>,
                            SmallVectorImpl<OpFoldResult> &) {
      return foldMemRefCast(*this);
    }
    void ConvNHWCOp::getEffects(SmallVectorImpl<
        SideEffects::EffectInstance<MemoryEffects::Effect> >&effects) {
      getGenericEffectsImpl(effects,
        getOperation()->getResults(), getInputBuffers(), getOutputBuffers());
    }

    ArrayAttr ConvNCHWOp::iterator_types() {
      return Builder(getContext()).getStrArrayAttr(SmallVector<StringRef, 8>{ getParallelIteratorTypeName(), getParallelIteratorTypeName(), getParallelIteratorTypeName(), getParallelIteratorTypeName(), getReductionIteratorTypeName(), getReductionIteratorTypeName(), getParallelIteratorTypeName() });
    }
  // This is temporary until we transition out of manually specified ops that
  // should be auto-generated with linalg-ods-gen.
  ArrayAttr ConvNCHWOp::indexing_maps() {
    MLIRContext *context = getContext();
    AffineExpr d0, d1, d2, d3, d4, d5, d6;
    bindDims(context, d0, d1, d2, d3, d4, d5, d6);
    
	auto s0 = getAffineSymbolExpr(0, context); (void)s0;
	auto s1 = getAffineSymbolExpr(1, context); (void)s1;
	auto s2 = getAffineSymbolExpr(2, context); (void)s2;
	auto s3 = getAffineSymbolExpr(3, context); (void)s3;
	auto s4 = getAffineSymbolExpr(4, context); (void)s4;
	auto s5 = getAffineSymbolExpr(5, context); (void)s5;
	auto s6 = getAffineSymbolExpr(6, context); (void)s6;
	auto map0 = AffineMap::get(7, 7, {d0, d6, d2 + d4, d3 + d5}, context);
	map0 = map0.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4, s5, s6 }, 7, 0);
	map0 = simplifyAffineMap(map0);
	auto map1 = AffineMap::get(7, 7, {d1, d6, d4, d5}, context);
	map1 = map1.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4, s5, s6 }, 7, 0);
	map1 = simplifyAffineMap(map1);
	auto map2 = AffineMap::get(7, 7, {d0, d1, d2, d3}, context);
	map2 = map2.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4, s5, s6 }, 7, 0);
	map2 = simplifyAffineMap(map2);
    return Builder(context).getAffineMapArrayAttr({ map0, map1, map2 });
  }
  void ConvNCHWOp::regionBuilder(Block &block) {
    using namespace edsc;
    using namespace intrinsics;
    auto args = block.getArguments();
    Value _0(args[0]), _1(args[1]), _2(args[2]);
    
    Value _4 = std_mulf(_0, _1);
    Value _5 = std_addf(_2, _4);
    (linalg_yield(ValueRange{ _5 }));
  }
    void ConvNCHWOp::getCanonicalizationPatterns(
        OwningRewritePatternList &results,
        MLIRContext *context) {
      results.insert<EraseDeadLinalgOp>();
      results.insert<FoldTensorCastOp>();
    }
    LogicalResult ConvNCHWOp::fold(ArrayRef<Attribute>,
                            SmallVectorImpl<OpFoldResult> &) {
      return foldMemRefCast(*this);
    }
    void ConvNCHWOp::getEffects(SmallVectorImpl<
        SideEffects::EffectInstance<MemoryEffects::Effect> >&effects) {
      getGenericEffectsImpl(effects,
        getOperation()->getResults(), getInputBuffers(), getOutputBuffers());
    }

    ArrayAttr ConvDHWOp::iterator_types() {
      return Builder(getContext()).getStrArrayAttr(SmallVector<StringRef, 8>{ getParallelIteratorTypeName(), getParallelIteratorTypeName(), getParallelIteratorTypeName(), getReductionIteratorTypeName(), getReductionIteratorTypeName(), getReductionIteratorTypeName() });
    }
  // This is temporary until we transition out of manually specified ops that
  // should be auto-generated with linalg-ods-gen.
  ArrayAttr ConvDHWOp::indexing_maps() {
    MLIRContext *context = getContext();
    AffineExpr d0, d1, d2, d3, d4, d5;
    bindDims(context, d0, d1, d2, d3, d4, d5);
    
	auto s0 = getAffineSymbolExpr(0, context); (void)s0;
	auto s1 = getAffineSymbolExpr(1, context); (void)s1;
	auto s2 = getAffineSymbolExpr(2, context); (void)s2;
	auto s3 = getAffineSymbolExpr(3, context); (void)s3;
	auto s4 = getAffineSymbolExpr(4, context); (void)s4;
	auto s5 = getAffineSymbolExpr(5, context); (void)s5;
	auto map0 = AffineMap::get(6, 6, {d0 + d3, d1 + d4, d2 + d5}, context);
	map0 = map0.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4, s5 }, 6, 0);
	map0 = simplifyAffineMap(map0);
	auto map1 = AffineMap::get(6, 6, {d3, d4, d5}, context);
	map1 = map1.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4, s5 }, 6, 0);
	map1 = simplifyAffineMap(map1);
	auto map2 = AffineMap::get(6, 6, {d0, d1, d2}, context);
	map2 = map2.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4, s5 }, 6, 0);
	map2 = simplifyAffineMap(map2);
    return Builder(context).getAffineMapArrayAttr({ map0, map1, map2 });
  }
  void ConvDHWOp::regionBuilder(Block &block) {
    using namespace edsc;
    using namespace intrinsics;
    auto args = block.getArguments();
    Value _0(args[0]), _1(args[1]), _2(args[2]);
    
    Value _4 = std_mulf(_0, _1);
    Value _5 = std_addf(_2, _4);
    (linalg_yield(ValueRange{ _5 }));
  }
    void ConvDHWOp::getCanonicalizationPatterns(
        OwningRewritePatternList &results,
        MLIRContext *context) {
      results.insert<EraseDeadLinalgOp>();
      results.insert<FoldTensorCastOp>();
    }
    LogicalResult ConvDHWOp::fold(ArrayRef<Attribute>,
                            SmallVectorImpl<OpFoldResult> &) {
      return foldMemRefCast(*this);
    }
    void ConvDHWOp::getEffects(SmallVectorImpl<
        SideEffects::EffectInstance<MemoryEffects::Effect> >&effects) {
      getGenericEffectsImpl(effects,
        getOperation()->getResults(), getInputBuffers(), getOutputBuffers());
    }

    ArrayAttr ConvNDHWCOp::iterator_types() {
      return Builder(getContext()).getStrArrayAttr(SmallVector<StringRef, 8>{ getParallelIteratorTypeName(), getParallelIteratorTypeName(), getParallelIteratorTypeName(), getParallelIteratorTypeName(), getParallelIteratorTypeName(), getReductionIteratorTypeName(), getReductionIteratorTypeName(), getReductionIteratorTypeName(), getParallelIteratorTypeName() });
    }
  // This is temporary until we transition out of manually specified ops that
  // should be auto-generated with linalg-ods-gen.
  ArrayAttr ConvNDHWCOp::indexing_maps() {
    MLIRContext *context = getContext();
    AffineExpr d0, d1, d2, d3, d4, d5, d6, d7, d8;
    bindDims(context, d0, d1, d2, d3, d4, d5, d6, d7, d8);
    
	auto s0 = getAffineSymbolExpr(0, context); (void)s0;
	auto s1 = getAffineSymbolExpr(1, context); (void)s1;
	auto s2 = getAffineSymbolExpr(2, context); (void)s2;
	auto s3 = getAffineSymbolExpr(3, context); (void)s3;
	auto s4 = getAffineSymbolExpr(4, context); (void)s4;
	auto s5 = getAffineSymbolExpr(5, context); (void)s5;
	auto s6 = getAffineSymbolExpr(6, context); (void)s6;
	auto s7 = getAffineSymbolExpr(7, context); (void)s7;
	auto s8 = getAffineSymbolExpr(8, context); (void)s8;
	auto map0 = AffineMap::get(9, 9, {d0, d1 + d5, d2 + d6, d3 + d7, d8}, context);
	map0 = map0.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4, s5, s6, s7, s8 }, 9, 0);
	map0 = simplifyAffineMap(map0);
	auto map1 = AffineMap::get(9, 9, {d4, d5, d6, d7, d8}, context);
	map1 = map1.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4, s5, s6, s7, s8 }, 9, 0);
	map1 = simplifyAffineMap(map1);
	auto map2 = AffineMap::get(9, 9, {d0, d1, d2, d3, d4}, context);
	map2 = map2.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4, s5, s6, s7, s8 }, 9, 0);
	map2 = simplifyAffineMap(map2);
    return Builder(context).getAffineMapArrayAttr({ map0, map1, map2 });
  }
  void ConvNDHWCOp::regionBuilder(Block &block) {
    using namespace edsc;
    using namespace intrinsics;
    auto args = block.getArguments();
    Value _0(args[0]), _1(args[1]), _2(args[2]);
    
    Value _4 = std_mulf(_0, _1);
    Value _5 = std_addf(_2, _4);
    (linalg_yield(ValueRange{ _5 }));
  }
    void ConvNDHWCOp::getCanonicalizationPatterns(
        OwningRewritePatternList &results,
        MLIRContext *context) {
      results.insert<EraseDeadLinalgOp>();
      results.insert<FoldTensorCastOp>();
    }
    LogicalResult ConvNDHWCOp::fold(ArrayRef<Attribute>,
                            SmallVectorImpl<OpFoldResult> &) {
      return foldMemRefCast(*this);
    }
    void ConvNDHWCOp::getEffects(SmallVectorImpl<
        SideEffects::EffectInstance<MemoryEffects::Effect> >&effects) {
      getGenericEffectsImpl(effects,
        getOperation()->getResults(), getInputBuffers(), getOutputBuffers());
    }

    ArrayAttr ConvNCDHWOp::iterator_types() {
      return Builder(getContext()).getStrArrayAttr(SmallVector<StringRef, 8>{ getParallelIteratorTypeName(), getParallelIteratorTypeName(), getParallelIteratorTypeName(), getParallelIteratorTypeName(), getParallelIteratorTypeName(), getReductionIteratorTypeName(), getReductionIteratorTypeName(), getReductionIteratorTypeName(), getParallelIteratorTypeName() });
    }
  // This is temporary until we transition out of manually specified ops that
  // should be auto-generated with linalg-ods-gen.
  ArrayAttr ConvNCDHWOp::indexing_maps() {
    MLIRContext *context = getContext();
    AffineExpr d0, d1, d2, d3, d4, d5, d6, d7, d8;
    bindDims(context, d0, d1, d2, d3, d4, d5, d6, d7, d8);
    
	auto s0 = getAffineSymbolExpr(0, context); (void)s0;
	auto s1 = getAffineSymbolExpr(1, context); (void)s1;
	auto s2 = getAffineSymbolExpr(2, context); (void)s2;
	auto s3 = getAffineSymbolExpr(3, context); (void)s3;
	auto s4 = getAffineSymbolExpr(4, context); (void)s4;
	auto s5 = getAffineSymbolExpr(5, context); (void)s5;
	auto s6 = getAffineSymbolExpr(6, context); (void)s6;
	auto s7 = getAffineSymbolExpr(7, context); (void)s7;
	auto s8 = getAffineSymbolExpr(8, context); (void)s8;
	auto map0 = AffineMap::get(9, 9, {d0, d8, d2 + d5, d3 + d6, d4 + d7}, context);
	map0 = map0.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4, s5, s6, s7, s8 }, 9, 0);
	map0 = simplifyAffineMap(map0);
	auto map1 = AffineMap::get(9, 9, {d1, d8, d5, d6, d7}, context);
	map1 = map1.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4, s5, s6, s7, s8 }, 9, 0);
	map1 = simplifyAffineMap(map1);
	auto map2 = AffineMap::get(9, 9, {d0, d1, d2, d3, d4}, context);
	map2 = map2.replaceDimsAndSymbols({}, { s0, s1, s2, s3, s4, s5, s6, s7, s8 }, 9, 0);
	map2 = simplifyAffineMap(map2);
    return Builder(context).getAffineMapArrayAttr({ map0, map1, map2 });
  }
  void ConvNCDHWOp::regionBuilder(Block &block) {
    using namespace edsc;
    using namespace intrinsics;
    auto args = block.getArguments();
    Value _0(args[0]), _1(args[1]), _2(args[2]);
    
    Value _4 = std_mulf(_0, _1);
    Value _5 = std_addf(_2, _4);
    (linalg_yield(ValueRange{ _5 }));
  }
    void ConvNCDHWOp::getCanonicalizationPatterns(
        OwningRewritePatternList &results,
        MLIRContext *context) {
      results.insert<EraseDeadLinalgOp>();
      results.insert<FoldTensorCastOp>();
    }
    LogicalResult ConvNCDHWOp::fold(ArrayRef<Attribute>,
                            SmallVectorImpl<OpFoldResult> &) {
      return foldMemRefCast(*this);
    }
    void ConvNCDHWOp::getEffects(SmallVectorImpl<
        SideEffects::EffectInstance<MemoryEffects::Effect> >&effects) {
      getGenericEffectsImpl(effects,
        getOperation()->getResults(), getInputBuffers(), getOutputBuffers());
    }
