/* Autogenerated by mlir-tblgen; don't manually edit */
#ifdef GEN_PASS_CLASSES

//===----------------------------------------------------------------------===//
// ConvertAffineForToGPU
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertAffineForToGPUBase : public ::mlir::FunctionPass {
public:
  ConvertAffineForToGPUBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  ConvertAffineForToGPUBase(const ConvertAffineForToGPUBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-affine-for-to-gpu"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertAffineForToGPU"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<gpu::GPUDialect>();

  }

protected:
  ::mlir::Pass::Option<unsigned> numBlockDims{*this, "gpu-block-dims", ::llvm::cl::desc("Number of GPU block dimensions for mapping"), ::llvm::cl::init(1u)};
  ::mlir::Pass::Option<unsigned> numThreadDims{*this, "gpu-thread-dims", ::llvm::cl::desc("Number of GPU thread dimensions for mapping"), ::llvm::cl::init(1u)};
};

//===----------------------------------------------------------------------===//
// ConvertAffineToStandard
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertAffineToStandardBase : public ::mlir::OperationPass<> {
public:
  ConvertAffineToStandardBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertAffineToStandardBase(const ConvertAffineToStandardBase &) : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "lower-affine"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertAffineToStandard"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<scf::SCFDialect>();

  registry.insert<StandardOpsDialect>();

  registry.insert<vector::VectorDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertAsyncToLLVM
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertAsyncToLLVMBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertAsyncToLLVMBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertAsyncToLLVMBase(const ConvertAsyncToLLVMBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-async-to-llvm"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertAsyncToLLVM"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<LLVM::LLVMDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertComplexToLLVM
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertComplexToLLVMBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertComplexToLLVMBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertComplexToLLVMBase(const ConvertComplexToLLVMBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-complex-to-llvm"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertComplexToLLVM"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<LLVM::LLVMDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertGPUToSPIRV
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertGPUToSPIRVBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertGPUToSPIRVBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertGPUToSPIRVBase(const ConvertGPUToSPIRVBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-gpu-to-spirv"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertGPUToSPIRV"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<spirv::SPIRVDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertGpuLaunchFuncToVulkanLaunchFunc
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertGpuLaunchFuncToVulkanLaunchFuncBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertGpuLaunchFuncToVulkanLaunchFuncBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertGpuLaunchFuncToVulkanLaunchFuncBase(const ConvertGpuLaunchFuncToVulkanLaunchFuncBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-gpu-launch-to-vulkan-launch"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertGpuLaunchFuncToVulkanLaunchFunc"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<spirv::SPIRVDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertGpuOpsToNVVMOps
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertGpuOpsToNVVMOpsBase : public ::mlir::OperationPass<gpu::GPUModuleOp> {
public:
  ConvertGpuOpsToNVVMOpsBase() : ::mlir::OperationPass<gpu::GPUModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertGpuOpsToNVVMOpsBase(const ConvertGpuOpsToNVVMOpsBase &) : ::mlir::OperationPass<gpu::GPUModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-gpu-to-nvvm"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertGpuOpsToNVVMOps"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<NVVM::NVVMDialect>();

  }

protected:
  ::mlir::Pass::Option<unsigned> indexBitwidth{*this, "index-bitwidth", ::llvm::cl::desc("Bitwidth of the index type, 0 to use size of machine word"), ::llvm::cl::init(0)};
};

//===----------------------------------------------------------------------===//
// ConvertGpuOpsToROCDLOps
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertGpuOpsToROCDLOpsBase : public ::mlir::OperationPass<gpu::GPUModuleOp> {
public:
  ConvertGpuOpsToROCDLOpsBase() : ::mlir::OperationPass<gpu::GPUModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertGpuOpsToROCDLOpsBase(const ConvertGpuOpsToROCDLOpsBase &) : ::mlir::OperationPass<gpu::GPUModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-gpu-to-rocdl"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertGpuOpsToROCDLOps"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<ROCDL::ROCDLDialect>();

  }

protected:
  ::mlir::Pass::Option<unsigned> indexBitwidth{*this, "index-bitwidth", ::llvm::cl::desc("Bitwidth of the index type, 0 to use size of machine word"), ::llvm::cl::init(0)};
};

//===----------------------------------------------------------------------===//
// ConvertLinalgToLLVM
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertLinalgToLLVMBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertLinalgToLLVMBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertLinalgToLLVMBase(const ConvertLinalgToLLVMBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-linalg-to-llvm"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertLinalgToLLVM"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<scf::SCFDialect>();

  registry.insert<LLVM::LLVMDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertLinalgToSPIRV
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertLinalgToSPIRVBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertLinalgToSPIRVBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertLinalgToSPIRVBase(const ConvertLinalgToSPIRVBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-linalg-to-spirv"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertLinalgToSPIRV"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<spirv::SPIRVDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertLinalgToStandard
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertLinalgToStandardBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertLinalgToStandardBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertLinalgToStandardBase(const ConvertLinalgToStandardBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-linalg-to-std"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertLinalgToStandard"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<StandardOpsDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertOpenMPToLLVM
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertOpenMPToLLVMBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertOpenMPToLLVMBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertOpenMPToLLVMBase(const ConvertOpenMPToLLVMBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-openmp-to-llvm"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertOpenMPToLLVM"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<LLVM::LLVMDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertPDLToPDLInterp
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertPDLToPDLInterpBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertPDLToPDLInterpBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertPDLToPDLInterpBase(const ConvertPDLToPDLInterpBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-pdl-to-pdl-interp"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertPDLToPDLInterp"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<pdl_interp::PDLInterpDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertParallelLoopToGpu
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertParallelLoopToGpuBase : public ::mlir::OperationPass<> {
public:
  ConvertParallelLoopToGpuBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertParallelLoopToGpuBase(const ConvertParallelLoopToGpuBase &) : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-parallel-loops-to-gpu"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertParallelLoopToGpu"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<AffineDialect>();

  registry.insert<gpu::GPUDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertSCFToOpenMP
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertSCFToOpenMPBase : public ::mlir::FunctionPass {
public:
  ConvertSCFToOpenMPBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  ConvertSCFToOpenMPBase(const ConvertSCFToOpenMPBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-scf-to-openmp"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertSCFToOpenMP"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<omp::OpenMPDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertSPIRVToLLVM
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertSPIRVToLLVMBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertSPIRVToLLVMBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertSPIRVToLLVMBase(const ConvertSPIRVToLLVMBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-spirv-to-llvm"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertSPIRVToLLVM"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<LLVM::LLVMDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertShapeConstraints
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertShapeConstraintsBase : public ::mlir::OperationPass<FuncOp> {
public:
  ConvertShapeConstraintsBase() : ::mlir::OperationPass<FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertShapeConstraintsBase(const ConvertShapeConstraintsBase &) : ::mlir::OperationPass<FuncOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-shape-constraints"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertShapeConstraints"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<StandardOpsDialect>();

  registry.insert<scf::SCFDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertShapeToStandard
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertShapeToStandardBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertShapeToStandardBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertShapeToStandardBase(const ConvertShapeToStandardBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-shape-to-std"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertShapeToStandard"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<StandardOpsDialect>();

  registry.insert<scf::SCFDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertStandardToLLVM
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertStandardToLLVMBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertStandardToLLVMBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertStandardToLLVMBase(const ConvertStandardToLLVMBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-std-to-llvm"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertStandardToLLVM"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<LLVM::LLVMDialect>();

  }

protected:
  ::mlir::Pass::Option<bool> useAlignedAlloc{*this, "use-aligned-alloc", ::llvm::cl::desc("Use aligned_alloc in place of malloc for heap allocations"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> useBarePtrCallConv{*this, "use-bare-ptr-memref-call-conv", ::llvm::cl::desc("Replace FuncOp's MemRef arguments with bare pointers to the MemRef element types"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> emitCWrappers{*this, "emit-c-wrappers", ::llvm::cl::desc("Emit wrappers for C-compatible pointer-to-struct memref descriptors"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<unsigned> indexBitwidth{*this, "index-bitwidth", ::llvm::cl::desc("Bitwidth of the index type, 0 to use size of machine word"), ::llvm::cl::init(0)};
  ::mlir::Pass::Option<std::string> dataLayout{*this, "data-layout", ::llvm::cl::desc("String description (LLVM format) of the data layout that is expected on the produced module"), ::llvm::cl::init("")};
};

//===----------------------------------------------------------------------===//
// ConvertStandardToSPIRV
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertStandardToSPIRVBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertStandardToSPIRVBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertStandardToSPIRVBase(const ConvertStandardToSPIRVBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-std-to-spirv"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertStandardToSPIRV"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<spirv::SPIRVDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertVectorToLLVM
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertVectorToLLVMBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertVectorToLLVMBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertVectorToLLVMBase(const ConvertVectorToLLVMBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-vector-to-llvm"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertVectorToLLVM"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
  ::mlir::Pass::Option<bool> reassociateFPReductions{*this, "reassociate-fp-reductions", ::llvm::cl::desc("Allows llvm to reassociate floating-point reductions for speed"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> enableIndexOptimizations{*this, "enable-index-optimizations", ::llvm::cl::desc("Allows compiler to assume indices fit in 32-bit if that yields faster code"), ::llvm::cl::init(true)};
  ::mlir::Pass::Option<bool> enableAVX512{*this, "enable-avx512", ::llvm::cl::desc("Enables the use of AVX512 dialect while lowering the vector dialect."), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> enableArmNeon{*this, "enable-arm-neon", ::llvm::cl::desc("Enables the use of ArmNeon dialect while lowering the vector dialect."), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> enableArmSVE{*this, "enable-arm-sve", ::llvm::cl::desc("Enables the use of ArmSVE dialect while lowering the vector dialect."), ::llvm::cl::init(false)};
};

//===----------------------------------------------------------------------===//
// ConvertVectorToROCDL
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertVectorToROCDLBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertVectorToROCDLBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertVectorToROCDLBase(const ConvertVectorToROCDLBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-vector-to-rocdl"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertVectorToROCDL"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<ROCDL::ROCDLDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertVectorToSCF
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertVectorToSCFBase : public ::mlir::FunctionPass {
public:
  ConvertVectorToSCFBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  ConvertVectorToSCFBase(const ConvertVectorToSCFBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-vector-to-scf"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertVectorToSCF"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<AffineDialect>();

  registry.insert<scf::SCFDialect>();

  }

protected:
  ::mlir::Pass::Option<bool> fullUnroll{*this, "full-unroll", ::llvm::cl::desc("Perform full unrolling when converting vector transfers to SCF"), ::llvm::cl::init(false)};
};

//===----------------------------------------------------------------------===//
// ConvertVectorToSPIRV
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertVectorToSPIRVBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertVectorToSPIRVBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertVectorToSPIRVBase(const ConvertVectorToSPIRVBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-vector-to-spirv"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertVectorToSPIRV"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<spirv::SPIRVDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// ConvertVulkanLaunchFuncToVulkanCalls
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertVulkanLaunchFuncToVulkanCallsBase : public ::mlir::OperationPass<ModuleOp> {
public:
  ConvertVulkanLaunchFuncToVulkanCallsBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertVulkanLaunchFuncToVulkanCallsBase(const ConvertVulkanLaunchFuncToVulkanCallsBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "launch-func-to-vulkan"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "ConvertVulkanLaunchFuncToVulkanCalls"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<LLVM::LLVMDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// GpuToLLVMConversionPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class GpuToLLVMConversionPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  GpuToLLVMConversionPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  GpuToLLVMConversionPassBase(const GpuToLLVMConversionPassBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "gpu-to-llvm"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "GpuToLLVMConversionPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<LLVM::LLVMDialect>();

  }

protected:
  ::mlir::Pass::Option<std::string> gpuBinaryAnnotation{*this, "gpu-binary-annotation", ::llvm::cl::desc("Annotation attribute string for GPU binary")};
};

//===----------------------------------------------------------------------===//
// LegalizeStandardForSPIRV
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LegalizeStandardForSPIRVBase : public ::mlir::OperationPass<> {
public:
  LegalizeStandardForSPIRVBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  LegalizeStandardForSPIRVBase(const LegalizeStandardForSPIRVBase &) : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "legalize-std-for-spirv"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "LegalizeStandardForSPIRV"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<spirv::SPIRVDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// LowerHostCodeToLLVM
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LowerHostCodeToLLVMBase : public ::mlir::OperationPass<ModuleOp> {
public:
  LowerHostCodeToLLVMBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  LowerHostCodeToLLVMBase(const LowerHostCodeToLLVMBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "lower-host-to-llvm"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "LowerHostCodeToLLVM"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<LLVM::LLVMDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// SCFToSPIRV
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class SCFToSPIRVBase : public ::mlir::OperationPass<ModuleOp> {
public:
  SCFToSPIRVBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SCFToSPIRVBase(const SCFToSPIRVBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-scf-to-spirv"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "SCFToSPIRV"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<spirv::SPIRVDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// SCFToStandard
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class SCFToStandardBase : public ::mlir::OperationPass<> {
public:
  SCFToStandardBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  SCFToStandardBase(const SCFToStandardBase &) : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "convert-scf-to-std"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "SCFToStandard"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<StandardOpsDialect>();

  }

protected:
};

//===----------------------------------------------------------------------===//
// TosaToLinalgOnTensors
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TosaToLinalgOnTensorsBase : public ::mlir::FunctionPass {
public:
  TosaToLinalgOnTensorsBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  TosaToLinalgOnTensorsBase(const TosaToLinalgOnTensorsBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  ::llvm::StringRef getArgument() const override { return "tosa-to-linalg-on-tensors"; }

  /// Returns the derived pass name.
  ::llvm::StringRef getName() const override { return "TosaToLinalgOnTensors"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// ConvertAffineForToGPU Registration
//===----------------------------------------------------------------------===//

inline void registerConvertAffineForToGPUPass() {
  ::mlir::registerPass("convert-affine-for-to-gpu", "Convert top-level AffineFor Ops to GPU kernels", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createAffineForToGPUPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertAffineToStandard Registration
//===----------------------------------------------------------------------===//

inline void registerConvertAffineToStandardPass() {
  ::mlir::registerPass("lower-affine", "Lower Affine operations to a combination of Standard and SCF operations", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createLowerAffinePass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertAsyncToLLVM Registration
//===----------------------------------------------------------------------===//

inline void registerConvertAsyncToLLVMPass() {
  ::mlir::registerPass("convert-async-to-llvm", "Convert the operations from the async dialect into the LLVM dialect", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createConvertAsyncToLLVMPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertComplexToLLVM Registration
//===----------------------------------------------------------------------===//

inline void registerConvertComplexToLLVMPass() {
  ::mlir::registerPass("convert-complex-to-llvm", "Convert Complex dialect to LLVM dialect", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createConvertComplexToLLVMPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertGPUToSPIRV Registration
//===----------------------------------------------------------------------===//

inline void registerConvertGPUToSPIRVPass() {
  ::mlir::registerPass("convert-gpu-to-spirv", "Convert GPU dialect to SPIR-V dialect", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createConvertGPUToSPIRVPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertGpuLaunchFuncToVulkanLaunchFunc Registration
//===----------------------------------------------------------------------===//

inline void registerConvertGpuLaunchFuncToVulkanLaunchFuncPass() {
  ::mlir::registerPass("convert-gpu-launch-to-vulkan-launch", "Convert gpu.launch_func to vulkanLaunch external call", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createConvertGpuLaunchFuncToVulkanLaunchFuncPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertGpuOpsToNVVMOps Registration
//===----------------------------------------------------------------------===//

inline void registerConvertGpuOpsToNVVMOpsPass() {
  ::mlir::registerPass("convert-gpu-to-nvvm", "Generate NVVM operations for gpu operations", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createLowerGpuOpsToNVVMOpsPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertGpuOpsToROCDLOps Registration
//===----------------------------------------------------------------------===//

inline void registerConvertGpuOpsToROCDLOpsPass() {
  ::mlir::registerPass("convert-gpu-to-rocdl", "Generate ROCDL operations for gpu operations", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createLowerGpuOpsToROCDLOpsPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertLinalgToLLVM Registration
//===----------------------------------------------------------------------===//

inline void registerConvertLinalgToLLVMPass() {
  ::mlir::registerPass("convert-linalg-to-llvm", "Convert the operations from the linalg dialect into the LLVM dialect", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createConvertLinalgToLLVMPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertLinalgToSPIRV Registration
//===----------------------------------------------------------------------===//

inline void registerConvertLinalgToSPIRVPass() {
  ::mlir::registerPass("convert-linalg-to-spirv", "Convert Linalg dialect to SPIR-V dialect", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createLinalgToSPIRVPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertLinalgToStandard Registration
//===----------------------------------------------------------------------===//

inline void registerConvertLinalgToStandardPass() {
  ::mlir::registerPass("convert-linalg-to-std", "Convert the operations from the linalg dialect into the Standard dialect", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createConvertLinalgToStandardPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertOpenMPToLLVM Registration
//===----------------------------------------------------------------------===//

inline void registerConvertOpenMPToLLVMPass() {
  ::mlir::registerPass("convert-openmp-to-llvm", "Convert the OpenMP ops to OpenMP ops with LLVM dialect", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createConvertOpenMPToLLVMPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertPDLToPDLInterp Registration
//===----------------------------------------------------------------------===//

inline void registerConvertPDLToPDLInterpPass() {
  ::mlir::registerPass("convert-pdl-to-pdl-interp", "Convert PDL ops to PDL interpreter ops", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createPDLToPDLInterpPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertParallelLoopToGpu Registration
//===----------------------------------------------------------------------===//

inline void registerConvertParallelLoopToGpuPass() {
  ::mlir::registerPass("convert-parallel-loops-to-gpu", "Convert mapped scf.parallel ops to gpu launch operations", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createParallelLoopToGpuPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertSCFToOpenMP Registration
//===----------------------------------------------------------------------===//

inline void registerConvertSCFToOpenMPPass() {
  ::mlir::registerPass("convert-scf-to-openmp", "Convert SCF parallel loop to OpenMP parallel + workshare constructs.", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createConvertSCFToOpenMPPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertSPIRVToLLVM Registration
//===----------------------------------------------------------------------===//

inline void registerConvertSPIRVToLLVMPass() {
  ::mlir::registerPass("convert-spirv-to-llvm", "Convert SPIR-V dialect to LLVM dialect", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createConvertSPIRVToLLVMPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertShapeConstraints Registration
//===----------------------------------------------------------------------===//

inline void registerConvertShapeConstraintsPass() {
  ::mlir::registerPass("convert-shape-constraints", "Convert shape constraint operations to the standard dialect", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createConvertShapeConstraintsPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertShapeToStandard Registration
//===----------------------------------------------------------------------===//

inline void registerConvertShapeToStandardPass() {
  ::mlir::registerPass("convert-shape-to-std", "Convert operations from the shape dialect into the standard dialect", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createConvertShapeToStandardPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertStandardToLLVM Registration
//===----------------------------------------------------------------------===//

inline void registerConvertStandardToLLVMPass() {
  ::mlir::registerPass("convert-std-to-llvm", "Convert scalar and vector operations from the Standard to the LLVM dialect", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createLowerToLLVMPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertStandardToSPIRV Registration
//===----------------------------------------------------------------------===//

inline void registerConvertStandardToSPIRVPass() {
  ::mlir::registerPass("convert-std-to-spirv", "Convert Standard dialect to SPIR-V dialect", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createConvertStandardToSPIRVPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertVectorToLLVM Registration
//===----------------------------------------------------------------------===//

inline void registerConvertVectorToLLVMPass() {
  ::mlir::registerPass("convert-vector-to-llvm", "Lower the operations from the vector dialect into the LLVM dialect", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createConvertVectorToLLVMPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertVectorToROCDL Registration
//===----------------------------------------------------------------------===//

inline void registerConvertVectorToROCDLPass() {
  ::mlir::registerPass("convert-vector-to-rocdl", "Lower the operations from the vector dialect into the ROCDL dialect", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createConvertVectorToROCDLPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertVectorToSCF Registration
//===----------------------------------------------------------------------===//

inline void registerConvertVectorToSCFPass() {
  ::mlir::registerPass("convert-vector-to-scf", "Lower the operations from the vector dialect into the SCF dialect", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createConvertVectorToSCFPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertVectorToSPIRV Registration
//===----------------------------------------------------------------------===//

inline void registerConvertVectorToSPIRVPass() {
  ::mlir::registerPass("convert-vector-to-spirv", "Convert Vector dialect to SPIR-V dialect", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createConvertVectorToSPIRVPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertVulkanLaunchFuncToVulkanCalls Registration
//===----------------------------------------------------------------------===//

inline void registerConvertVulkanLaunchFuncToVulkanCallsPass() {
  ::mlir::registerPass("launch-func-to-vulkan", "Convert vulkanLaunch external call to Vulkan runtime external calls", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createConvertVulkanLaunchFuncToVulkanCallsPass();
  });
}

//===----------------------------------------------------------------------===//
// GpuToLLVMConversionPass Registration
//===----------------------------------------------------------------------===//

inline void registerGpuToLLVMConversionPassPass() {
  ::mlir::registerPass("gpu-to-llvm", "Convert GPU dialect to LLVM dialect with GPU runtime calls", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createGpuToLLVMConversionPass();
  });
}

//===----------------------------------------------------------------------===//
// LegalizeStandardForSPIRV Registration
//===----------------------------------------------------------------------===//

inline void registerLegalizeStandardForSPIRVPass() {
  ::mlir::registerPass("legalize-std-for-spirv", "Legalize standard ops for SPIR-V lowering", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createLegalizeStdOpsForSPIRVLoweringPass();
  });
}

//===----------------------------------------------------------------------===//
// LowerHostCodeToLLVM Registration
//===----------------------------------------------------------------------===//

inline void registerLowerHostCodeToLLVMPass() {
  ::mlir::registerPass("lower-host-to-llvm", "Lowers the host module code and `gpu.launch_func` to LLVM", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createLowerHostCodeToLLVMPass();
  });
}

//===----------------------------------------------------------------------===//
// SCFToSPIRV Registration
//===----------------------------------------------------------------------===//

inline void registerSCFToSPIRVPass() {
  ::mlir::registerPass("convert-scf-to-spirv", "Convert SCF dialect to SPIR-V dialect.", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createConvertSCFToSPIRVPass();
  });
}

//===----------------------------------------------------------------------===//
// SCFToStandard Registration
//===----------------------------------------------------------------------===//

inline void registerSCFToStandardPass() {
  ::mlir::registerPass("convert-scf-to-std", "Convert SCF dialect to Standard dialect, replacing structured control flow with a CFG", []() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createLowerToCFGPass();
  });
}

//===----------------------------------------------------------------------===//
// TosaToLinalgOnTensors Registration
//===----------------------------------------------------------------------===//

inline void registerTosaToLinalgOnTensorsPass() {
  ::mlir::registerPass("tosa-to-linalg-on-tensors", "Lower TOSA to LinAlg on tensors", []() -> std::unique_ptr<::mlir::Pass> {
    return tosa::createTosaToLinalgOnTensors();
  });
}

//===----------------------------------------------------------------------===//
// Conversion Registration
//===----------------------------------------------------------------------===//

inline void registerConversionPasses() {
  registerConvertAffineForToGPUPass();
  registerConvertAffineToStandardPass();
  registerConvertAsyncToLLVMPass();
  registerConvertComplexToLLVMPass();
  registerConvertGPUToSPIRVPass();
  registerConvertGpuLaunchFuncToVulkanLaunchFuncPass();
  registerConvertGpuOpsToNVVMOpsPass();
  registerConvertGpuOpsToROCDLOpsPass();
  registerConvertLinalgToLLVMPass();
  registerConvertLinalgToSPIRVPass();
  registerConvertLinalgToStandardPass();
  registerConvertOpenMPToLLVMPass();
  registerConvertPDLToPDLInterpPass();
  registerConvertParallelLoopToGpuPass();
  registerConvertSCFToOpenMPPass();
  registerConvertSPIRVToLLVMPass();
  registerConvertShapeConstraintsPass();
  registerConvertShapeToStandardPass();
  registerConvertStandardToLLVMPass();
  registerConvertStandardToSPIRVPass();
  registerConvertVectorToLLVMPass();
  registerConvertVectorToROCDLPass();
  registerConvertVectorToSCFPass();
  registerConvertVectorToSPIRVPass();
  registerConvertVulkanLaunchFuncToVulkanCallsPass();
  registerGpuToLLVMConversionPassPass();
  registerLegalizeStandardForSPIRVPass();
  registerLowerHostCodeToLLVMPass();
  registerSCFToSPIRVPass();
  registerSCFToStandardPass();
  registerTosaToLinalgOnTensorsPass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
