
import sys
from os import path

from misaka import *
from misaka.utils import extension_map, html_flag_map


help = '''\
Usage: misaka [--ext-<extension>...] [--html-<flag>...] [--smartypants] [<file>...]

Parser extensions:
{}

Render flags:
{}

Other options:
  --smartypants
  -h | --help
'''.format(
    '\n'.join(['  --ext-' + a for a in extension_map.keys()]),
    '\n'.join(['  --html-' + a for a in html_flag_map.keys()]))


if __name__ == '__main__':
    args = sys.argv[1:]

    files = []
    flags = []
    extensions = []
    pants_enabled = False

    for arg in args:
        if arg in ('-h', '--help'):
            print(help)
            sys.exit(0)
        elif arg == '--smartypants':
            pants_enabled = True
        elif arg.startswith('--ext-'):
            arg = arg[6:]
            if not arg in extension_map:
                print('--ext-{} is not a valid Markdown extension'.format(arg))
                sys.exit(1)
            extensions.append(arg)
        elif arg.startswith('--html-'):
            arg = arg[7:]
            if not arg in html_flag_map:
                print('--html-{} is not a valid HTML render flag'.format(arg))
                sys.exit(1)
            flags.append(arg)
        else:
            # If it's not a extension or HTML flag,
            # then it must be a file, right?
            files.append(arg)

    renderer = HtmlRenderer(flags)
    if pants_enabled:
        to_html = lambda n: smartypants(Markdown(renderer, extensions)(n))
    else:
        to_html = Markdown(renderer, extensions)

    if files:
        for fn in files:
            fn = path.abspath(fn)
            if not path.exists(fn):
                print('Does not exist: %s' % fn)
            else:
                with open(fn, 'r') as fd:
                    source = fd.read()
                print(to_html(source))
    else:
        print(to_html(sys.stdin.read()))
