#
# mercurial - scalable distributed SCM
#
# Copyright 2005-2007 Matt Mackall <mpm@selenic.com>
#
# This software may be used and distributed according to the terms of the
# GNU General Public License version 2 or any later version.

import os
import sys

if os.environ.get('HGUNICODEPEDANTRY', False):
    try:
        reload(sys)
        sys.setdefaultencoding("undefined")
    except NameError:
        pass

libdir = '..\\Lib\\site-packages\\'

if libdir != '@' 'LIBDIR' '@':
    if not os.path.isabs(libdir):
        libdir = os.path.join(os.path.dirname(os.path.realpath(__file__)),
                              libdir)
        libdir = os.path.abspath(libdir)
    sys.path.insert(0, libdir)

# enable importing on demand to reduce startup time
try:
    if sys.version_info[0] < 3:
        from mercurial import demandimport; demandimport.enable()
except ImportError:
    sys.stderr.write("abort: couldn't find mercurial libraries in [%s]\n" %
                     ' '.join(sys.path))
    sys.stderr.write("(check your install and PYTHONPATH)\n")
    sys.exit(-1)

import mercurial.util
import mercurial.dispatch

for fp in (sys.stdin, sys.stdout, sys.stderr):
    mercurial.util.setbinary(fp)

mercurial.dispatch.run()
