
# Copyright (c) 2013 Jose M. Dana
#
# This file is part of memprof.
#
# memprof is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation (version 3 of the License only).
#
# memprof is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with memprof.  If not, see <http://www.gnu.org/licenses/>.

from memprof.mp_utils import *

import argparse

if __name__ == '__main__':
    parser = argparse.ArgumentParser()

    parser.add_argument('-t','--threshold',type=int, default=default_threshold, action='store', help='threshold (default: %d bytes)' % default_threshold)
    parser.add_argument('logfiles', type=str, default=None, nargs='+', help='the logfiles')

    args, unknown = parser.parse_known_args()

    if not args.logfiles:
        parser.print_help()
        sys.exit(1)

    units, factor = get_units_factor(args.threshold)

    for logfile in args.logfiles:
        print("Processing %s with threshold = %.2f %s" % (logfile, args.threshold / factor, units))
        try:
            gen_plot(logfile, args.threshold)
        except IOError as e:
            print(e)
