# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.xml_writer_base import XMLWriterBase


class XMLWriter(XMLWriterBase):
    """
    XMLWriter - Superclass for VTK's XML file writers.
    
    Superclass: XMLWriterBase
    
    XMLWriter provides methods implementing most of the functionality
    needed to write VTK XML file formats.  Concrete subclasses provide
    actual writer implementations calling upon this functionality.
    
    @par Thanks compression_level getters/setters exposed by Quincy
    Wofford (qwofford@lanl.gov) and John Patchett (patchett@lanl.gov),
    Los Alamos National Laboratory (2017)
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkXMLWriter, obj, update, **traits)
    
    number_of_time_steps = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _number_of_time_steps_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfTimeSteps,
                        self.number_of_time_steps)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)
        get_input(self) -> DataObject
        C++: DataObject *get_input()"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def set_input_data(self, *args):
        """
        set_input_data(self, __a:DataObject) -> None
        C++: void set_input_data(DataObject *)
        set_input_data(self, __a:int, __b:DataObject) -> None
        C++: void set_input_data(int, DataObject *)
        Assign a data object as input. Note that this method does not
        establish a pipeline connection. Use set_input_connection() to
        setup a pipeline connection.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInputData, *my_args)
        return ret

    def start(self):
        """
        start(self) -> None
        C++: void start()
        API to interface an outside the VTK pipeline control
        """
        ret = self._vtk_obj.Start()
        return ret
        

    def stop(self):
        """
        stop(self) -> None
        C++: void stop()"""
        ret = self._vtk_obj.Stop()
        return ret
        

    def write_next_time(self, *args):
        """
        write_next_time(self, time:float) -> None
        C++: void write_next_time(double time)"""
        ret = self._wrap_call(self._vtk_obj.WriteNextTime, *args)
        return ret

    _updateable_traits_ = \
    (('encode_appended_data', 'GetEncodeAppendedData'),
    ('write_to_output_string', 'GetWriteToOutputString'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('byte_order',
    'GetByteOrder'), ('data_mode', 'GetDataMode'), ('header_type',
    'GetHeaderType'), ('id_type', 'GetIdType'), ('number_of_time_steps',
    'GetNumberOfTimeSteps'), ('block_size', 'GetBlockSize'),
    ('compression_level', 'GetCompressionLevel'), ('file_name',
    'GetFileName'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'encode_appended_data',
    'global_warning_display', 'release_data_flag',
    'write_to_output_string', 'byte_order', 'data_mode', 'header_type',
    'id_type', 'block_size', 'compression_level', 'file_name',
    'number_of_time_steps', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(XMLWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit XMLWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['encode_appended_data', 'write_to_output_string'],
            ['byte_order', 'data_mode', 'header_type', 'id_type'], ['block_size',
            'compression_level', 'file_name', 'number_of_time_steps']),
            title='Edit XMLWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit XMLWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

