# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class PolyDataEdgeConnectivityFilter(PolyDataAlgorithm):
    """
    PolyDataEdgeConnectivityFilter - segment polygonal mesh based on
    shared edge connectivity
    
    Superclass: PolyDataAlgorithm
    
    PolyDataEdgeConnectivityFilter is a filter to segment cells that
    share common edges (i.e., are edge connected), given certain
    conditions on edge connectivity. These conditions are 1) the shared
    edge is not a barrier edge, and 2) the edge neighbor satisfies
    conditions on scalar values.  Specification of both #1 and #2 are
    optional; in which case all polygons in a region that share edges are
    connected. Barrier edges are either defined by providing an optional
    second polydata input (which contains a list of lines defining the
    barrier edges), or a condition on edge length. The conditions on edge
    length specify whether edges within a range of edge lengths are
    considered barrier edges.  All connected polygonal cells satisfying
    these conditions form a region. Typically the filter segments
    multiple regions; however the user can specify which region(s) are to
    be extracted and output.
    
    The filter works in one of seven ways: 1) extract the largest (in
    terms of total surface area) edge-connected region in the dataset; 2)
    extract specified regions; 3) extract all regions containing
    user-specified point ids; 4) extract all regions containing
    user-specified cell ids; 5) extract the region closest to a
    user-specified point; 6) extract all edge-connected regions (used to
    color regions, i.e., create segmentation labeling); or 7) extract
    "large" regions, that is all regions considered large in terms of
    their surface area relative to the total input polydata surface area.
    
    Barrier edges add a unique twist to the filter. By using them, it is
    possible to segment out portions of a mesh with very small, very
    large, or inbetween polygon-sized features.
    
    Due to the nature of edge connectivity, the filter only operates on
    polygons. Vertices, lines, and triangle strips are ignored (and not
    passed through to the output). Point and cell attribute data are
    copied to the output; however, an additional, optional array named
    "region_id" may be added to the output cell attribute data by enabling
    color_regions.
    
    @warning
    If more than one output region is produced, regions are sorted based
    on their surface area. Thus region# 0 is the largest, followed by the
    next largest and so on.
    
    @warning
    To be clear: if scalar connectivity is enabled, this filter segments
    data based on *cell* attribute data based on edge-connected meshes.
    The similar PolyDataConnectivityFilter segments based on point
    attribute data and point-connected meshes.
    
    @warning
    A second, optional PolyData (the Source) may be specified which
    contains edges (i.e., PolyData::Lines) that specify barries to
    edge connectivity. That is, two polygons who share an edge are not
    connected if the shared edge exists in the Source PolyData. This
    feature can be used with other filters such as Delaunay2D (and its
    constraint edges) to create segmented regions.
    
    @warning
    Note that mesh regions attached at just a point are not considered
    connected. Thus such point-connected meshes will be segmented into
    different regions. This differs from PolyDataConnectivityFilter
    which segments produces point-connected regions.
    
    @sa
    PolyDataConnectivityFilter ConnectivityFilter Delaunay2D
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPolyDataEdgeConnectivityFilter, obj, update, **traits)
    
    barrier_edges = tvtk_base.false_bool_trait(desc=\
        """
        Control connectivity traversal based on barrier edges. If
        enabled, then either the length of edges, or a explicit
        specification of barrier edges, is used to control what are
        considered connected edge neighbors.
        """
    )

    def _barrier_edges_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBarrierEdges,
                        self.barrier_edges_)

    cell_region_areas = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off the creation of a cell array that, for each cell,
        contains the area of the region to which the cell is associated.
        If enabled, then an array named "cell_region_area" is added to the
        output cell data.
        """
    )

    def _cell_region_areas_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCellRegionAreas,
                        self.cell_region_areas_)

    color_regions = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off the coloring of edge-connected regions. If enabled,
        then a array named "region_id" is added to the output cell data.
        The array contains, for each cell, the id with which the cell is
        associated.
        """
    )

    def _color_regions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetColorRegions,
                        self.color_regions_)

    scalar_connectivity = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off connectivity based on scalar value. If on, cells are
        connected only if they share a non-barrier edge AND and cell's
        scalar value falls within the scalar range specified.
        """
    )

    def _scalar_connectivity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScalarConnectivity,
                        self.scalar_connectivity_)

    extraction_mode = tvtk_base.RevPrefixMap({'largest_region': 4, 'all_regions': 5, 'cell_seeded_regions': 2, 'closest_point_region': 6, 'large_regions': 7, 'point_seeded_regions': 1, 'specified_regions': 3}, default_value='largest_region', desc=\
        """
        Control the extraction of connected surfaces.
        """
    )

    def _extraction_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExtractionMode,
                        self.extraction_mode_)

    region_growing = tvtk_base.RevPrefixMap({'large_regions': 1, 'small_regions': 2}, 0, default_value='large_regions', desc=\
        """
        Specify a strategy for region growing. Regions growing is a
        postprocessing step which assimilates small regions into larger
        regions; i.e., region growing is an additional step as part of a
        segmentation workflow. By default, region growing is off. If
        growing large regions is enabled, then smaller regions are
        assimilated into larger regions. If growing small regions is
        enabled, then small regions are combined to form larger regions.
        Note that the definition of a large region is a region that
        exceeds the large region threshold.
        """
    )

    def _region_growing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRegionGrowing,
                        self.region_growing_)

    barrier_edge_length = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(1e+299, 1e+299), cols=2, desc=\
        """
        Edges E of length edgeLen
        (barrier_edge_length[0]<=edgeLen<=barrier_edge_length[1]) define
        barrier edges. If edgeLen falls within this range, then polygon
        cells on either side of the edge E are not neighbors, since the
        edge is a barrier edge. Note that a range of
        [VTK_DOUBLE_MAX,VTK_DOUBLE_MAX] (which is the default range)
        implies that all edges are not barrier edges (based on edge
        length).
        """
    )

    def _barrier_edge_length_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBarrierEdgeLength,
                        self.barrier_edge_length)

    closest_point = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        """
        Use to specify x-y-z point coordinates when extracting the region
        closest to a specified point.
        """
    )

    def _closest_point_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetClosestPoint,
                        self.closest_point)

    large_region_threshold = traits.Trait(0.1, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        """
        Define what a large region is by specifying the fraction of total
        input mesh area a region must be in order to be considered large.
        So for example, if the large_region_threshold is 0.10, then if the
        summed surface area of all the cells composing a region is
        greater than or equal to 10%, the region is considered large. By
        default, the large_region_threshold is 0.05.
        """
    )

    def _large_region_threshold_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLargeRegionThreshold,
                        self.large_region_threshold)

    output_points_precision = traits.Int(2, enter_set=True, auto_set=False, desc=\
        """
        Set/get the desired precision for the output types. See the
        documentation for the Algorithm::DesiredOutputPrecision enum
        for an explanation of the available precision settings.
        """
    )

    def _output_points_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPointsPrecision,
                        self.output_points_precision)

    scalar_range = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(0.0, 1.0), cols=2, desc=\
        """
        Set the scalar range to extract cells based on scalar
        connectivity.
        """
    )

    def _scalar_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScalarRange,
                        self.scalar_range)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_number_of_extracted_regions(self):
        return self._vtk_obj.GetNumberOfExtractedRegions()
    number_of_extracted_regions = traits.Property(_get_number_of_extracted_regions, desc=\
        """
        Obtain the number of connected regions found. This returns valid
        information only after the filter has successfully executed.
        """
    )

    def _get_number_of_specified_regions(self):
        return self._vtk_obj.GetNumberOfSpecifiedRegions()
    number_of_specified_regions = traits.Property(_get_number_of_specified_regions, desc=\
        """
        Get number of specified regions.
        """
    )

    def _get_region_sizes(self):
        return wrap_vtk(self._vtk_obj.GetRegionSizes())
    region_sizes = traits.Property(_get_region_sizes, desc=\
        """
        Obtain the array containing the region sizes of the extracted
        regions.
        """
    )

    def _get_source(self):
        return wrap_vtk(self._vtk_obj.GetSource())
    source = traits.Property(_get_source, desc=\
        """
        
        """
    )

    def _get_total_area(self):
        return self._vtk_obj.GetTotalArea()
    total_area = traits.Property(_get_total_area, desc=\
        """
        Obtain the total area of all regions combined.
        """
    )

    def add_seed(self, *args):
        """
        add_seed(self, id:int) -> None
        C++: void add_seed(int id)
        Add a seed id (point or cell id). Note: ids are 0-offset.
        """
        ret = self._wrap_call(self._vtk_obj.AddSeed, *args)
        return ret

    def add_specified_region(self, *args):
        """
        add_specified_region(self, id:int) -> None
        C++: void add_specified_region(int id)
        Add a region id to extract. Note: ids are 0-offset.
        """
        ret = self._wrap_call(self._vtk_obj.AddSpecifiedRegion, *args)
        return ret

    def delete_seed(self, *args):
        """
        delete_seed(self, id:int) -> None
        C++: void delete_seed(int id)
        Delete a seed id (point or cell id). Note: ids are 0-offset.
        """
        ret = self._wrap_call(self._vtk_obj.DeleteSeed, *args)
        return ret

    def delete_specified_region(self, *args):
        """
        delete_specified_region(self, id:int) -> None
        C++: void delete_specified_region(int id)
        Delete a region id to extract. Note: ids are 0-offset.
        """
        ret = self._wrap_call(self._vtk_obj.DeleteSpecifiedRegion, *args)
        return ret

    def grow_large_regions_off(self):
        """
        grow_large_regions_off(self) -> None
        C++: void grow_large_regions_off()"""
        ret = self._vtk_obj.GrowLargeRegionsOff()
        return ret
        

    def grow_large_regions_on(self):
        """
        grow_large_regions_on(self) -> None
        C++: void grow_large_regions_on()"""
        ret = self._vtk_obj.GrowLargeRegionsOn()
        return ret
        

    def grow_small_regions_off(self):
        """
        grow_small_regions_off(self) -> None
        C++: void grow_small_regions_off()"""
        ret = self._vtk_obj.GrowSmallRegionsOff()
        return ret
        

    def grow_small_regions_on(self):
        """
        grow_small_regions_on(self) -> None
        C++: void grow_small_regions_on()"""
        ret = self._vtk_obj.GrowSmallRegionsOn()
        return ret
        

    def initialize_seed_list(self):
        """
        initialize_seed_list(self) -> None
        C++: void initialize_seed_list()
        Initialize list of point ids/cell ids used to seed regions.
        """
        ret = self._vtk_obj.InitializeSeedList()
        return ret
        

    def initialize_specified_region_list(self):
        """
        initialize_specified_region_list(self) -> None
        C++: void initialize_specified_region_list()
        Initialize list of region ids to extract.
        """
        ret = self._vtk_obj.InitializeSpecifiedRegionList()
        return ret
        

    def set_region_growing_off(self):
        """
        set_region_growing_off(self) -> None
        C++: void set_region_growing_off()"""
        ret = self._vtk_obj.SetRegionGrowingOff()
        return ret
        

    def set_source_connection(self, *args):
        """
        set_source_connection(self, algOutput:AlgorithmOutput) -> None
        C++: void set_source_connection(AlgorithmOutput *algOutput)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSourceConnection, *my_args)
        return ret

    def set_source_data(self, *args):
        """
        set_source_data(self, __a:PolyData) -> None
        C++: void set_source_data(PolyData *)
        Specify the source PolyData object used to specify barrier
        edges (this is an optional connection.) If specified, the
        connected traversal cannot traverse across the edges indicated as
        they are defined as barrier edges. Also note that the data member
        barrier_edges must be enabled.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSourceData, *my_args)
        return ret

    _updateable_traits_ = \
    (('barrier_edges', 'GetBarrierEdges'), ('cell_region_areas',
    'GetCellRegionAreas'), ('color_regions', 'GetColorRegions'),
    ('scalar_connectivity', 'GetScalarConnectivity'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('extraction_mode', 'GetExtractionMode'),
    ('region_growing', 'GetRegionGrowing'), ('barrier_edge_length',
    'GetBarrierEdgeLength'), ('closest_point', 'GetClosestPoint'),
    ('large_region_threshold', 'GetLargeRegionThreshold'),
    ('output_points_precision', 'GetOutputPointsPrecision'),
    ('scalar_range', 'GetScalarRange'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'barrier_edges', 'cell_region_areas',
    'color_regions', 'debug', 'global_warning_display',
    'release_data_flag', 'scalar_connectivity', 'extraction_mode',
    'region_growing', 'barrier_edge_length', 'closest_point',
    'large_region_threshold', 'output_points_precision', 'progress_text',
    'scalar_range'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PolyDataEdgeConnectivityFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PolyDataEdgeConnectivityFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['barrier_edges', 'cell_region_areas', 'color_regions',
            'scalar_connectivity'], ['extraction_mode', 'region_growing'],
            ['barrier_edge_length', 'closest_point', 'large_region_threshold',
            'output_points_precision', 'scalar_range']),
            title='Edit PolyDataEdgeConnectivityFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PolyDataEdgeConnectivityFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

