# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.widget_representation import WidgetRepresentation


class PointCloudRepresentation(WidgetRepresentation):
    """
    PointCloudRepresentation - represent the PointCloudWidget
    
    Superclass: WidgetRepresentation
    
    This class provides support for interactively querying and selecting
    points from a point cloud. It is a representation for the
    PointCloudWidget.
    
    @sa
    PointCloudWidget HardwareSelection PointPicker
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPointCloudRepresentation, obj, update, **traits)
    
    highlighting = tvtk_base.true_bool_trait(desc=\
        """
        Flag controls whether highlighting of points occurs as the mouse
        moves over them. This can cause extra rendering operations.
        """
    )

    def _highlighting_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHighlighting,
                        self.highlighting_)

    picking_mode = tvtk_base.RevPrefixMap({'hardware': 0, 'software': 1}, default_value='hardware', desc=\
        """
        
        """
    )

    def _picking_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPickingMode,
                        self.picking_mode_)

    hardware_picking_tolerance = traits.Int(2, enter_set=True, auto_set=False, desc=\
        """
        The tolerance representing the distance to a point expressed in
        pixels. A tolerance of 0 selects from the pixel precisely under
        the cursor. A tolerance of 1 results in a 3x3 pixel square under
        the cursor (padded out by 1 in each direction); a tolerance of N
        results in a (2N+1)**2 selection rectangle. The point in the
        selection rectangle which is closest in z-buffer to the pick
        position is selected. Note that this can sometimes return points
        further away from the cursor (which can be unexpected - use the
        tolerance carefully).
        """
    )

    def _hardware_picking_tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHardwarePickingTolerance,
                        self.hardware_picking_tolerance)

    interaction_state = traits.Trait(0, traits.Range(0, 3, enter_set=True, auto_set=False), desc=\
        """
        The interaction state may be set from a widget (e.g.,
        point_cloud_widget) or other object. This controls how the
        interaction with the widget proceeds. Normally this method is
        used as part of a handshaking process with the widget: First
        compute_interaction_state() is invoked that returns a state based
        on geometric considerations (i.e., cursor near a widget feature),
        then based on events, the widget may modify this further.
        """
    )

    def _interaction_state_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInteractionState,
                        self.interaction_state)

    software_picking_tolerance = traits.Trait(0.0001, traits.Range(0.0, 100.0, enter_set=True, auto_set=False), desc=\
        """
        The tolerance representing the distance to a point (as a fraction
        of the bounding box of the point cloud). This specifies when the
        cursor is considered near enough to the point to highlight it.
        Note that this is a sensitive parameter - too small and it's hard
        to pick anything; too large and points close to the eye can be
        picked in preference to points further away which are closer to
        the pick ray.
        """
    )

    def _software_picking_tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSoftwarePickingTolerance,
                        self.software_picking_tolerance)

    def _get_point_cloud_actor(self):
        return wrap_vtk(self._vtk_obj.GetPointCloudActor())
    point_cloud_actor = traits.Property(_get_point_cloud_actor, desc=\
        """
        Retrieve the associated actor and mapper used to render the point
        cloud.
        """
    )

    def _get_point_cloud_mapper(self):
        return wrap_vtk(self._vtk_obj.GetPointCloudMapper())
    point_cloud_mapper = traits.Property(_get_point_cloud_mapper, desc=\
        """
        
        """
    )

    def _get_point_coordinates(self):
        return self._vtk_obj.GetPointCoordinates()
    point_coordinates = traits.Property(_get_point_coordinates, desc=\
        """
        Retrieve the point coordinates of the selected point. Note that
        if the point id is invalid (<0) then the coordinates are
        undefined.
        """
    )

    def get_point_coordinates(self, *args):
        """
        get_point_coordinates(self) -> Pointer
        C++: const double *get_point_coordinates()
        get_point_coordinates(self, x:[float, float, float]) -> None
        C++: void get_point_coordinates(double x[3])
        Retrieve the point coordinates of the selected point. Note that
        if the point id is invalid (<0) then the coordinates are
        undefined.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointCoordinates, *args)
        return ret

    def _get_point_id(self):
        return self._vtk_obj.GetPointId()
    point_id = traits.Property(_get_point_id, desc=\
        """
        Retrieve the point id from the selected point. Note that this can
        be invalid (<0) if nothing was picked.
        """
    )

    def place_point_cloud(self, *args):
        """
        place_point_cloud(self, a:Actor) -> None
        C++: void place_point_cloud(Actor *a)
        place_point_cloud(self, ps:PointSet) -> None
        C++: void place_point_cloud(PointSet *ps)
        Specify and place either an actor (Actor) or a point set
        (vtkpoint_set) that represents the point cloud. If placing with an
        actor, then the actor must refer to a mapper which in turn refers
        to a PointSet, with the actor being used to render the point
        cloud. If placing with a PointSet, then an internal Actor
        (and associated PointGaussianMapper) is created to render the
        point cloud.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PlacePointCloud, *my_args)
        return ret

    _updateable_traits_ = \
    (('highlighting', 'GetHighlighting'), ('need_to_render',
    'GetNeedToRender'), ('picking_managed', 'GetPickingManaged'),
    ('dragable', 'GetDragable'), ('pickable', 'GetPickable'),
    ('use_bounds', 'GetUseBounds'), ('visibility', 'GetVisibility'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('picking_mode', 'GetPickingMode'),
    ('hardware_picking_tolerance', 'GetHardwarePickingTolerance'),
    ('interaction_state', 'GetInteractionState'),
    ('software_picking_tolerance', 'GetSoftwarePickingTolerance'),
    ('handle_size', 'GetHandleSize'), ('place_factor', 'GetPlaceFactor'),
    ('estimated_render_time', 'GetEstimatedRenderTime'),
    ('render_time_multiplier', 'GetRenderTimeMultiplier'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'dragable', 'global_warning_display', 'highlighting',
    'need_to_render', 'pickable', 'picking_managed', 'use_bounds',
    'visibility', 'picking_mode', 'estimated_render_time', 'handle_size',
    'hardware_picking_tolerance', 'interaction_state', 'place_factor',
    'render_time_multiplier', 'software_picking_tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PointCloudRepresentation, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PointCloudRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['highlighting', 'need_to_render', 'picking_managed',
            'use_bounds', 'visibility'], ['picking_mode'],
            ['estimated_render_time', 'handle_size', 'hardware_picking_tolerance',
            'interaction_state', 'place_factor', 'render_time_multiplier',
            'software_picking_tolerance']),
            title='Edit PointCloudRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PointCloudRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

