# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_poly_data_reader import AbstractPolyDataReader


class PLYReader(AbstractPolyDataReader):
    """
    PLYReader - read Stanford University PLY polygonal file format
    
    Superclass: AbstractPolyDataReader
    
    PLYReader is a source object that reads polygonal data in Stanford
    University PLY file format (see
    http://graphics.stanford.edu/data/3Dscanrep). It requires that the
    elements "vertex" and "face" are defined. The "vertex" element must
    have the properties "x", "y", and "z". The "face" element must have
    the property "vertex_indices" defined. Optionally, if the "face"
    element has the properties "intensity" and/or the triplet "red",
    "green", "blue", and optionally "alpha"; these are read and added as
    scalars to the output data. If the "face" element has the property
    "texcoord" a new TCoords point array is created and points are
    duplicated if they have 2 or more different texture coordinates.
    Points are duplicated only if duplicate_points_for_face_texture is true
    (default). This creates a polygonal data that can be textured without
    artifacts. If unique points are required use a CleanPolyData
    filter after this reader or use this reader with
    duplicate_points_for_face_texture set to false.
    
    @sa
    PLYWriter, CleanPolyData
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPLYReader, obj, update, **traits)
    
    read_from_input_string = tvtk_base.false_bool_trait(desc=\
        """
        Enable reading from an input_string instead of the default, a
        file. Note that reading from an input stream would be more
        flexible (enabling other kind of streams) and possibly more
        efficient because we don't need to save the whole stream to a
        string. However a stream interface does not translate well to
        python and the string interface satisfies our current needs. So
        we leave the stream interface for future work.
        """
    )

    def _read_from_input_string_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReadFromInputString,
                        self.read_from_input_string_)

    duplicate_points_for_face_texture = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _duplicate_points_for_face_texture_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDuplicatePointsForFaceTexture,
                        self.duplicate_points_for_face_texture)

    face_texture_tolerance = traits.Float(9.999999974752427e-07, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _face_texture_tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFaceTextureTolerance,
                        self.face_texture_tolerance)

    def _get_comments(self):
        return wrap_vtk(self._vtk_obj.GetComments())
    comments = traits.Property(_get_comments, desc=\
        """
        
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def can_read_file(self, *args):
        """
        can_read_file(filename:str) -> int
        C++: static int can_read_file(const char *filename)
        A simple, non-exhaustive check to see if a file is a valid ply
        file.
        """
        ret = self._wrap_call(self._vtk_obj.CanReadFile, *args)
        return ret

    def set_input_string(self, *args):
        """
        set_input_string(self, s:str) -> None
        C++: void set_input_string(const std::string &s)"""
        ret = self._wrap_call(self._vtk_obj.SetInputString, *args)
        return ret

    _updateable_traits_ = \
    (('read_from_input_string', 'GetReadFromInputString'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('duplicate_points_for_face_texture',
    'GetDuplicatePointsForFaceTexture'), ('face_texture_tolerance',
    'GetFaceTextureTolerance'), ('file_name', 'GetFileName'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'read_from_input_string', 'release_data_flag',
    'duplicate_points_for_face_texture', 'face_texture_tolerance',
    'file_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PLYReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PLYReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['read_from_input_string'], [],
            ['duplicate_points_for_face_texture', 'face_texture_tolerance',
            'file_name']),
            title='Edit PLYReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PLYReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

