# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.cell import Cell


class Line(Cell):
    """
    Line - cell represents a 1D line
    
    Superclass: Cell
    
    Line is a concrete implementation of Cell to represent a 1D
    line.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkLine, obj, update, **traits)
    
    def distance_between_line_segments(self, *args):
        """
        distance_between_line_segments(l0:[float, float, float], l1:[float,
            float, float], m0:[float, float, float], m1:[float, float,
            float], closestPt1:[float, float, float], closestPt2:[float,
            float, float], t1:float, t2:float) -> float
        C++: static double distance_between_line_segments(double l0[3],
            double l1[3], double m0[3], double m1[3],
            double closestPt1[3], double closestPt2[3], double &t1,
            double &t2)
        Computes the shortest distance squared between two finite line
        segments defined by their end points (l0,l1) and (m0,m1). Upon
        return, the closest points on the two line segments will be
        stored in closestPt1 and closestPt2. Their parametric coords (0
        <= t0, t1 <= 1) will be stored in t0 and t1. The return value is
        the shortest distance squared between the two line-segments.
        """
        ret = self._wrap_call(self._vtk_obj.DistanceBetweenLineSegments, *args)
        return ret

    def distance_between_lines(self, *args):
        """
        distance_between_lines(l0:[float, float, float], l1:[float, float,
            float], m0:[float, float, float], m1:[float, float, float],
            closestPt1:[float, float, float], closestPt2:[float, float,
            float], t1:float, t2:float) -> float
        C++: static double distance_between_lines(double l0[3],
            double l1[3], double m0[3], double m1[3],
            double closestPt1[3], double closestPt2[3], double &t1,
            double &t2)
        Computes the shortest distance squared between two infinite
        lines, each defined by a pair of points (l0,l1) and (m0,m1). Upon
        return, the closest points on the two line segments will be
        stored in closestPt1 and closestPt2. Their parametric coords
        (-inf <= t0, t1 <= inf) will be stored in t0 and t1. The return
        value is the shortest distance squared between the two
        line-segments.
        """
        ret = self._wrap_call(self._vtk_obj.DistanceBetweenLines, *args)
        return ret

    def distance_to_line(self, *args):
        """
        distance_to_line(x:(float, float, float), p1:(float, float, float),
            p2:(float, float, float), t:float, closestPoint:[float, float,
             float]=...) -> float
        C++: static double distance_to_line(const double x[3],
            const double p1[3], const double p2[3], double &t,
            double closestPoint[3]=nullptr)
        distance_to_line(x:(float, float, float), p1:(float, float, float),
            p2:(float, float, float)) -> float
        C++: static double distance_to_line(const double x[3],
            const double p1[3], const double p2[3])
        Compute the distance of a point x to a finite line (p1,p2). The
        method computes the parametric coordinate t and the point
        location on the line. Note that t is unconstrained (i.e., it may
        lie outside the range [0,1]) but the closest point will lie
        within the finite line [p1,p2], if it is defined. Also, the
        method returns the distance squared between x and the line
        (p1,p2).
        """
        ret = self._wrap_call(self._vtk_obj.DistanceToLine, *args)
        return ret

    def interpolation_derivs(self, *args):
        """
        interpolation_derivs(pcoords:(float, float, float), derivs:[float,
            float]) -> None
        C++: static void interpolation_derivs(const double pcoords[3],
            double derivs[2])"""
        ret = self._wrap_call(self._vtk_obj.InterpolationDerivs, *args)
        return ret

    def interpolation_functions(self, *args):
        """
        interpolation_functions(pcoords:(float, float, float),
            weights:[float, float]) -> None
        C++: static void interpolation_functions(const double pcoords[3],
            double weights[2])"""
        ret = self._wrap_call(self._vtk_obj.InterpolationFunctions, *args)
        return ret

    def intersection(self, *args):
        """
        intersection(p1:(float, float, float), p2:(float, float, float),
            x1:(float, float, float), x2:(float, float, float), u:float,
            v:float, tolerance:float=1e-6, toleranceType:int=...) -> int
        C++: static int intersection(const double p1[3],
            const double p2[3], const double x1[3], const double x2[3],
            double &u, double &v, const double tolerance=1e-6,
            int toleranceType=ToleranceType::Relative)
        Performs intersection of the projection of two finite 3D lines
        onto a 2D plane. An intersection is found if the projection of
        the two lines onto the plane perpendicular to the cross product
        of the two lines intersect. The parameters (u,v) are the
        parametric coordinates of the lines at the position of closest
        approach.
        
        The results are of type Line::IntersectionType. An
        intersection occurs if (u,v) are in the interval [0,1] and the
        intersection point falls within the tolerance specified.
        Different types of tolerancing can be used by specifying a
        tolerance type with the enum provided (Line::tolerance_type).
        The tolerance types may be: Relative) relative to the projection
        line lengths (this is default); or Absolute) the distance between
        the points at (u,v) on the two lines must be less than or equal
        to the tolerance specified.
        """
        ret = self._wrap_call(self._vtk_obj.Intersection, *args)
        return ret

    def intersection3d(self, *args):
        """
        intersection3d(p1:[float, float, float], p2:[float, float, float],
             x1:[float, float, float], x2:[float, float, float], u:float,
            v:float, tolerance:float=1e-6) -> int
        C++: static int intersection3d(double p1[3], double p2[3],
            double x1[3], double x2[3], double &u, double &v,
            const double tolerance=1e-6)
        Performs intersection of two finite 3D lines. An intersection is
        found if the projection of the two lines onto the plane
        perpendicular to the cross product of the two lines intersect,
        and if the distance between the closest points of approach are
        within a relative tolerance. The parameters (u,v) are the
        parametric coordinates of the lines at the position of closest
        approach.
        
        The results are of type Line::IntersectionType.
        
        NOTE: Legacy method, returns Line::Intersection(...).
        """
        ret = self._wrap_call(self._vtk_obj.Intersection3D, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Line, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Line properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit Line properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Line properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

