# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.exporter import Exporter


class JSONSceneExporter(Exporter):
    """
    JSONSceneExporter - Export the content of a RenderWindow into a
    directory with
             a JSON meta file describing the scene along with the http
    datasets
    
    Superclass: Exporter
    
    @warning
    This writer assume little_endian by default. Additional work should be
    done to properly handle endianness.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkJSONSceneExporter, obj, update, **traits)
    
    file_name = tvtk_base.vtk_file_name("", desc=\
        """
        Specify file name of vtk data file to write. This correspond to
        the root directory of the data to write.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    def _set_input(self, arg):
        old_val = self._get_input()
        self._wrap_call(self._vtk_obj.SetInput,
                        deref_vtk(arg))
        self.trait_property_changed('input', old_val, arg)
    input = traits.Property(_get_input, _set_input, desc=\
        """
        
        """
    )

    poly_lo_ds_base_size = traits.Int(100000, enter_set=True, auto_set=False, desc=\
        """
        The base size to be used for poly LODs. The poly LODs will stop
        being written out when one is smaller than this size, or if the
        difference in the sizes of the two most recent LODs is less than
        5%. Default is 100 KB. Units are in bytes.
        """
    )

    def _poly_lo_ds_base_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolyLODsBaseSize,
                        self.poly_lo_ds_base_size)

    poly_lo_ds_base_url = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        The base URL to be used for poly LODs. Default is nullptr.
        """
    )

    def _poly_lo_ds_base_url_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPolyLODsBaseUrl,
                        self.poly_lo_ds_base_url)

    texture_lo_ds_base_size = traits.Int(100000, enter_set=True, auto_set=False, desc=\
        """
        The base size to be used for texture LODs. The texture LODs will
        stop being written out when one is smaller than this size.
        Default is 100 KB. Units are in bytes.
        """
    )

    def _texture_lo_ds_base_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTextureLODsBaseSize,
                        self.texture_lo_ds_base_size)

    texture_lo_ds_base_url = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        The base URL to be used for texture LODs. Default is nullptr.
        """
    )

    def _texture_lo_ds_base_url_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTextureLODsBaseUrl,
                        self.texture_lo_ds_base_url)

    write_poly_lo_ds = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        """
        Whether or not to write poly LODs. This will write out the poly
        LOD sources in a series of decreasing resolution data sets, which
        are intended to be uploaded to the web. QuadricCluster is used
        to decrease the resolution of the poly data. Each will be
        approximately 1/4 the size of the previous one (unless certain
        errors occur, and then the defaults for quadric clustering will
        be used, which will produce an unknown size). The files will stop
        being written out when one is smaller than the poly_lo_ds_base_size,
        or if the difference in the sizes of the two most recent LODs is
        less than 5%. The smallest LOD will be written into the vtkjs
        file, rather than with the rest of the LODs. Default is false.
        """
    )

    def _write_poly_lo_ds_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWritePolyLODs,
                        self.write_poly_lo_ds)

    write_texture_lo_ds = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        """
        Whether or not to write texture LODs. This will write out the
        textures in a series of decreasing resolution JPEG files, which
        are intended to be uploaded to the web. Each file will be 1/4 the
        size of the previous one. The files will stop being written out
        when one is smaller than the texture_lo_ds_base_size. Default is
        false.
        """
    )

    def _write_texture_lo_ds_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWriteTextureLODs,
                        self.write_texture_lo_ds)

    write_textures = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        """
        Whether or not to write textures. Textures will be written in
        JPEG format. Default is false.
        """
    )

    def _write_textures_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWriteTextures,
                        self.write_textures)

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('file_name', 'GetFileName'),
    ('poly_lo_ds_base_size', 'GetPolyLODsBaseSize'),
    ('poly_lo_ds_base_url', 'GetPolyLODsBaseUrl'),
    ('texture_lo_ds_base_size', 'GetTextureLODsBaseSize'),
    ('texture_lo_ds_base_url', 'GetTextureLODsBaseUrl'),
    ('write_poly_lo_ds', 'GetWritePolyLODs'), ('write_texture_lo_ds',
    'GetWriteTextureLODs'), ('write_textures', 'GetWriteTextures'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'file_name',
    'poly_lo_ds_base_size', 'poly_lo_ds_base_url',
    'texture_lo_ds_base_size', 'texture_lo_ds_base_url',
    'write_poly_lo_ds', 'write_texture_lo_ds', 'write_textures'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(JSONSceneExporter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit JSONSceneExporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['file_name', 'poly_lo_ds_base_size',
            'poly_lo_ds_base_url', 'texture_lo_ds_base_size',
            'texture_lo_ds_base_url', 'write_poly_lo_ds', 'write_texture_lo_ds',
            'write_textures']),
            title='Edit JSONSceneExporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit JSONSceneExporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

