# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.hyper_tree_grid_algorithm import HyperTreeGridAlgorithm


class HyperTreeGridDepthLimiter(HyperTreeGridAlgorithm):
    """
    HyperTreeGridDepthLimiter - Hyper tree grid level extraction
    
    Superclass: HyperTreeGridAlgorithm
    
    Extracts all levels down to a specified depth from a hyper_tree_grid
    representation. If the required depth is greater or equal to the
    maximum level of the input grid, then the output is identical.
    
    @sa
    HyperTreeGrid HyperTreeGridAlgorithm UniformHyperTreeGrid
    
    @par Thanks: This class was written by Guenole Harel and
    Jacques-Bernard Lekien 2014 This class was modified by Philippe
    Pebay, 2016 This class was modified, 2018, and optimized, 2019, by
    Jacques-Bernard Lekien, by depth_limiter directly managed by
    hyper_tree_grid and (super)cursors. This work was supported by
    Commissariat a l'Energie Atomique CEA, DAM, DIF, F-91297 Arpajon,
    France.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHyperTreeGridDepthLimiter, obj, update, **traits)
    
    depth = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get maximum depth to which output grid should be limited
        Default is 0.
        """
    )

    def _depth_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDepth,
                        self.depth)

    just_create_new_mask = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        """
        Set/Get True, create a new mask ; False, create a new
        HyperTreeGrid (HTG) Actually, setting to true no longer
        creates a new mask but sets an attribute of the HTG that is used
        in the HTG and sliders. The name of this option is historical and
        being kept for retro-compatibility reasons. Default is true.
        """
    )

    def _just_create_new_mask_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetJustCreateNewMask,
                        self.just_create_new_mask)

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('depth',
    'GetDepth'), ('just_create_new_mask', 'GetJustCreateNewMask'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'depth', 'just_create_new_mask',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HyperTreeGridDepthLimiter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HyperTreeGridDepthLimiter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['depth', 'just_create_new_mask']),
            title='Edit HyperTreeGridDepthLimiter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HyperTreeGridDepthLimiter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

