# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class Hull(PolyDataAlgorithm):
    """
    Hull - produce an n-sided convex hull
    
    Superclass: PolyDataAlgorithm
    
    Hull is a filter which will produce an n-sided convex hull given a
    set of n planes. (The convex hull bounds the input polygonal data.)
    The hull is generated by squeezing the planes towards the input
    PolyData, until the planes just touch the PolyData. Then, the
    resulting planes are used to generate a polyhedron (i.e., hull) that
    is represented by triangles.
    
    The n planes can be defined in a number of ways including 1) manually
    specifying each plane; 2) choosing the six face planes of the input's
    bounding box; 3) choosing the eight vertex planes of the input's
    bounding box; 4) choosing the twelve edge planes of the input's
    bounding box; and/or 5) using a recursively subdivided octahedron.
    Note that when specifying planes, the plane normals should point
    outside of the convex region.
    
    The output of this filter can be used in combination with LODActor
    to represent a levels-of-detail in the LOD hierarchy. Another use of
    this class is to manually specify the planes, and then generate the
    polyhedron from the planes (without squeezing the planes towards the
    input). The method generate_hull() is used to do this.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHull, obj, update, **traits)
    
    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_number_of_planes(self):
        return self._vtk_obj.GetNumberOfPlanes()
    number_of_planes = traits.Property(_get_number_of_planes, desc=\
        """
        Get the number of planes in the current set of planes.
        """
    )

    def add_cube_edge_planes(self):
        """
        add_cube_edge_planes(self) -> None
        C++: void add_cube_edge_planes()
        Add the 12 planes that represent the edges of a cube - halfway
        between the two connecting face planes - (1,1,0), (-1,-1,0),
        (-1,1,0), (1,-1,0), (0,1,1), (0,-1,-1), (0,1,-1), (0,-1,1),
        (1,0,1), (-1,0,-1), (1,0,-1), (-1,0,1)
        """
        ret = self._vtk_obj.AddCubeEdgePlanes()
        return ret
        

    def add_cube_face_planes(self):
        """
        add_cube_face_planes(self) -> None
        C++: void add_cube_face_planes()
        Add the six planes that make up the faces of a cube - (1,0,0),
        (-1, 0, 0), (0,1,0), (0,-1,0), (0,0,1), (0,0,-1)
        """
        ret = self._vtk_obj.AddCubeFacePlanes()
        return ret
        

    def add_cube_vertex_planes(self):
        """
        add_cube_vertex_planes(self) -> None
        C++: void add_cube_vertex_planes()
        Add the 8 planes that represent the vertices of a cube - the
        combination of the three face planes connecting to a vertex -
        (1,1,1), (1,1,-1), (1,-1,1), (1,-1,1), (-1,1,1), (-1,1,-1),
        (-1,-1,1), (-1,-1-1).
        """
        ret = self._vtk_obj.AddCubeVertexPlanes()
        return ret
        

    def add_plane(self, *args):
        """
        add_plane(self, A:float, B:float, C:float) -> int
        C++: int add_plane(double A, double B, double C)
        add_plane(self, plane:[float, float, float]) -> int
        C++: int add_plane(double plane[3])
        add_plane(self, A:float, B:float, C:float, D:float) -> int
        C++: int add_plane(double A, double B, double C, double D)
        add_plane(self, plane:[float, float, float], D:float) -> int
        C++: int add_plane(double plane[3], double D)
        Add a plane to the current set of planes. It will be added at the
        end of the list, and an index that can later be used to set this
        plane's normal will be returned. The values A, B, C are from the
        plane equation Ax + By + Cz + D = 0. This vector does not have to
        have unit length (but it must have a non-zero length!). If a
        value 0 > i >= -number_of_planes is returned, then the plane is
        parallel with a previously inserted plane, and |-i-1| is the
        index of the plane that was previously inserted. If a value i <
        -number_of_planes is returned, then the plane normal is zero
        length.
        """
        ret = self._wrap_call(self._vtk_obj.AddPlane, *args)
        return ret

    def add_recursive_sphere_planes(self, *args):
        """
        add_recursive_sphere_planes(self, level:int) -> None
        C++: void add_recursive_sphere_planes(int level)
        Add the planes that represent the normals of the vertices of a
        polygonal sphere formed by recursively subdividing the triangles
        in an octahedron.  Each triangle is subdivided by connecting the
        midpoints of the edges thus forming 4 smaller triangles. The
        level indicates how many subdivisions to do with a level of 0
        used to add the 6 planes from the original octahedron, level 1
        will add 18 planes, and so on.
        """
        ret = self._wrap_call(self._vtk_obj.AddRecursiveSpherePlanes, *args)
        return ret

    def generate_hull(self, *args):
        """
        generate_hull(self, pd:PolyData, bounds:[float, ...]) -> None
        C++: void generate_hull(PolyData *pd, double *bounds)
        generate_hull(self, pd:PolyData, xmin:float, xmax:float,
            ymin:float, ymax:float, zmin:float, zmax:float) -> None
        C++: void generate_hull(PolyData *pd, double xmin, double xmax,
            double ymin, double ymax, double zmin, double zmax)
        A special method that is used to generate a polyhedron directly
        from a set of n planes. The planes that are supplied by the user
        are not squeezed towards the input data (in fact the user need
        not specify an input). To use this method, you must provide an
        instance of PolyData into which the points and cells defining
        the polyhedron are placed. You must also provide a bounding box
        where you expect the resulting polyhedron to lie. This can be a
        very generous fit, it's only used to create the initial polygons
        that are eventually clipped.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GenerateHull, *my_args)
        return ret

    def remove_all_planes(self):
        """
        remove_all_planes(self) -> None
        C++: void remove_all_planes(void)
        Remove all planes from the current set of planes.
        """
        ret = self._vtk_obj.RemoveAllPlanes()
        return ret
        

    def set_plane(self, *args):
        """
        set_plane(self, i:int, A:float, B:float, C:float) -> None
        C++: void set_plane(int i, double A, double B, double C)
        set_plane(self, i:int, plane:[float, float, float]) -> None
        C++: void set_plane(int i, double plane[3])
        set_plane(self, i:int, A:float, B:float, C:float, D:float) -> None
        C++: void set_plane(int i, double A, double B, double C, double D)
        set_plane(self, i:int, plane:[float, float, float], D:float)
            -> None
        C++: void set_plane(int i, double plane[3], double D)
        Set the normal values for plane i. This is a plane that was
        already added to the current set of planes with add_plane(), and
        is now being modified. The values A, B, C are from the plane
        equation Ax + By + Cz + D = 0. This vector does not have to have
        unit length. Note that D is set to zero, except in the case of
        the method taking a Planes* argument, where it is set to the D
        value defined there.
        """
        ret = self._wrap_call(self._vtk_obj.SetPlane, *args)
        return ret

    def set_planes(self, *args):
        """
        set_planes(self, planes:Planes) -> None
        C++: void set_planes(Planes *planes)
        Set all the planes at once using a Planes implicit function.
        This also sets the D value, so it can be used with
        generate_hull().
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetPlanes, *my_args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Hull, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Hull properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit Hull properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Hull properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

