# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class HandleSource(PolyDataAlgorithm):
    """
    HandleSource - interface that can be inherited to define handler
    sources for any kind of interaction.
    
    Superclass: PolyDataAlgorithm
    
    HandleSource is a pure abstract class defining an interface for
    handler sources. Any child of this class is supposed to define an
    access to its position, size and direction, if any. On this purpose,
    the internal getters/setters are left to be redefined by the
    subclasses. It is derived by PointHandleSource for example.
    @sa
    PointHandleSource, CameraHandleSource
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHandleSource, obj, update, **traits)
    
    directional = tvtk_base.false_bool_trait(desc=\
        """
        Set/Get if the handle should take account on this->Direction. The
        meaning of this direction varies on the subclasses
        implementation. The default value is false.
        """
    )

    def _directional_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDirectional,
                        self.directional_)

    direction = traits.Trait((traits.Undefined, traits.Undefined, traits.Undefined), traits.Array(shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3), enter_set=True, auto_set=False, desc=\
        """
        Set the direction of the handle. The direction meaning depends on
        subclasses implementations.
        """
    )

    def _direction_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDirection,
                        self.direction)

    position = traits.Trait((traits.Undefined, traits.Undefined, traits.Undefined), traits.Array(shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3), enter_set=True, auto_set=False, desc=\
        """
        Set the position of the handle.
        """
    )

    def _position_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPosition,
                        self.position)

    size = traits.Float(0.5, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the size of the handle. The size use depends on
        subclasses implementations. The default value is 0.5.
        """
    )

    def _size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSize,
                        self.size)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('directional', 'GetDirectional'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('size', 'GetSize'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'directional', 'global_warning_display',
    'release_data_flag', 'progress_text', 'size'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HandleSource, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HandleSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['directional'], [], ['size']),
            title='Edit HandleSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HandleSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

