# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.unstructured_grid_algorithm import UnstructuredGridAlgorithm


class GenericDataSetTessellator(UnstructuredGridAlgorithm):
    """
    GenericDataSetTessellator - tessellates generic, higher-order
    datasets into linear cells
    
    Superclass: UnstructuredGridAlgorithm
    
    GenericDataSetTessellator is a filter that subdivides a
    GenericDataSet into linear elements (i.e., linear VTK cells).
    Tetrahedras are produced from 3D cells; triangles from 2D cells; and
    lines from 1D cells. The subdivision process depends on the cell
    tessellator associated with the input generic dataset, and its
    associated error metric. (These can be specified by the user if
    necessary.)
    
    This filter is typically used to convert a higher-order, complex
    dataset represented by a GenericDataSet into a conventional
    DataSet that can be operated on by linear VTK graphics filters
    (end of pipeline for rendering).
    
    @sa
    GenericCellTessellator GenericSubdivisionErrorMetric
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGenericDataSetTessellator, obj, update, **traits)
    
    keep_cell_ids = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off generation of a cell centered attribute with ids of
        the original cells (as an input cell is tessellated into several
        linear cells). The name of the data array is "original_ids". It is
        true by default.
        """
    )

    def _keep_cell_ids_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetKeepCellIds,
                        self.keep_cell_ids_)

    merging = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off merging of coincident points. Note that is merging is
        on, points with different point attributes (e.g., normals) are
        merged, which may cause rendering artifacts.
        """
    )

    def _merging_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMerging,
                        self.merging_)

    def _get_locator(self):
        return wrap_vtk(self._vtk_obj.GetLocator())
    def _set_locator(self, arg):
        old_val = self._get_locator()
        self._wrap_call(self._vtk_obj.SetLocator,
                        deref_vtk(arg))
        self.trait_property_changed('locator', old_val, arg)
    locator = traits.Property(_get_locator, _set_locator, desc=\
        """
        
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)
        get_input(self) -> DataObject
        C++: DataObject *get_input()"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def create_default_locator(self):
        """
        create_default_locator(self) -> None
        C++: void create_default_locator()
        Create default locator. Used to create one when none is
        specified.
        """
        ret = self._vtk_obj.CreateDefaultLocator()
        return ret
        

    _updateable_traits_ = \
    (('keep_cell_ids', 'GetKeepCellIds'), ('merging', 'GetMerging'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display', 'keep_cell_ids',
    'merging', 'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GenericDataSetTessellator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GenericDataSetTessellator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['keep_cell_ids', 'merging'], [], []),
            title='Edit GenericDataSetTessellator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GenericDataSetTessellator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

