# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.point_cloud_filter import PointCloudFilter


class ExtractEnclosedPoints(PointCloudFilter):
    """
    ExtractEnclosedPoints - extract points inside of a closed
    polygonal surface
    
    Superclass: PointCloudFilter
    
    ExtractEnclosedPoints is a filter that evaluates all the input
    points to determine whether they are contained within an enclosing
    surface. Those within the surface are sent to the output. The
    enclosing surface is specified through a second input to the filter.
    
    Note: as a derived class of PointCloudFilter, additional methods
    are available for generating an in/out mask, and also extracting
    points outside of the enclosing surface.
    
    @warning
    The filter assumes that the surface is closed and manifold. A boolean
    flag can be set to force the filter to first check whether this is
    true. If false, all points will be marked outside. Note that if this
    check is not performed and the surface is not closed, the results are
    undefined.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @warning
    The filter SelectEnclosedPoints marks points as to in/out of the
    enclosing surface, and operates on any dataset type, producing an
    output dataset of the same type as the input. Then, thresholding and
    masking filters can be used to extract parts of the dataset. This
    filter (vtkextract_enclosed_points) is meant to operate on point clouds
    represented by PolyData, and produces PolyData on output, so it
    is more efficient for point processing. Note that this filter
    delegates many of its methods to SelectEnclosedPoints.
    
    @sa
    SelectEnclosedPoints ExtractPoints
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkExtractEnclosedPoints, obj, update, **traits)
    
    check_surface = tvtk_base.false_bool_trait(desc=\
        """
        Specify whether to check the surface for closure. If on, then the
        algorithm first checks to see if the surface is closed and
        manifold.
        """
    )

    def _check_surface_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCheckSurface,
                        self.check_surface_)

    tolerance = traits.Trait(0.001, traits.Range(0.0, 9.999999680285692e+37, enter_set=True, auto_set=False), desc=\
        """
        Specify the tolerance on the intersection. The tolerance is
        expressed as a fraction of the diagonal of the bounding box of
        the enclosing surface.
        """
    )

    def _tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTolerance,
                        self.tolerance)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_surface(self):
        return wrap_vtk(self._vtk_obj.GetSurface())
    surface = traits.Property(_get_surface, desc=\
        """
        Return a pointer to the enclosing surface.
        """
    )

    def get_surface(self, *args):
        """
        get_surface(self) -> PolyData
        C++: PolyData *get_surface()
        get_surface(self, sourceInfo:InformationVector) -> PolyData
        C++: PolyData *get_surface(InformationVector *sourceInfo)
        Return a pointer to the enclosing surface.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetSurface, *my_args)
        return wrap_vtk(ret)

    def set_surface_connection(self, *args):
        """
        set_surface_connection(self, algOutput:AlgorithmOutput) -> None
        C++: void set_surface_connection(AlgorithmOutput *algOutput)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSurfaceConnection, *my_args)
        return ret

    def set_surface_data(self, *args):
        """
        set_surface_data(self, pd:PolyData) -> None
        C++: void set_surface_data(PolyData *pd)
        Set the surface to be used to test for containment. Two methods
        are provided: one directly for PolyData, and one for the
        output of a filter.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSurfaceData, *my_args)
        return ret

    _updateable_traits_ = \
    (('check_surface', 'GetCheckSurface'), ('generate_outliers',
    'GetGenerateOutliers'), ('generate_vertices', 'GetGenerateVertices'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('tolerance',
    'GetTolerance'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'check_surface', 'debug', 'generate_outliers',
    'generate_vertices', 'global_warning_display', 'release_data_flag',
    'progress_text', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ExtractEnclosedPoints, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ExtractEnclosedPoints properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['check_surface', 'generate_outliers', 'generate_vertices'], [],
            ['tolerance']),
            title='Edit ExtractEnclosedPoints properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ExtractEnclosedPoints properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

