# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.pass_input_type_algorithm import PassInputTypeAlgorithm


class ExtractBlock(PassInputTypeAlgorithm):
    """
    ExtractBlock - extracts blocks from a DataObjectTree subclass.
    
    Superclass: PassInputTypeAlgorithm
    
    ExtractBlock is a filter that extracts blocks from a
    DataObjectTree subclass such as PartitionedDataSet,
    PartitionedDataSetCollection, etc. using their composite-ids (also
    called flat-index).
    
    The composite-id can be obtained by performing a pre-order traversal
    of the tree (including empty nodes). For example, consider a tree
    with nodes named `A(B (D, E), C(F, G))`.  Pre-order traversal yields:
    `A, B, D, E, C, F, G`; hence, composite-id of `A` is `0`, while index
    of `C` is `4`.
    
    `0` identifies the root-node. Thus, choosing `0` will result in the
    entire input dataset being passed to the output.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkExtractBlock, obj, update, **traits)
    
    maintain_structure = tvtk_base.false_bool_trait(desc=\
        """
        This is used only when prune_output is ON. By default, when
        pruning the output i.e. remove empty blocks, if node has only 1
        non-null child block, then that node is removed. To preserve
        these parent nodes, set this flag to true. Off by default.
        
        This has no effect for PartitionedDataSetCollection.
        """
    )

    def _maintain_structure_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaintainStructure,
                        self.maintain_structure_)

    prune_output = tvtk_base.true_bool_trait(desc=\
        """
        When set, the output multiblock dataset will be pruned to remove
        empty nodes. On by default.
        
        This has no effect for PartitionedDataSetCollection.
        """
    )

    def _prune_output_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPruneOutput,
                        self.prune_output_)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    def add_index(self, *args):
        """
        add_index(self, index:int) -> None
        C++: void add_index(unsigned int index)
        Select the block indices to extract.  Each node in the
        multi-block tree is identified by an index. The index can be
        obtained by performing a preorder traversal of the tree
        (including empty nodes). eg. A(B (D, E), C(F, G)).  Inorder
        traversal yields: A, B, D, E, C, F, G Index of A is 0, while
        index of C is 4. (Note: specifying node 0 means the input is
        copied to the output.)
        """
        ret = self._wrap_call(self._vtk_obj.AddIndex, *args)
        return ret

    def remove_all_indices(self):
        """
        remove_all_indices(self) -> None
        C++: void remove_all_indices()"""
        ret = self._vtk_obj.RemoveAllIndices()
        return ret
        

    def remove_index(self, *args):
        """
        remove_index(self, index:int) -> None
        C++: void remove_index(unsigned int index)"""
        ret = self._wrap_call(self._vtk_obj.RemoveIndex, *args)
        return ret

    _updateable_traits_ = \
    (('maintain_structure', 'GetMaintainStructure'), ('prune_output',
    'GetPruneOutput'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'maintain_structure', 'prune_output', 'release_data_flag',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ExtractBlock, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ExtractBlock properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['maintain_structure', 'prune_output'], [], []),
            title='Edit ExtractBlock properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ExtractBlock properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

