# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class ExecutableRunner(Object):
    """
    ExecutableRunner - Launch a process on the current machine and get
    its output
    
    Superclass: Object
    
    Launch a process on the current machine and get its standard output
    and standard error output.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkExecutableRunner, obj, update, **traits)
    
    right_trim_result = tvtk_base.true_bool_trait(desc=\
        """
        Set/Get if we trim the ending whitespaces of the output.
        
        Default is true.
        """
    )

    def _right_trim_result_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRightTrimResult,
                        self.right_trim_result_)

    command = traits.String('', enter_set=True, auto_set=False, desc=\
        """
        Set/Get command to execute. An empty command will do nothing.
        """
    )

    def _command_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCommand,
                        self.command)

    timeout = traits.Float(5.0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get command timeout in seconds.  A non-positive (<= 0) value
        will disable the timeout.
        
        Default is 5
        """
    )

    def _timeout_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTimeout,
                        self.timeout)

    def _get_return_value(self):
        return self._vtk_obj.GetReturnValue()
    return_value = traits.Property(_get_return_value, desc=\
        """
        Get return value of last command. If no command has been executed
        or if the command has failed in some way value is != 0, else
        return 0.
        """
    )

    def _get_std_err(self):
        return self._vtk_obj.GetStdErr()
    std_err = traits.Property(_get_std_err, desc=\
        """
        Get output of the previously run command.
        """
    )

    def _get_std_out(self):
        return self._vtk_obj.GetStdOut()
    std_out = traits.Property(_get_std_out, desc=\
        """
        Get output of the previously run command.
        """
    )

    def execute(self):
        """
        execute(self) -> None
        C++: void execute()
        Execute the command currently set if any. This will update the
        std_out and std_err properties.
        """
        ret = self._vtk_obj.Execute()
        return ret
        

    _updateable_traits_ = \
    (('right_trim_result', 'GetRightTrimResult'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('command',
    'GetCommand'), ('timeout', 'GetTimeout'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'right_trim_result', 'command',
    'timeout'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ExecutableRunner, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ExecutableRunner properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['right_trim_result'], [], ['command', 'timeout']),
            title='Edit ExecutableRunner properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ExecutableRunner properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

