# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class DataSetSurfaceFilter(PolyDataAlgorithm):
    """
    DataSetSurfaceFilter - Extracts outer surface (as PolyData) of
    any dataset
    
    Superclass: PolyDataAlgorithm
    
    DataSetSurfaceFilter is a general-purpose filter to extract
    boundary geometry (and associated data) from any type of dataset.
    Geometry is obtained as follows: all 0D, 1D, and 2D cells are
    extracted. All 2D faces that are used by only one 3D cell (i.e.,
    boundary faces) are extracted. The filter will handle any type of
    dataset, including unstructured grids with non-linear cells. (See
    also GeometryFilter for additional documentation and information -
    GeometryFilter is the preferred filter to use in most cases and
    may be deprecated in the future.)
    
    The filter only has only a few options: methods for passing through
    point and cell ids (to support picking); and controls for nonlinear
    cell subdivision. At this time DataSetSurfaceFilter has the
    distinction of being able to process non-linear cells requiring
    subdivision. For this reason, DataSetSurfaceFilter should be used
    with non-linear cells; otherwise GeometryFilter should be used.
    (Note: by default this filter will delegate processing of linear
    UnstructuredGrids to GeometryFilter as GeometryFilter is so
    much faster. And GeometryFilter will delegate to
    DataSetSurfaceFilter when it encounters nonlinear cells.)
    
    @section fast_mode Fast Mode
    
    DataSetSurfaceFilter is sometimes used to simply render a 3D
    dataset. In which case we only are concerned about an approximate
    representation of the data and not necessarily the true exterior
    surface. In that case, simply set the fast_mode flag to true.
    
    Currently fast_mode is used when extracting surface from a structured
    dataset or when `Delegation` is true. When Delegation is true, the
    flag is passed on to `vtkgeometry_filter` (see
    `vtkgeometry_filter:set_fast_mode`).
    
    @warning
    At one time, DataSetSurfaceFilter was a faster version of
    GeometryFilter when processing unstructured grids, however
    GeometryFilter is now faster. Also, DataSetSurfaceFilter
    typically uses more memory than GeometryFilter.  Consequently as a
    convenience to the user, DataSetSurfaceFilter will delegate to
    GeometryFilter when processing linear UnstructuredGrids. This
    typically produces a 5-10x speed up. (See GeometryFilter for more
    information.) This delegation can be disabled by setting the
    Delegation data member.
    
    @warning
    DataSetSurfaceFilter will generally not preserve topological
    connectivity.  In other words, the output polygonal primitives may
    not be connected although in the originating dataset the boundary
    entities (e.g., faces) may have been connected. This can result in
    issues for filters that expect proper topological connectivity (e.g.,
    QuadricDecimation or FeatureEdges).
    
    @warning
    A key step in this algorithm (for 3D cells) is to count the number
    times a face is used by a cell. If used only once, then the face is
    considered a boundary face and sent to the filter output. The filter
    determines this by creating a hash table of faces: faces that are
    placed into the hash table a single time are used only once, and
    therefore sent to the output. Thus large amounts of extra memory is
    necessary to build the hash table. This obsoleted approach requires a
    significant amount of memory, and is a significant bottleneck to
    threading.
    
    @warning
    This filter may create duplicate points. Unlike GeometryFilter, it
    does not have the option to merge points. However it will eliminate
    points not used by any output polygonal primitive (i.e., not on the
    boundary).
    
    @sa
    GeometryFilter StructuredGridGeometryFilter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDataSetSurfaceFilter, obj, update, **traits)
    
    delegation = tvtk_base.false_bool_trait(desc=\
        """
        Disable delegation to an internal GeometryFilter. The geometry
        filter runs much faster (especially for unstructured grids);
        however the two filters produce slightly different output. Hence
        by default delegation is disabled.
        """
    )

    def _delegation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDelegation,
                        self.delegation_)

    fast_mode = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off fast mode execution. If enabled, fast mode typically
        runs much faster (2-3x) than the standard algorithm, however the
        output is an approximation to the correct result. Also, note that
        the fast_mode depends on the data member Degree for its execution.
        """
    )

    def _fast_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFastMode,
                        self.fast_mode_)

    pass_through_cell_ids = tvtk_base.false_bool_trait(desc=\
        """
        If on, the output polygonal dataset will have a celldata array
        that holds the cell index of the original 3D cell that produced
        each output cell. This is useful for cell picking. The default is
        off to conserve memory.
        """
    )

    def _pass_through_cell_ids_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassThroughCellIds,
                        self.pass_through_cell_ids_)

    pass_through_point_ids = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _pass_through_point_ids_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassThroughPointIds,
                        self.pass_through_point_ids_)

    use_strips = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _use_strips_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseStrips,
                        self.use_strips_)

    nonlinear_subdivision_level = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        If the input is an unstructured grid with nonlinear faces, this
        parameter determines how many times the face is subdivided into
        linear faces.  If 0, the output is the equivalent of its linear
        counterpart (and the midpoints determining the nonlinear
        interpolation are discarded).  If 1 (the default), the nonlinear
        face is triangulated based on the midpoints.  If greater than 1,
        the triangulated pieces are recursively subdivided to reach the
        desired subdivision.  Setting the value to greater than 1 may
        cause some point data to not be passed even if no nonlinear faces
        exist.  This option has no effect if the input is not an
        unstructured grid.
        """
    )

    def _nonlinear_subdivision_level_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNonlinearSubdivisionLevel,
                        self.nonlinear_subdivision_level)

    original_cell_ids_name = traits.String('vtkOriginalCellIds', enter_set=True, auto_set=False, desc=\
        """
        If pass_through_cell_ids or pass_through_point_ids is on, then these
        ivars control the name given to the field in which the ids are
        written into.  If set to nullptr, then OriginalCellIds or
        OriginalPointIds (the default) is used, respectively.
        """
    )

    def _original_cell_ids_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOriginalCellIdsName,
                        self.original_cell_ids_name)

    original_point_ids_name = traits.String('vtkOriginalPointIds', enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _original_point_ids_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOriginalPointIdsName,
                        self.original_point_ids_name)

    piece_invariant = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        If piece_invariant is true, DataSetSurfaceFilter requests 1
        ghost level from input in order to remove internal surface that
        are between processes. False by default.
        """
    )

    def _piece_invariant_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPieceInvariant,
                        self.piece_invariant)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def data_set_execute(self, *args):
        """
        data_set_execute(self, input:DataSet, output:PolyData) -> int
        C++: virtual int data_set_execute(DataSet *input,
            PolyData *output)
        Execute the filter on input and store the result in output. The
        correct function should be used accordingly to the type of the
        input.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DataSetExecute, *my_args)
        return ret

    def structured_execute(self, *args):
        """
        structured_execute(self, input:DataSet, output:PolyData,
            ext:[int, ...], wholeExt:[int, ...]) -> int
        C++: virtual int structured_execute(DataSet *input,
            PolyData *output, IdType *ext, IdType *wholeExt)
        structured_execute(self, input:DataSet, output:PolyData,
            ext32:(int, ...), wholeExt32:(int, ...)) -> int
        C++: virtual int structured_execute(DataSet *input,
            PolyData *output, const int *ext32, const int *wholeExt32)
        Direct access methods so that this class can be used as an
        algorithm without using it as a filter (i.e., no pipeline
        updates).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.StructuredExecute, *my_args)
        return ret

    def uniform_grid_execute(self, *args):
        """
        uniform_grid_execute(self, input:DataSet, output:PolyData,
            ext:[int, ...], wholeExt:[int, ...], extractface:[bool, bool,
            bool, bool, bool, bool]) -> int
        C++: virtual int uniform_grid_execute(DataSet *input,
            PolyData *output, IdType *ext, IdType *wholeExt,
            bool extractface[6])
        uniform_grid_execute(self, input:DataSet, output:PolyData,
            ext32:(int, ...), wholeExt32:(int, ...), extractface:[bool,
            bool, bool, bool, bool, bool]) -> int
        C++: virtual int uniform_grid_execute(DataSet *input,
            PolyData *output, const int *ext32, const int *wholeExt32,
            bool extractface[6])"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.UniformGridExecute, *my_args)
        return ret

    def unstructured_grid_execute(self, *args):
        """
        unstructured_grid_execute(self, input:DataSet,
            output:PolyData) -> int
        C++: virtual int unstructured_grid_execute(DataSet *input,
            PolyData *output)
        Execute the filter on input and store the result in output. The
        correct function should be used accordingly to the type of the
        input.
        
        Input can be any subclass of UnstructuredGridBase. In case of
        a UnstructuredGrid or subclass instance, an optimized version
        of the filter is executed.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.UnstructuredGridExecute, *my_args)
        return ret

    _updateable_traits_ = \
    (('delegation', 'GetDelegation'), ('fast_mode', 'GetFastMode'),
    ('pass_through_cell_ids', 'GetPassThroughCellIds'),
    ('pass_through_point_ids', 'GetPassThroughPointIds'), ('use_strips',
    'GetUseStrips'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('nonlinear_subdivision_level', 'GetNonlinearSubdivisionLevel'),
    ('original_cell_ids_name', 'GetOriginalCellIdsName'),
    ('original_point_ids_name', 'GetOriginalPointIdsName'),
    ('piece_invariant', 'GetPieceInvariant'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'delegation', 'fast_mode',
    'global_warning_display', 'pass_through_cell_ids',
    'pass_through_point_ids', 'release_data_flag', 'use_strips',
    'nonlinear_subdivision_level', 'original_cell_ids_name',
    'original_point_ids_name', 'piece_invariant', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DataSetSurfaceFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DataSetSurfaceFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['delegation', 'fast_mode', 'pass_through_cell_ids',
            'pass_through_point_ids', 'use_strips'], [],
            ['nonlinear_subdivision_level', 'original_cell_ids_name',
            'original_point_ids_name', 'piece_invariant']),
            title='Edit DataSetSurfaceFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DataSetSurfaceFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

