# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class ConnectedPointsFilter(PolyDataAlgorithm):
    """
    ConnectedPointsFilter - extract / segment points based on
    geometric connectivity
    
    Superclass: PolyDataAlgorithm
    
    ConnectedPointsFilter is a filter that extracts and/or segments
    points from a point cloud based on geometric distance measures (e.g.,
    proximity, normal alignments, etc.) and optional measures such as
    scalar range. The default operation is to segment the points into
    "connected" regions where the connection is determined by an
    appropriate distance measure. Each region is given a region id.
    Optionally, the filter can output the largest connected region of
    points; a particular region (via id specification); those regions
    that are seeded using a list of input point ids; or the region of
    points closest to a specified position.
    
    The key parameter of this filter is the radius defining a sphere
    around each point which defines a local neighborhood: any other
    points in the local neighborhood are assumed connected to the point.
    Note that the radius is defined in absolute terms.
    
    Other parameters are used to further qualify what it means to be a
    neighboring point. For example, scalar range and/or point normals can
    be used to further constrain the neighborhood. Also the extraction
    mode defines how the filter operates. By default, all regions are
    extracted but it is possible to extract particular regions; the
    region closest to a seed point; seeded regions; or the largest region
    found while processing. By default, all regions are extracted.
    
    On output, all points are labeled with a region number. However note
    that the number of input and output points may not be the same: if
    not extracting all regions then the output size may be less than the
    input size.
    
    @sa
    PolyDataConnectivityFilter ConnectivityFilter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkConnectedPointsFilter, obj, update, **traits)
    
    aligned_normals = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off connectivity based on point normal consistency. If
        on, and point normals are defined, points are connected only if
        they satisfy other criterion (e.g., geometric proximity, scalar
        connectivity, etc.) AND the angle between normals is no greater
        than normal_angle;
        """
    )

    def _aligned_normals_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAlignedNormals,
                        self.aligned_normals_)

    scalar_connectivity = tvtk_base.false_bool_trait(desc=\
        """
        Turn on/off connectivity based on scalar value. If on, points are
        connected only if they satisfy the various geometric criterion
        AND one of the points scalar values falls in the scalar range
        specified.
        """
    )

    def _scalar_connectivity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScalarConnectivity,
                        self.scalar_connectivity_)

    extraction_mode = tvtk_base.RevPrefixMap({'all_regions': 5, 'closest_point_region': 6, 'largest_region': 4, 'point_seeded_regions': 1, 'specified_regions': 3}, default_value='all_regions', desc=\
        """
        Control the extraction of connected regions.
        """
    )

    def _extraction_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExtractionMode,
                        self.extraction_mode_)

    closest_point = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        """
        Use to specify x-y-z point coordinates when extracting the region
        closest to a specified point.
        """
    )

    def _closest_point_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetClosestPoint,
                        self.closest_point)

    def _get_locator(self):
        return wrap_vtk(self._vtk_obj.GetLocator())
    def _set_locator(self, arg):
        old_val = self._get_locator()
        self._wrap_call(self._vtk_obj.SetLocator,
                        deref_vtk(arg))
        self.trait_property_changed('locator', old_val, arg)
    locator = traits.Property(_get_locator, _set_locator, desc=\
        """
        
        """
    )

    normal_angle = traits.Trait(10.0, traits.Range(0.0001, 90.0, enter_set=True, auto_set=False), desc=\
        """
        Specify a threshold for normal angles. If aligned_normals_on is
        set, then points are connected if the angle between their normals
        is within this angle threshold (expressed in degress).
        """
    )

    def _normal_angle_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormalAngle,
                        self.normal_angle)

    radius = traits.Trait(1.0, traits.Range(0.0, 1e+299, enter_set=True, auto_set=False), desc=\
        """
        Set / get the radius variable specifying a local sphere used to
        define local point neighborhood.
        """
    )

    def _radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRadius,
                        self.radius)

    scalar_range = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(0.0, 1.0), cols=2, desc=\
        """
        Set the scalar range to use to extract points based on scalar
        connectivity.
        """
    )

    def _scalar_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScalarRange,
                        self.scalar_range)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_number_of_extracted_regions(self):
        return self._vtk_obj.GetNumberOfExtractedRegions()
    number_of_extracted_regions = traits.Property(_get_number_of_extracted_regions, desc=\
        """
        Obtain the number of connected regions. The return value is valid
        only after the filter has executed.
        """
    )

    def add_seed(self, *args):
        """
        add_seed(self, id:int) -> None
        C++: void add_seed(IdType id)
        Add a non-negative point seed id. Note: ids are 0-offset.
        """
        ret = self._wrap_call(self._vtk_obj.AddSeed, *args)
        return ret

    def add_specified_region(self, *args):
        """
        add_specified_region(self, id:int) -> None
        C++: void add_specified_region(IdType id)
        Add a non-negative region id to extract. Note: ids are 0-offset.
        """
        ret = self._wrap_call(self._vtk_obj.AddSpecifiedRegion, *args)
        return ret

    def delete_seed(self, *args):
        """
        delete_seed(self, id:int) -> None
        C++: void delete_seed(IdType id)
        Delete a point seed id. Note: ids are 0-offset.
        """
        ret = self._wrap_call(self._vtk_obj.DeleteSeed, *args)
        return ret

    def delete_specified_region(self, *args):
        """
        delete_specified_region(self, id:int) -> None
        C++: void delete_specified_region(IdType id)
        Delete a region id to extract. Note: ids are 0-offset.
        """
        ret = self._wrap_call(self._vtk_obj.DeleteSpecifiedRegion, *args)
        return ret

    def initialize_seed_list(self):
        """
        initialize_seed_list(self) -> None
        C++: void initialize_seed_list()
        Initialize list of point ids ids used to seed regions.
        """
        ret = self._vtk_obj.InitializeSeedList()
        return ret
        

    def initialize_specified_region_list(self):
        """
        initialize_specified_region_list(self) -> None
        C++: void initialize_specified_region_list()
        Initialize list of region ids to extract.
        """
        ret = self._vtk_obj.InitializeSpecifiedRegionList()
        return ret
        

    _updateable_traits_ = \
    (('aligned_normals', 'GetAlignedNormals'), ('scalar_connectivity',
    'GetScalarConnectivity'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('extraction_mode', 'GetExtractionMode'), ('closest_point',
    'GetClosestPoint'), ('normal_angle', 'GetNormalAngle'), ('radius',
    'GetRadius'), ('scalar_range', 'GetScalarRange'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'aligned_normals', 'debug',
    'global_warning_display', 'release_data_flag', 'scalar_connectivity',
    'extraction_mode', 'closest_point', 'normal_angle', 'progress_text',
    'radius', 'scalar_range'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ConnectedPointsFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ConnectedPointsFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['aligned_normals', 'scalar_connectivity'], ['extraction_mode'],
            ['closest_point', 'normal_angle', 'radius', 'scalar_range']),
            title='Edit ConnectedPointsFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ConnectedPointsFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

