# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class BinnedDecimation(PolyDataAlgorithm):
    """
    BinnedDecimation - reduce the number of triangles in a PolyData
    mesh
    
    Superclass: PolyDataAlgorithm
    
    BinnedDecimation is a filter to reduce the number of triangles in
    a triangle mesh represented by PolyData. It is similar to
    QuadricClustering in concept, although it is performance
    accelerated: it does not use quadric error metrics to position points
    in the bins, plus it is threaded. (See QuadricClustering for more
    information.) It also takes some short cuts in the interest of speed:
    it limits the binning resolution to no more than 2^31 bins; and it
    can (optionally) reuse the input points in the output (to save memory
    and computational costs).
    
    A high-level overview of the algorithm is as follows. Points are
    binned into a regular grid subdivided in the x-y-z directions. The
    idea is to combine all the points within each bin into a single point
    which is then used by the output triangles. Four options are
    available to generate the output points. If the input points are to
    be reused as the output points, then all points in the same bin
    simply adopt the coordinates of one of the selected points in the bin
    (and thus all points in the bin take on the same output point id).
    Alternatively, if new output points are to be generated, then either
    one point is selected; the centers of occupied bins can be used as
    the output point coordinates; or an average position of all points
    falling into the bin can be used to generate the bin point. Finally,
    triangles are inserted into the output: triangles whose three, binned
    points lie in separate bins are sent to the output, while all others
    are discarded (i.e., triangles with two or more points in the same
    bin are not sent to the output).
    
    To use this filter, specify the divisions defining the spatial
    subdivision in the x, y, and z directions. Of course you must also
    specify an input PolyData / filter connection. Higher division
    levels generally produce results closer to the original mesh. Note
    that for performance reasons (i.e., related to memory), the maximum
    divisions in the x-y-z directions is limited in such a way (i.e.,
    proportional scaling of divisions is used) so as to ensure that no
    more than 2^31 bins are used. Higher divisions have modest impact on
    the overall performance of the algorithm, although the resolution of
    the output PolyData is affected significantly (i.e., many more
    triangles may be generated).
    
    @warning
    This filter can drastically affect mesh topology, i.e., topology is
    not preserved.
    
    @warning
    This filter and QuadricClustering produce similar results, with
    QuadricClustering theoretically producing better results. In
    practice however, BinnedDecimation produces results that are
    visually close to QuadricClustering at speeds approaching 10-100x
    faster (depending on the bin divisions, and how the output points are
    generated), and the algorithm requires much less memory. Note that
    the API of this filter is a subset of QuadricClustering and can
    often be used interchangeably with QuadricClustering.
    
    @warning
    Algorithm 4) BIN_CENTERS uses a very different implementation
    strategy requiring a sort of all points. It scales better as the
    number of bins increases.
    
    @warning
    For certain types of geometry (e.g., a mostly 2D plane with jitter in
    the normal direction), this decimator can perform badly. In this
    situation, set the number of bins in the normal direction to one.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential execution type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    QuadricClustering DecimatePro Decimate QuadricLODActor
    TriangleFilter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkBinnedDecimation, obj, update, **traits)
    
    auto_adjust_number_of_divisions = tvtk_base.true_bool_trait(desc=\
        """
        Enable automatic adjustment of number of divisions. If disabled,
        the number of divisions specified by the user is always used (as
        long as it is valid). The default is On.
        """
    )

    def _auto_adjust_number_of_divisions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAutoAdjustNumberOfDivisions,
                        self.auto_adjust_number_of_divisions_)

    produce_cell_data = tvtk_base.false_bool_trait(desc=\
        """
        This flag directs the filter to copy cell data from input to
        output. This flag is off by default.
        """
    )

    def _produce_cell_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetProduceCellData,
                        self.produce_cell_data_)

    produce_point_data = tvtk_base.true_bool_trait(desc=\
        """
        This flag directs the filter to produce output point data from
        the input point data (on by default). If the produce_point_data is
        set to INPUT_POINTS, point data is simply passed from input to
        output (since the points don't change). If the point generation
        mode is set to BIN_AVERAGES, then the average of all point data
        values withing a bin are associated with the point generated in
        the bin. If the point generation mode is either BIN_POINTS or
        BIN_CENTERS, then the point data values from one of the points
        falling into the bin is used.
        """
    )

    def _produce_point_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetProducePointData,
                        self.produce_point_data_)

    point_generation_mode = tvtk_base.RevPrefixMap({'bin_points': 2, 'bin_averages': 4, 'bin_centers': 3, 'use_input_points': 1}, default_value='bin_points', desc=\
        """
        
        """
    )

    def _point_generation_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPointGenerationMode,
                        self.point_generation_mode_)

    division_origin = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        """
        This is an alternative way to set up the bins.  If you are trying
        to match boundaries between pieces, then you should use these
        methods rather than set_number_of_divisions(). To use these methods,
        specify the origin and spacing of the spatial binning.
        """
    )

    def _division_origin_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDivisionOrigin,
                        self.division_origin)

    division_spacing = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(1.0, 1.0, 1.0), cols=3, desc=\
        """
        
        """
    )

    def _division_spacing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDivisionSpacing,
                        self.division_spacing)

    number_of_divisions = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="int64", value=(256, 256, 256), cols=3, desc=\
        """
        
        """
    )

    def _number_of_divisions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfDivisions,
                        self.number_of_divisions)

    number_of_x_divisions = traits.Int(256, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the number of divisions along each axis for the spatial
        bins. The number of spatial bins is
        number_of_x_divisions*number_of_y_divisions* number_of_z_divisions. The
        filter may choose to ignore large numbers of divisions if the
        input has few points and auto_adjust_number_of_divisions is enabled.
        Also, the maximum number of divisions is controlled so that no
        more than 2^31 bins are created. (If bin adjustment due to the
        limit on the number of bins is necessary, then a proportional
        scaling of the divisions in the x-y-z directions is used.) This
        API has been adopted to be consistent with QuadricClustering.
        """
    )

    def _number_of_x_divisions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfXDivisions,
                        self.number_of_x_divisions)

    number_of_y_divisions = traits.Int(256, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _number_of_y_divisions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfYDivisions,
                        self.number_of_y_divisions)

    number_of_z_divisions = traits.Int(256, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _number_of_z_divisions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfZDivisions,
                        self.number_of_z_divisions)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_large_ids(self):
        return self._vtk_obj.GetLargeIds()
    large_ids = traits.Property(_get_large_ids, desc=\
        """
        Return a flag indicating whether large ids were used during
        execution. The value of this flag is only valid after filter
        execution. The filter may use a smaller id type unless it must
        use IdType to represent points and cell ids.
        """
    )

    _updateable_traits_ = \
    (('auto_adjust_number_of_divisions',
    'GetAutoAdjustNumberOfDivisions'), ('produce_cell_data',
    'GetProduceCellData'), ('produce_point_data', 'GetProducePointData'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('point_generation_mode', 'GetPointGenerationMode'),
    ('division_origin', 'GetDivisionOrigin'), ('division_spacing',
    'GetDivisionSpacing'), ('number_of_divisions',
    'GetNumberOfDivisions'), ('number_of_x_divisions',
    'GetNumberOfXDivisions'), ('number_of_y_divisions',
    'GetNumberOfYDivisions'), ('number_of_z_divisions',
    'GetNumberOfZDivisions'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'auto_adjust_number_of_divisions', 'debug',
    'global_warning_display', 'produce_cell_data', 'produce_point_data',
    'release_data_flag', 'point_generation_mode', 'division_origin',
    'division_spacing', 'number_of_divisions', 'number_of_x_divisions',
    'number_of_y_divisions', 'number_of_z_divisions', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(BinnedDecimation, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit BinnedDecimation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['auto_adjust_number_of_divisions', 'produce_cell_data',
            'produce_point_data'], ['point_generation_mode'], ['division_origin',
            'division_spacing', 'number_of_divisions', 'number_of_x_divisions',
            'number_of_y_divisions', 'number_of_z_divisions']),
            title='Edit BinnedDecimation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit BinnedDecimation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

