# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.pass_input_type_algorithm import PassInputTypeAlgorithm


class ArrayCalculator(PassInputTypeAlgorithm):
    """
    ArrayCalculator - perform mathematical operations on data in field
    data arrays
    
    Superclass: PassInputTypeAlgorithm
    
    ArrayCalculator performs operations on vectors or scalars in field
    data arrays.  It uses FunctionParser/vtkExprTkFunctionParser to do
    the parsing and to evaluate the function for each entry in the input
    arrays.  The arrays used in a given function must be all in point
    data or all in cell data. The resulting array will be stored as a
    field data array.  The result array can either be stored in a new
    array or it can overwrite an existing array. ArrayCalculator can
    run in parallel using SMPTools.
    
    The functions that this array calculator understands is:
    
    standard operations: +
    -
    * / ^ . (only by FunctionParser) build unit vectors: iHat, jHat,
       kHat (ie (1,0,0), (0,1,0), (0,0,1)) abs acos asin atan ceil cos
       cosh exp floor ln mag min max norm dot (only by
       ExprTkFunctionParser) cross sign sin sinh sqrt tan tanh  Note
       that some of these operations work on scalars, some on vectors,
       and some on both (e.g., you can multiply a scalar times a vector).
    The operations are performed tuple-wise (i.e., tuple-by-tuple). The
       user must specify which arrays to use as vectors and/or scalars,
       and the name of the output data array.
    
    @sa
    For more detailed documentation of the supported functionality see:
    1) FunctionParser
    2) ExprTkFunctionParser (default)
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkArrayCalculator, obj, update, **traits)
    
    coordinate_results = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _coordinate_results_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCoordinateResults,
                        self.coordinate_results_)

    ignore_missing_arrays = tvtk_base.false_bool_trait(desc=\
        """
        When this option is set, silently ignore datasets where the
        requested field data array is not present. When an input array is
        not present, the result array will not be generated nor added to
        the output.
        """
    )

    def _ignore_missing_arrays_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIgnoreMissingArrays,
                        self.ignore_missing_arrays_)

    replace_invalid_values = tvtk_base.false_bool_trait(desc=\
        """
        When replace_invalid_values is on, all invalid values (such as
        sqrt(-2), note that function parser does not handle complex
        numbers) will be replaced by replacement_value. Otherwise an error
        will be reported.
        """
    )

    def _replace_invalid_values_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReplaceInvalidValues,
                        self.replace_invalid_values_)

    result_normals = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _result_normals_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetResultNormals,
                        self.result_normals_)

    result_t_coords = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _result_t_coords_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetResultTCoords,
                        self.result_t_coords_)

    attribute_type = tvtk_base.RevPrefixMap({'default': -1, 'cell_data': 1, 'edge_data': 5, 'point_data': 0, 'row_data': 6, 'vertex_data': 4}, default_value='default', desc=\
        """
        Control which attribute_type the filter operates on (point data or
        cell data for DataSets).  By default the filter uses
        Point/Vertex/Row data depending on the input data type.  The
        input value for this function should be one of the constants in
        DataObject::AttributeTypes or DEFAULT_ATTRIBUTE_TYPE for 'default
        behavior'.
        """
    )

    def _attribute_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAttributeType,
                        self.attribute_type_)

    function_parser_type = tvtk_base.RevPrefixMap({'expr_tk_function_parser': 1, 'function_parser': 0}, default_value='expr_tk_function_parser', desc=\
        """
        Set/Get the function_parser type that will be used.
        FunctionParser = 0, ExprTkFunctionParser = 1. Default is 1.
        """
    )

    def _function_parser_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFunctionParserType,
                        self.function_parser_type_)

    function = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        Set/Get the function to be evaluated.
        """
    )

    def _function_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFunction,
                        self.function)

    replacement_value = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _replacement_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReplacementValue,
                        self.replacement_value)

    result_array_name = traits.String('resultArray', enter_set=True, auto_set=False, desc=\
        """
        Set the name of the array in which to store the result of
        evaluating this function.  If this is the name of an existing
        array, that array will be overwritten.  Otherwise a new array
        will be created with the specified name.
        """
    )

    def _result_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetResultArrayName,
                        self.result_array_name)

    result_array_type = traits.Int(11, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _result_array_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetResultArrayType,
                        self.result_array_type)

    def _get_data_set_output(self):
        return wrap_vtk(self._vtk_obj.GetDataSetOutput())
    data_set_output = traits.Property(_get_data_set_output, desc=\
        """
        Returns the output of the filter downcast to a DataSet or
        nullptr if the cast fails.
        """
    )

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    def _get_number_of_scalar_arrays(self):
        return self._vtk_obj.GetNumberOfScalarArrays()
    number_of_scalar_arrays = traits.Property(_get_number_of_scalar_arrays, desc=\
        """
        
        """
    )

    def _get_number_of_vector_arrays(self):
        return self._vtk_obj.GetNumberOfVectorArrays()
    number_of_vector_arrays = traits.Property(_get_number_of_vector_arrays, desc=\
        """
        
        """
    )

    def get_scalar_array_name(self, *args):
        """
        get_scalar_array_name(self, i:int) -> str
        C++: std::string get_scalar_array_name(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetScalarArrayName, *args)
        return ret

    def _get_scalar_array_names(self):
        return self._vtk_obj.GetScalarArrayNames()
    scalar_array_names = traits.Property(_get_scalar_array_names, desc=\
        """
        Methods to get information about the current variables.
        """
    )

    def get_scalar_variable_name(self, *args):
        """
        get_scalar_variable_name(self, i:int) -> str
        C++: std::string get_scalar_variable_name(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetScalarVariableName, *args)
        return ret

    def _get_scalar_variable_names(self):
        return self._vtk_obj.GetScalarVariableNames()
    scalar_variable_names = traits.Property(_get_scalar_variable_names, desc=\
        """
        
        """
    )

    def get_selected_scalar_component(self, *args):
        """
        get_selected_scalar_component(self, i:int) -> int
        C++: int get_selected_scalar_component(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetSelectedScalarComponent, *args)
        return ret

    def _get_selected_scalar_components(self):
        return self._vtk_obj.GetSelectedScalarComponents()
    selected_scalar_components = traits.Property(_get_selected_scalar_components, desc=\
        """
        
        """
    )

    def get_selected_vector_components(self, *args):
        """
        get_selected_vector_components(self, i:int) -> Tuple_IiLi3EE
        C++: Tuple<int, 3> get_selected_vector_components(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetSelectedVectorComponents, *args)
        return wrap_vtk(ret)

    def get_vector_array_name(self, *args):
        """
        get_vector_array_name(self, i:int) -> str
        C++: std::string get_vector_array_name(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetVectorArrayName, *args)
        return ret

    def _get_vector_array_names(self):
        return self._vtk_obj.GetVectorArrayNames()
    vector_array_names = traits.Property(_get_vector_array_names, desc=\
        """
        
        """
    )

    def get_vector_variable_name(self, *args):
        """
        get_vector_variable_name(self, i:int) -> str
        C++: std::string get_vector_variable_name(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetVectorVariableName, *args)
        return ret

    def _get_vector_variable_names(self):
        return self._vtk_obj.GetVectorVariableNames()
    vector_variable_names = traits.Property(_get_vector_variable_names, desc=\
        """
        
        """
    )

    def add_coordinate_scalar_variable(self, *args):
        """
        add_coordinate_scalar_variable(self, variableName:str,
            component:int=0) -> None
        C++: void add_coordinate_scalar_variable(const char *variableName,
            int component=0)
        Add a variable name, a corresponding array name, and which
        components of the array to use. The variable name should be
        sanitized or in quotes.
        
        ote A sanitized variable name is accepted by the following regex:
        ^[a-zA-Z][a-zA-Z_0-9]*.
        """
        ret = self._wrap_call(self._vtk_obj.AddCoordinateScalarVariable, *args)
        return ret

    def add_coordinate_vector_variable(self, *args):
        """
        add_coordinate_vector_variable(self, variableName:str,
            component0:int=0, component1:int=1, component2:int=2) -> None
        C++: void add_coordinate_vector_variable(const char *variableName,
            int component0=0, int component1=1, int component2=2)"""
        ret = self._wrap_call(self._vtk_obj.AddCoordinateVectorVariable, *args)
        return ret

    def add_scalar_array_name(self, *args):
        """
        add_scalar_array_name(self, arrayName:str, component:int=0) -> None
        C++: void add_scalar_array_name(const char *arrayName,
            int component=0)
        Add an array name to the list of arrays used in the function and
        specify which components of the array to use in evaluating the
        function. The array name must match the name in the function. If
        the array name is not sanitized, the variable name will be the
        array name enclosed in quotes. Use add_scalar_variable or
        add_vector_variable to use a user defined variable name.
        
        ote A sanitized variable name is accepted by the following regex:
        ^[a-zA-Z][a-zA-Z_0-9]*.
        """
        ret = self._wrap_call(self._vtk_obj.AddScalarArrayName, *args)
        return ret

    def add_scalar_variable(self, *args):
        """
        add_scalar_variable(self, variableName:str, arrayName:str,
            component:int=0) -> None
        C++: void add_scalar_variable(const char *variableName,
            const char *arrayName, int component=0)
        Add a variable name, a corresponding array name, and which
        components of the array to use. The variable name should be
        sanitized or in quotes.
        
        ote A sanitized variable name is accepted by the following regex:
        ^[a-zA-Z][a-zA-Z_0-9]*.
        """
        ret = self._wrap_call(self._vtk_obj.AddScalarVariable, *args)
        return ret

    def add_vector_array_name(self, *args):
        """
        add_vector_array_name(self, arrayName:str, component0:int=0,
            component1:int=1, component2:int=2) -> None
        C++: void add_vector_array_name(const char *arrayName,
            int component0=0, int component1=1, int component2=2)"""
        ret = self._wrap_call(self._vtk_obj.AddVectorArrayName, *args)
        return ret

    def add_vector_variable(self, *args):
        """
        add_vector_variable(self, variableName:str, arrayName:str,
            component0:int=0, component1:int=1, component2:int=2) -> None
        C++: void add_vector_variable(const char *variableName,
            const char *arrayName, int component0=0, int component1=1,
            int component2=2)"""
        ret = self._wrap_call(self._vtk_obj.AddVectorVariable, *args)
        return ret

    def remove_all_variables(self):
        """
        remove_all_variables(self) -> None
        C++: void remove_all_variables()
        Remove all the variable names and their associated array names.
        """
        ret = self._vtk_obj.RemoveAllVariables()
        return ret
        

    def remove_coordinate_scalar_variables(self):
        """
        remove_coordinate_scalar_variables(self) -> None
        C++: virtual void remove_coordinate_scalar_variables()
        Remove all the coordinate variables.
        """
        ret = self._vtk_obj.RemoveCoordinateScalarVariables()
        return ret
        

    def remove_coordinate_vector_variables(self):
        """
        remove_coordinate_vector_variables(self) -> None
        C++: virtual void remove_coordinate_vector_variables()
        Remove all the coordinate variables.
        """
        ret = self._vtk_obj.RemoveCoordinateVectorVariables()
        return ret
        

    def remove_scalar_variables(self):
        """
        remove_scalar_variables(self) -> None
        C++: virtual void remove_scalar_variables()
        Remove all the scalar variable names and their associated array
        names.
        """
        ret = self._vtk_obj.RemoveScalarVariables()
        return ret
        

    def remove_vector_variables(self):
        """
        remove_vector_variables(self) -> None
        C++: virtual void remove_vector_variables()
        Remove all the scalar variable names and their associated array
        names.
        """
        ret = self._vtk_obj.RemoveVectorVariables()
        return ret
        

    _updateable_traits_ = \
    (('coordinate_results', 'GetCoordinateResults'),
    ('ignore_missing_arrays', 'GetIgnoreMissingArrays'),
    ('replace_invalid_values', 'GetReplaceInvalidValues'),
    ('result_normals', 'GetResultNormals'), ('result_t_coords',
    'GetResultTCoords'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('attribute_type', 'GetAttributeType'), ('function_parser_type',
    'GetFunctionParserType'), ('function', 'GetFunction'),
    ('replacement_value', 'GetReplacementValue'), ('result_array_name',
    'GetResultArrayName'), ('result_array_type', 'GetResultArrayType'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'coordinate_results', 'debug',
    'global_warning_display', 'ignore_missing_arrays',
    'release_data_flag', 'replace_invalid_values', 'result_normals',
    'result_t_coords', 'attribute_type', 'function_parser_type',
    'function', 'progress_text', 'replacement_value', 'result_array_name',
    'result_array_type'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ArrayCalculator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ArrayCalculator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['coordinate_results', 'ignore_missing_arrays',
            'replace_invalid_values', 'result_normals', 'result_t_coords'],
            ['attribute_type', 'function_parser_type'], ['function',
            'replacement_value', 'result_array_name', 'result_array_type']),
            title='Edit ArrayCalculator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ArrayCalculator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

