# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Archiver(Object):
    """
    Archiver - Writes an archive
    
    Superclass: Object
    
    Archiver is a base class for constructing an archive. The default
    implementation constructs a directory at the location of the
    archive_name and populates it with files and directories as requested
    by Insert(). Classes that derive from Archiver can customize the
    output using such features as compression, in-memory serialization
    and third-party archival tools.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkArchiver, obj, update, **traits)
    
    archive_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        
        """
    )

    def _archive_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArchiveName,
                        self.archive_name)

    def close_archive(self):
        """
        close_archive(self) -> None
        C++: virtual void close_archive()
        Close the arhive.
        """
        ret = self._vtk_obj.CloseArchive()
        return ret
        

    def contains(self, *args):
        """
        contains(self, relativePath:str) -> bool
        C++: virtual bool contains(const std::string &relativePath)
        Checks if relativePath represents an entry in the archive.
        """
        ret = self._wrap_call(self._vtk_obj.Contains, *args)
        return ret

    def insert_into_archive(self, *args):
        """
        insert_into_archive(self, relativePath:str, data:str, size:int)
            -> None
        C++: virtual void insert_into_archive(
            const std::string &relativePath, const char *data,
            std::size_t size)
        Insert data of size size into the archive at relativePath.
        """
        ret = self._wrap_call(self._vtk_obj.InsertIntoArchive, *args)
        return ret

    def open_archive(self):
        """
        open_archive(self) -> None
        C++: virtual void open_archive()
        Open the arhive for writing.
        """
        ret = self._vtk_obj.OpenArchive()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('archive_name', 'GetArchiveName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'archive_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Archiver, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Archiver properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['archive_name']),
            title='Edit Archiver properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Archiver properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

