# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.pass_input_type_algorithm import PassInputTypeAlgorithm


class AnimateModes(PassInputTypeAlgorithm):
    """
    AnimateModes - animate mode shapes
    
    Superclass: PassInputTypeAlgorithm
    
    For certain file formats, like Exodus, simulation codes may use the
    timesteps and time values to represent quantities other than time.
    For example, for modal analysis, the natural frequency for each mode
    may be used as the time value. AnimateModes can be used to
    reinterpret time as mode shapes. The filter can also animate
    vibrations for each mode shape (when animate_vibrations is set to
    true). In that case, the time requested by the downstream pipeline is
    used to scale the displacement magnitude for a mode shape in a
    sinusoidal pattern, `cos(2*pi * requested-time)`.
    
    Historically, the VTK's Exodus reader (`vtkexodus_ii_reader`) had
    support for this internally. However, when implementation the
    IOSS-based reader for Exodus files (`vtkioss_reader`), it was decided
    that it's cleaner to leave the mode shape and vibration animation
    logic independent of the reader and thus make it usable with other
    file formats too. Hence this filter was created.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAnimateModes, obj, update, **traits)
    
    animate_vibrations = tvtk_base.true_bool_trait(desc=\
        """
        Set/Get whether the filter should animate the vibrations.
        Defaults to true. When set, the requested time is used compute
        displacements for the chosen mode shape. Defaults to true.
        """
    )

    def _animate_vibrations_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAnimateVibrations,
                        self.animate_vibrations_)

    displacement_preapplied = tvtk_base.false_bool_trait(desc=\
        """
        Get/Set whether displacements are pre-applied. Default is false.
        """
    )

    def _displacement_preapplied_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDisplacementPreapplied,
                        self.displacement_preapplied_)

    displacement_magnitude = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        Get/Set a scale factor to apply the displacements. Defaults to 1.
        """
    )

    def _displacement_magnitude_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDisplacementMagnitude,
                        self.displacement_magnitude)

    mode_shape = traits.Trait(1, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        """
        Get/Set the mode shape to animate. Defaults to 1.
        """
    )

    def _mode_shape_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetModeShape,
                        self.mode_shape)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    def _get_mode_shapes_range(self):
        return self._vtk_obj.GetModeShapesRange()
    mode_shapes_range = traits.Property(_get_mode_shapes_range, desc=\
        """
        Get the range for available mode shapes in the input. One must
        call `update_information` before check the range since the range
        is determined based on the number of input timesteps. The range
        is always `[1, <number of timesteps>]`.
        """
    )

    def _get_time_range(self):
        return self._vtk_obj.GetTimeRange()
    time_range = traits.Property(_get_time_range, desc=\
        """
        This returns (0, 1.0) as the range that can be used when
        animating a mode shape.
        """
    )

    _updateable_traits_ = \
    (('animate_vibrations', 'GetAnimateVibrations'),
    ('displacement_preapplied', 'GetDisplacementPreapplied'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('displacement_magnitude', 'GetDisplacementMagnitude'), ('mode_shape',
    'GetModeShape'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'animate_vibrations', 'debug',
    'displacement_preapplied', 'global_warning_display',
    'release_data_flag', 'displacement_magnitude', 'mode_shape',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AnimateModes, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AnimateModes properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['animate_vibrations', 'displacement_preapplied'], [],
            ['displacement_magnitude', 'mode_shape']),
            title='Edit AnimateModes properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AnimateModes properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

