# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.overlapping_amr_algorithm import OverlappingAMRAlgorithm


class AMRSliceFilter(OverlappingAMRAlgorithm):
    """
    AMRSliceFilter -  A concrete instance of
    OverlappingAMRAlgorithm which implements
     functionality for extracting slices from AMR data.
    
    Superclass: OverlappingAMRAlgorithm
    
    Unlike the conventional
     slice filter, the output of this filter is a 2-D AMR dataset itself.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAMRSliceFilter, obj, update, **traits)
    
    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        """
        
        """
    )

    max_resolution = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the maximum resolution used in this instance.
        """
    )

    def _max_resolution_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaxResolution,
                        self.max_resolution)

    normal = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the Axis normal. The accpetable values are defined in the
        normal_tag enum.
        """
    )

    def _normal_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormal,
                        self.normal)

    offset_from_origin = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the offset-from-origin of the slicing plane.
        """
    )

    def _offset_from_origin_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOffsetFromOrigin,
                        self.offset_from_origin)

    def fill_input_port_information(self, *args):
        """
        fill_input_port_information(self, port:int, info:Information)
            -> int
        C++: int fill_input_port_information(int port, Information *info)
            override;
        Fill the input port information objects for this algorithm.  This
        is invoked by the first call to get_input_port_information for each
        port so subclasses can specify what they can handle.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.FillInputPortInformation, *my_args)
        return ret

    def fill_output_port_information(self, *args):
        """
        fill_output_port_information(self, port:int, info:Information)
            -> int
        C++: int fill_output_port_information(int port, Information *info)
             override;
        See algorithm for more info.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.FillOutputPortInformation, *my_args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('max_resolution', 'GetMaxResolution'), ('normal', 'GetNormal'),
    ('offset_from_origin', 'GetOffsetFromOrigin'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'max_resolution', 'normal', 'offset_from_origin',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AMRSliceFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AMRSliceFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['max_resolution', 'normal', 'offset_from_origin']),
            title='Edit AMRSliceFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AMRSliceFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

