# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.cell import Cell


class TriangleStrip(Cell):
    """
    TriangleStrip - a cell that represents a triangle strip
    
    Superclass: Cell
    
    TriangleStrip is a concrete implementation of Cell to represent
    a 2D triangle strip. A triangle strip is a compact representation of
    triangles connected edge to edge in strip fashion. The connectivity
    of a triangle strip is three points defining an initial triangle,
    then for each additional triangle, a single point that, combined with
    the previous two points, defines the next triangle.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTriangleStrip, obj, update, **traits)
    
    def decompose_strip(self, *args):
        """
        decompose_strip(npts:int, pts:(int, ...), tris:CellArray)
            -> None
        C++: static void decompose_strip(int npts, const IdType *pts,
            CellArray *tris)
        Given a triangle strip, decompose it into a list of (triangle)
        polygons. The polygons are appended to the end of the list of
        triangles.
        """
        my_args = deref_array(args, [('int', ('int', Ellipsis), 'vtkCellArray')])
        ret = self._wrap_call(self._vtk_obj.DecomposeStrip, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(TriangleStrip, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit TriangleStrip properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit TriangleStrip properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit TriangleStrip properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

