# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class ThreeDLinearGridCrinkleExtractor(DataObjectAlgorithm):
    """
    ThreeDLinearGridCrinkleExtractor - fast extraction of cells
    intersected by a plane
    
    Superclass: DataObjectAlgorithm
    
    ThreeDLinearGridCrinkleExtractor is a specialized filter that, given a
    specified implicit function, extracts unstructured grid cells that
    intersect the implicit function. (Since the surface of these cells
    roughly follows the implicit function but is "bumpy", it is referred
    to as a "crinkle" suface.) This filter operates on
    UnstructuredGrids consisting of 3D linear cells: tetrahedra,
    hexahedra, voxels, pyramids, and/or wedges. (The cells are linear in
    the sense that each cell edge is a straight line.)  The filter is
    designed for high-speed, specialized operation. All other cell types
    are skipped and produce no output.
    
    To use this filter you must specify an input unstructured grid or
    CompositeDataSet (containing unstructured grids) and an implicit
    function to cut with.
    
    The remove_unused_points data member controls whether the filter remaps
    the input points to the output. Since the algorithm simply extracts a
    subset of the original data (points and cells), it is possible simply
    to pass the input points to the output, which is much faster (factor
    of ~2X) then mapping the input points to the output. Of course, not
    removing the unused points means extra points in the output dataset,
    but because the input points are shallow copied to the output, no
    additional memory is consumed.
    
    @warning
    When the input is of type CompositeDataSet the filter will process
    the unstructured grid(s) contained in the composite data set. As a
    result the output of this filter is then a MultiBlockDataSet
    containing multiple UnstructuredGrids. When a UnstructuredGrid
    is provided as input the output is a single UnstructuredGrid.
    
    @warning
    Input cells that are not of 3D linear type (tetrahedron, hexahedron,
    wedge, pyramid, and voxel) are simply skipped and not processed.
    
    @warning
    The filter is templated on types of input and output points, and
    input scalar type. To reduce object file bloat, only real points
    (float,double) are processed.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @warning
    The ExtractGeometry filter is similar to this filter when
    extract_only_boundary_cells is enabled.
    
    @sa
    ThreeDLinearGrid ThreeDLinearGridPlaneCutter ExtractGeometry
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtk3DLinearGridCrinkleExtractor, obj, update, **traits)
    
    copy_cell_data = tvtk_base.false_bool_trait(desc=\
        """
        Indicate whether to copy input cell data/attributes onto the
        output cells. By default this option is off.
        """
    )

    def _copy_cell_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCopyCellData,
                        self.copy_cell_data_)

    copy_point_data = tvtk_base.true_bool_trait(desc=\
        """
        Indicate whether to copy input point data/attributes onto the
        output points. By default this option is on.
        """
    )

    def _copy_point_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCopyPointData,
                        self.copy_point_data_)

    remove_unused_points = tvtk_base.false_bool_trait(desc=\
        """
        Indicate whether to eliminate unused output points. When this
        flag is disabled, the input points and associated point data are
        simply shallow copied to the output (which improves performance).
         When enabled, any points that are not used by the output cells
        are not sent to the output, nor is associated point data copied.
        By default this option is disabled. Removing unused points does
        have a significant performance impact.
        """
    )

    def _remove_unused_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRemoveUnusedPoints,
                        self.remove_unused_points_)

    sequential_processing = tvtk_base.false_bool_trait(desc=\
        """
        Force sequential processing (i.e. single thread) of the crinkle
        cut process. By default, sequential processing is off. Note this
        flag only applies if the class has been compiled with
        VTK_SMP_IMPLEMENTATION_TYPE set to something other than
        Sequential. (If set to Sequential, then the filter always runs in
        serial mode.) This flag is typically used for benchmarking
        purposes.
        """
    )

    def _sequential_processing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSequentialProcessing,
                        self.sequential_processing_)

    def _get_implicit_function(self):
        return wrap_vtk(self._vtk_obj.GetImplicitFunction())
    def _set_implicit_function(self, arg):
        old_val = self._get_implicit_function()
        self._wrap_call(self._vtk_obj.SetImplicitFunction,
                        deref_vtk(arg))
        self.trait_property_changed('implicit_function', old_val, arg)
    implicit_function = traits.Property(_get_implicit_function, _set_implicit_function, desc=\
        """
        
        """
    )

    output_points_precision = traits.Int(2, enter_set=True, auto_set=False, desc=\
        """
        Set/get the desired precision for the output points. See the
        documentation for the Algorithm::Precision enum for an
        explanation of the available precision settings.
        """
    )

    def _output_points_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPointsPrecision,
                        self.output_points_precision)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_number_of_threads_used(self):
        return self._vtk_obj.GetNumberOfThreadsUsed()
    number_of_threads_used = traits.Property(_get_number_of_threads_used, desc=\
        """
        Return the number of threads actually used during execution. This
        is valid only after algorithm execution.
        """
    )

    def can_fully_process_data_object(self, *args):
        """
        can_fully_process_data_object(object:DataObject) -> bool
        C++: static bool can_fully_process_data_object(DataObject *object)
        Returns true if the data object passed in is fully supported by
        this filter, i.e., all cell types are linear. For composite
        datasets, this means all dataset leaves have only linear cell
        types that can be processed by this filter.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CanFullyProcessDataObject, *my_args)
        return ret

    _updateable_traits_ = \
    (('copy_cell_data', 'GetCopyCellData'), ('copy_point_data',
    'GetCopyPointData'), ('remove_unused_points',
    'GetRemoveUnusedPoints'), ('sequential_processing',
    'GetSequentialProcessing'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('output_points_precision', 'GetOutputPointsPrecision'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'copy_cell_data', 'copy_point_data', 'debug',
    'global_warning_display', 'release_data_flag', 'remove_unused_points',
    'sequential_processing', 'output_points_precision', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ThreeDLinearGridCrinkleExtractor, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ThreeDLinearGridCrinkleExtractor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['copy_cell_data', 'copy_point_data', 'remove_unused_points',
            'sequential_processing'], [], ['output_points_precision']),
            title='Edit ThreeDLinearGridCrinkleExtractor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ThreeDLinearGridCrinkleExtractor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

