# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class ResourceFileLocator(Object):
    """
    ResourceFileLocator - utility to locate resource files.
    
    Superclass: Object
    
    VTK based application often need to locate resource files, such
    configuration files, Python modules, etc. ResourceFileLocator
    provides methods that can be used to locate such resource files at
    runtime.
    
    Using `Locate`, one can locate files relative to an anchor directory
    such as the executable directory, or the library directory.
    
    `get_library_path_for_symbol_unix` and `get_library_path_for_symbol_win32`
    methods can be used to locate the library that provides a particular
    symbol. For example, this is used by `vtkpython_interpreter` to ensure
    that the `vtk` Python package is located relative the VTK libraries,
    irrespective of the application location.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkResourceFileLocator, obj, update, **traits)
    
    print_debug_information = tvtk_base.false_bool_trait(desc=\
        """
        Enable/disable printing of testing of various path during
        `Locate` to `stdout`.
        
        @deprecated Instead use `set_log_verbosity` to specify the
        verbosity at which this instance should log trace information.
        Default is `Logger::VERBOSITY_TRACE`.
        """
    )

    def _print_debug_information_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPrintDebugInformation,
                        self.print_debug_information_)

    log_verbosity = traits.Int(9, enter_set=True, auto_set=False, desc=\
        """
        The log verbosity to use when logging information about the
        resource searching. Default is `Logger::VERBOSITY_TRACE`.
        """
    )

    def _log_verbosity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLogVerbosity,
                        self.log_verbosity)

    def get_library_path_for_symbol_unix(self, *args):
        """
        get_library_path_for_symbol_unix(symbolname:str) -> str
        C++: static std::string get_library_path_for_symbol_unix(
            const char *symbolname)
        Returns the name of the library providing the symbol. For
        example, if you want to locate where the VTK libraries located
        call `get_library_path_for_symbol_unix("get_vtk_version")` on Unixes and
        `get_library_path_for_symbol_win32(get_vtk_version)` on Windows.
        Alternatively, you can simply use the
        `vtkget_library_path_for_symbol(get_vtk_version)` macro that makes the
        appropriate call as per the current platform.
        """
        ret = self._wrap_call(self._vtk_obj.GetLibraryPathForSymbolUnix, *args)
        return ret

    def get_library_path_for_symbol_win32(self, *args):
        """
        get_library_path_for_symbol_win32(fptr:Pointer) -> str
        C++: static std::string get_library_path_for_symbol_win32(
            const void *fptr)"""
        ret = self._wrap_call(self._vtk_obj.GetLibraryPathForSymbolWin32, *args)
        return ret

    def locate(self, *args):
        """
        locate(self, anchor:str, landmark:str, defaultDir:str=...) -> str
        C++: virtual std::string locate(const std::string &anchor,
            const std::string &landmark,
            const std::string &defaultDir=std::string())
        locate(self, anchor:str, landmark_prefixes:(str, ...),
            landmark:str, defaultDir:str=...) -> str
        C++: virtual std::string locate(const std::string &anchor,
            const std::vector<std::string> &landmark_prefixes,
            const std::string &landmark,
            const std::string &defaultDir=std::string())
        Given a starting anchor directory, look for the landmark file
        relative to the anchor. If found return the anchor. If not found,
        go one directory up and then look the landmark file again.
        """
        ret = self._wrap_call(self._vtk_obj.Locate, *args)
        return ret

    _updateable_traits_ = \
    (('print_debug_information', 'GetPrintDebugInformation'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('log_verbosity', 'GetLogVerbosity'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'print_debug_information',
    'log_verbosity'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ResourceFileLocator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ResourceFileLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['print_debug_information'], [], ['log_verbosity']),
            title='Edit ResourceFileLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ResourceFileLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

