# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.open_gl_texture import OpenGLTexture


class PBRPrefilterTexture(OpenGLTexture):
    """
    PBRPrefilterTexture - precompute prefilter texture used in
    physically based rendering
    
    Superclass: OpenGLTexture
    
    Prefilter texture is a cubemap result of integration of the input
    cubemap contribution in BRDF equation. The result depends on
    roughness coefficient so several levels of mipmap are used to store
    results of different roughness coefficients. It is used in Image Base
    Lighting to compute the specular part.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPBRPrefilterTexture, obj, update, **traits)
    
    convert_to_linear = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _convert_to_linear_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConvertToLinear,
                        self.convert_to_linear_)

    def _get_input_texture(self):
        return wrap_vtk(self._vtk_obj.GetInputTexture())
    def _set_input_texture(self, arg):
        old_val = self._get_input_texture()
        self._wrap_call(self._vtk_obj.SetInputTexture,
                        deref_vtk(arg))
        self.trait_property_changed('input_texture', old_val, arg)
    input_texture = traits.Property(_get_input_texture, _set_input_texture, desc=\
        """
        
        """
    )

    prefilter_levels = traits.Int(5, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _prefilter_levels_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPrefilterLevels,
                        self.prefilter_levels)

    prefilter_max_samples = traits.Int(512, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _prefilter_max_samples_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPrefilterMaxSamples,
                        self.prefilter_max_samples)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        Get the input as a ImageData object.  This method is for
        backwards compatibility.
        """
    )

    def _get_prefilter_size(self):
        return self._vtk_obj.GetPrefilterSize()
    prefilter_size = traits.Property(_get_prefilter_size, desc=\
        """
        Get size of texture (input texture height).
        """
    )

    _updateable_traits_ = \
    (('convert_to_linear', 'GetConvertToLinear'), ('cube_map',
    'GetCubeMap'), ('edge_clamp', 'GetEdgeClamp'), ('interpolate',
    'GetInterpolate'), ('mipmap', 'GetMipmap'), ('premultiplied_alpha',
    'GetPremultipliedAlpha'), ('repeat', 'GetRepeat'),
    ('restrict_power_of2_image_smaller',
    'GetRestrictPowerOf2ImageSmaller'), ('use_srgb_color_space',
    'GetUseSRGBColorSpace'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('color_mode',
    'GetColorMode'), ('quality', 'GetQuality'), ('prefilter_levels',
    'GetPrefilterLevels'), ('prefilter_max_samples',
    'GetPrefilterMaxSamples'), ('is_depth_texture', 'GetIsDepthTexture'),
    ('texture_type', 'GetTextureType'), ('blending_mode',
    'GetBlendingMode'), ('border_color', 'GetBorderColor'),
    ('maximum_anisotropic_filtering', 'GetMaximumAnisotropicFiltering'),
    ('wrap', 'GetWrap'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'convert_to_linear', 'cube_map', 'debug',
    'edge_clamp', 'global_warning_display', 'interpolate', 'mipmap',
    'premultiplied_alpha', 'release_data_flag', 'repeat',
    'restrict_power_of2_image_smaller', 'use_srgb_color_space',
    'color_mode', 'quality', 'blending_mode', 'border_color',
    'is_depth_texture', 'maximum_anisotropic_filtering',
    'prefilter_levels', 'prefilter_max_samples', 'progress_text',
    'texture_type', 'wrap'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PBRPrefilterTexture, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PBRPrefilterTexture properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['convert_to_linear', 'cube_map', 'edge_clamp', 'interpolate',
            'mipmap', 'premultiplied_alpha', 'repeat',
            'restrict_power_of2_image_smaller', 'use_srgb_color_space'],
            ['color_mode', 'quality'], ['blending_mode', 'border_color',
            'is_depth_texture', 'maximum_anisotropic_filtering',
            'prefilter_levels', 'prefilter_max_samples', 'texture_type', 'wrap']),
            title='Edit PBRPrefilterTexture properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PBRPrefilterTexture properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

