# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.partitioned_data_set_algorithm import PartitionedDataSetAlgorithm


class PartitionBalancer(PartitionedDataSetAlgorithm):
    """
    PartitionBalancer - Balances input partitioned data sets so each
    rank has the same number of data sets.
    
    Superclass: PartitionedDataSetAlgorithm
    
    This filter can be applied on `vtkpartitioned_data_set` or
    `vtkpartitioned_data_set_collection`.
    
    * Given an input `vtkpartitioned_data_set`, this filter adds `nullptr`
      instances in the output `vtkpartitioned_data_set` following a pattern
    specified as parameter. The output partitioned data set will have the
    same number of partitions across all ranks.
    * Given an input `vtkpartitioned_data_set_collection`, this filter is
      applied on each partitioned data set separately, and is producing a
    `vtkpartitione_data_set_collection`.
    
    If some input partitions are `nullptr`, the output will see this
    partition squeezed out. The filter will treat the input partitioned
    data set as if this `nullptr` partition was non existent.
    
    The way the output is laid out is driven by the parameter `Mode`;
    * `Mode::Expand` generates, per partitioned data set, as many
      partitions as there are partitions in the input across all ranks.
      Given a valid partition (not `nullptr`) in the output partitioned
      data set at index n in rank i, all partitioned data set of all
      ranks but i have a `nullptr` instance as index n. Output partitions
    are sorted by rank number. i.e., for i < j, partition at rank i are
      indexed before partitions of rank j. Here is an example. of what
      would be generated for a given input. PDC holds for Partitioned
      Dataset Collection, and PD holds for Partitioned Dataset.
     Input:
     rank 0: PDC [ PD (DS0, DS1,     DS2) ] [PD (nullptr, DS100) ]
     rank 1: PDC [ PD (DS3, nullptr, DS4) ] [PD ()               ]
    
     Output:
     rank 0: PDC [ PD (DS0,     DS1,     DS2,     nullptr, nullptr) ] [PD (DS100)   ]
     rank 1: PDC [ PD (nullptr, nullptr, nullptr, DS3,     DS4)     ] [PD (nullptr) ]
     
    * `Mode::Squash` generates, per input partitioned data set, the
      minimum number of partitions possible, appending `nullptr` in ranks
    lacking partitions. Using the same example as above:
     Input:
     rank 0: PDC [ PD (DS0, DS1,     DS2) ] [PD (nullptr, DS100) ]
     rank 1: PDC [ PD (DS3, nullptr, DS4) ] [PD ()               ]
    
     Output:
     rank 0: PDC [ PD (DS0, DS1, DS2)     ] [PD (DS100)   ]
     rank 1: PDC [ PD (DS3, DS4, nullptr) ] [PD (nullptr) ]
     
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPartitionBalancer, obj, update, **traits)
    
    mode = tvtk_base.RevPrefixMap({'squash': 1, 'expand': 0}, default_value='squash', desc=\
        """
        Set / Get current layout of the output. Default value is
        `vtkpartition_balancer::Squash`.
        """
    )

    def _mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMode,
                        self.mode_)

    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        """
        
        """
    )

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('mode',
    'GetMode'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'mode', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PartitionBalancer, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PartitionBalancer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], ['mode'], []),
            title='Edit PartitionBalancer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PartitionBalancer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

