# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.unstructured_grid_algorithm import UnstructuredGridAlgorithm


class NetCDFCAMReader(UnstructuredGridAlgorithm):
    """
    NetCDFCAMReader - Read unstructured net_cdf CAM files.
    
    Superclass: UnstructuredGridAlgorithm
    
    Reads in a net_cdf CAM (Community Atmospheric Model) file and produces
    and unstructured grid.  The grid is actually unstructured in the X
    and Y directions and rectilinear in the Z direction. If we read one
    layer we produce quad cells otherwise we produce hex cells.  The
    reader requires 2 net_cdf files: the main file has all attributes, the
    connectivity file has point positions and cell connectivity
    information.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkNetCDFCAMReader, obj, update, **traits)
    
    single_interface_layer = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _single_interface_layer_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSingleInterfaceLayer,
                        self.single_interface_layer_)

    single_midpoint_layer = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _single_midpoint_layer_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSingleMidpointLayer,
                        self.single_midpoint_layer_)

    connectivity_file_name = tvtk_base.vtk_file_name("", desc=\
        """
        
        """
    )

    def _connectivity_file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConnectivityFileName,
                        self.connectivity_file_name)

    file_name = tvtk_base.vtk_file_name("", desc=\
        """
        
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    interface_layer_index = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _interface_layer_index_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterfaceLayerIndex,
                        self.interface_layer_index)

    midpoint_layer_index = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _midpoint_layer_index_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMidpointLayerIndex,
                        self.midpoint_layer_index)

    def get_point_array_status(self, *args):
        """
        get_point_array_status(self, name:str) -> int
        C++: int get_point_array_status(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.GetPointArrayStatus, *args)
        return ret

    def set_point_array_status(self, *args):
        """
        set_point_array_status(self, name:str, status:int) -> None
        C++: void set_point_array_status(const char *name, int status)"""
        ret = self._wrap_call(self._vtk_obj.SetPointArrayStatus, *args)
        return ret

    vertical_dimension = traits.Trait(1, traits.Range(0, 2, enter_set=True, auto_set=False), desc=\
        """
        
        """
    )

    def _vertical_dimension_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVerticalDimension,
                        self.vertical_dimension)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)
        get_input(self) -> DataObject
        C++: DataObject *get_input()"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_interface_layers_range(self):
        return self._vtk_obj.GetInterfaceLayersRange()
    interface_layers_range = traits.Property(_get_interface_layers_range, desc=\
        """
        
        """
    )

    def _get_midpoint_layers_range(self):
        return self._vtk_obj.GetMidpointLayersRange()
    midpoint_layers_range = traits.Property(_get_midpoint_layers_range, desc=\
        """
        
        """
    )

    def _get_number_of_point_arrays(self):
        return self._vtk_obj.GetNumberOfPointArrays()
    number_of_point_arrays = traits.Property(_get_number_of_point_arrays, desc=\
        """
        The following methods allow selective reading of variables. By
        default, ALL data variables on the nodes are read.
        """
    )

    def get_point_array_name(self, *args):
        """
        get_point_array_name(self, index:int) -> str
        C++: const char *get_point_array_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetPointArrayName, *args)
        return ret

    def can_read_file(self, *args):
        """
        can_read_file(fileName:str) -> int
        C++: static int can_read_file(const char *fileName)
        Returns 1 if this file can be read and 0 if the file cannot be
        read. Because net_cdf CAM files come in pairs and we only check
        one of the files, the result is not definitive.  Invalid files
        may still return 1 although a valid file will never return 0.
        """
        ret = self._wrap_call(self._vtk_obj.CanReadFile, *args)
        return ret

    def disable_all_point_arrays(self):
        """
        disable_all_point_arrays(self) -> None
        C++: void disable_all_point_arrays()"""
        ret = self._vtk_obj.DisableAllPointArrays()
        return ret
        

    def enable_all_point_arrays(self):
        """
        enable_all_point_arrays(self) -> None
        C++: void enable_all_point_arrays()"""
        ret = self._vtk_obj.EnableAllPointArrays()
        return ret
        

    _updateable_traits_ = \
    (('single_interface_layer', 'GetSingleInterfaceLayer'),
    ('single_midpoint_layer', 'GetSingleMidpointLayer'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('connectivity_file_name',
    'GetConnectivityFileName'), ('file_name', 'GetFileName'),
    ('interface_layer_index', 'GetInterfaceLayerIndex'),
    ('midpoint_layer_index', 'GetMidpointLayerIndex'),
    ('vertical_dimension', 'GetVerticalDimension'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'single_interface_layer',
    'single_midpoint_layer', 'connectivity_file_name', 'file_name',
    'interface_layer_index', 'midpoint_layer_index', 'progress_text',
    'vertical_dimension'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(NetCDFCAMReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit NetCDFCAMReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['single_interface_layer', 'single_midpoint_layer'], [],
            ['connectivity_file_name', 'file_name', 'interface_layer_index',
            'midpoint_layer_index', 'vertical_dimension']),
            title='Edit NetCDFCAMReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit NetCDFCAMReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

