# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class IncrementalOctreeNode(Object):
    """
    IncrementalOctreeNode - Octree node constituting incremental
     octree (in support of both point location and point insertion)
    
    Superclass: Object
    
    Octree nodes serve as spatial sub-division primitives to build the
    search
     structure of an incremental octree in a recursive top-down manner.
    The
     hierarchy takes the form of a tree-like representation by which a
    parent
     node contains eight mutually non-overlapping child nodes. Each child
    is
     assigned with an axis-aligned rectangular volume (Spatial Bounding
    Box)
     and the eight children together cover exactly the same region as
    governed
     by their parent. The eight child nodes / octants are ordered as
    
    
     { (xBbox_min, xBbox_mid] & (yBbox_min, yBbox_mid] & (zBbox_min, zBbox_mid]
    },
     { (xBbox_mid, xBbox_max] & (yBbox_min, yBbox_mid] & (zBbox_min, zBbox_mid]
    },
     { (xBbox_min, xBbox_mid] & (yBbox_mid, yBbox_max] & (zBbox_min, zBbox_mid]
    },
     { (xBbox_mid, xBbox_max] & (yBbox_mid, yBbox_max] & (zBbox_min, zBbox_mid]
    },
     { (xBbox_min, xBbox_mid] & (yBbox_min, yBbox_mid] & (zBbox_mid, zBbox_max]
    },
     { (xBbox_mid, xBbox_max] & (yBbox_min, yBbox_mid] & (zBbox_mid, zBbox_max]
    },
     { (xBbox_min, xBbox_mid] & (yBbox_mid, yBbox_max] & (zBbox_mid, zBbox_max]
    },
     { (xBbox_mid, xBbox_max] & (yBbox_mid, yBbox_max] & (zBbox_mid, zBbox_max]
    },
    
    
     where { xrange & yRange & zRange } defines the region of each 3D
    octant.
     In addition, the points falling within and registered, by means of
    point
     indices, in the parent node are distributed to the child nodes for
    delegated
     maintenance. In fact, only leaf nodes, i.e., those without any
    descendants,
     actually store point indices while each node, regardless of a leaf
    or non-
     leaf node, keeps a dynamically updated Data Bounding Box of the
    inhabitant
     points, if any. Given a maximum number of points per leaf node, an
    octree
     is initialized with an empty leaf node that is then recursively
    sub-divided,
     but only on demand as points are incrementally inserted, to
    construct a
     populated tree.
    
    
     Please note that this octree node class is able to handle a large
    number
     of EXACTLY duplicate points that is greater than the specified
    maximum
     number of points per leaf node. In other words, as an exception, a
    leaf
     node may maintain an arbitrary number of exactly duplicate points to
    deal
     with possible extreme cases.
    
    @sa
     IncrementalOctreePointLocator
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkIncrementalOctreeNode, obj, update, **traits)
    
    def get_bounds(self, *args):
        """
        get_bounds(self, bounds:[float, float, float, float, float, float])
             -> None
        C++: void get_bounds(double bounds[6])
        Get the spatial bounding box of the node. The values are returned
        via an array in order of: x_min, x_max, y_min, y_max, z_min,
        z_max.
        """
        ret = self._wrap_call(self._vtk_obj.GetBounds, *args)
        return ret

    def set_bounds(self, *args):
        """
        set_bounds(self, x1:float, x2:float, y1:float, y2:float, z1:float,
            z2:float) -> None
        C++: void set_bounds(double x1, double x2, double y1, double y2,
            double z1, double z2)
        Set the spatial bounding box of the node. This function sets a
        default data bounding box.
        """
        ret = self._wrap_call(self._vtk_obj.SetBounds, *args)
        return ret

    def get_child(self, *args):
        """
        get_child(self, i:int) -> IncrementalOctreeNode
        C++: IncrementalOctreeNode *get_child(int i)
        Get quick access to a child of this node. Note that this node is
        assumed to be a non-leaf one and no checking is performed on the
        node type.
        """
        ret = self._wrap_call(self._vtk_obj.GetChild, *args)
        return wrap_vtk(ret)

    def get_child_index(self, *args):
        """
        get_child_index(self, point:(float, float, float)) -> int
        C++: int get_child_index(const double point[3])
        Determine which specific child / octant contains a given point.
        Note that the point is assumed to be inside this node and no
        checking is performed on the inside issue.
        """
        ret = self._wrap_call(self._vtk_obj.GetChildIndex, *args)
        return ret

    def get_distance2_to_boundary(self, *args):
        """
        get_distance2_to_boundary(self, point:(float, float, float),
            rootNode:IncrementalOctreeNode, checkData:int) -> float
        C++: double get_distance2_to_boundary(const double point[3],
            IncrementalOctreeNode *rootNode, int checkData)
        get_distance2_to_boundary(self, point:(float, float, float),
            closest:[float, float, float],
            rootNode:IncrementalOctreeNode, checkData:int) -> float
        C++: double get_distance2_to_boundary(const double point[3],
            double closest[3], IncrementalOctreeNode *rootNode,
            int checkData)
        Compute the minimum squared distance from a point to this node,
        with all six boundaries considered. The data bounding box is
        checked if checkData is non-zero.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetDistance2ToBoundary, *my_args)
        return ret

    def get_distance2_to_inner_boundary(self, *args):
        """
        get_distance2_to_inner_boundary(self, point:(float, float, float),
            rootNode:IncrementalOctreeNode) -> float
        C++: double get_distance2_to_inner_boundary(const double point[3],
            IncrementalOctreeNode *rootNode)
        Given a point inside this node, get the minimum squared distance
        to all inner boundaries. An inner boundary is a node's face that
        is shared by another non-root node.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetDistance2ToInnerBoundary, *my_args)
        return ret

    def _get_id(self):
        return self._vtk_obj.GetID()
    id = traits.Property(_get_id, desc=\
        """
        Returns the ID of this node which is the index of the node in the
        octree. The index of the node enables users of this class to
        associate additional information with each node.
        """
    )

    def _get_max_bounds(self):
        return self._vtk_obj.GetMaxBounds()
    max_bounds = traits.Property(_get_max_bounds, desc=\
        """
        Get access to max_bounds. Do not free this pointer.
        """
    )

    def _get_max_data_bounds(self):
        return self._vtk_obj.GetMaxDataBounds()
    max_data_bounds = traits.Property(_get_max_data_bounds, desc=\
        """
        Get access to max_data_bounds. Note that max_data_bounds is not valid
        until point insertion.
        """
    )

    def _get_min_bounds(self):
        return self._vtk_obj.GetMinBounds()
    min_bounds = traits.Property(_get_min_bounds, desc=\
        """
        Get access to min_bounds. Do not free this pointer.
        """
    )

    def _get_min_data_bounds(self):
        return self._vtk_obj.GetMinDataBounds()
    min_data_bounds = traits.Property(_get_min_data_bounds, desc=\
        """
        Get access to min_data_bounds. Note that min_data_bounds is not valid
        until point insertion.
        """
    )

    def _get_number_of_levels(self):
        return self._vtk_obj.GetNumberOfLevels()
    number_of_levels = traits.Property(_get_number_of_levels, desc=\
        """
        Computes and returns the maximum level of the tree. If a tree has
        one node it returns 1 else it returns the maximum level of its
        children plus 1.
        """
    )

    def _get_number_of_points(self):
        return self._vtk_obj.GetNumberOfPoints()
    number_of_points = traits.Property(_get_number_of_points, desc=\
        """
        Get the number of points inside or under this node.
        """
    )

    def _get_point_id_set(self):
        return wrap_vtk(self._vtk_obj.GetPointIdSet())
    point_id_set = traits.Property(_get_point_id_set, desc=\
        """
        Get the list of point indices, nullptr for a non-leaf node.
        """
    )

    def _get_point_ids(self):
        return wrap_vtk(self._vtk_obj.GetPointIds())
    point_ids = traits.Property(_get_point_ids, desc=\
        """
        
        """
    )

    def contains_point(self, *args):
        """
        contains_point(self, pnt:(float, float, float)) -> int
        C++: TypeBool contains_point(const double pnt[3])
        A point is in a node if and only if min_bounds[i] < p[i] <=
        max_bounds[i], which allows a node to be divided into eight
        non-overlapping children.
        """
        ret = self._wrap_call(self._vtk_obj.ContainsPoint, *args)
        return ret

    def contains_point_by_data(self, *args):
        """
        contains_point_by_data(self, pnt:(float, float, float)) -> int
        C++: TypeBool contains_point_by_data(const double pnt[3])
        A point is in a node, in terms of data, if and only if
        min_data_bounds[i] <= p[i] <= max_data_bounds[i].
        """
        ret = self._wrap_call(self._vtk_obj.ContainsPointByData, *args)
        return ret

    def delete_child_nodes(self):
        """
        delete_child_nodes(self) -> None
        C++: void delete_child_nodes()
        Delete the eight child nodes.
        """
        ret = self._vtk_obj.DeleteChildNodes()
        return ret
        

    def export_all_point_ids_by_direct_set(self, *args):
        """
        export_all_point_ids_by_direct_set(self, pntIdx:[int, ...],
            idList:IdList) -> None
        C++: void export_all_point_ids_by_direct_set(IdType *pntIdx,
            IdList *idList)
        Export all the indices of the points (contained in or under this
        node) by directly setting them in an allocated IdList object.
        pntIdx indicates the starting location (in terms of IdList)
        from which new point indices are added to IdList by
        IdList::SetId().
        """
        my_args = deref_array(args, [(['int', Ellipsis], 'vtkIdList')])
        ret = self._wrap_call(self._vtk_obj.ExportAllPointIdsByDirectSet, *my_args)
        return ret

    def export_all_point_ids_by_insertion(self, *args):
        """
        export_all_point_ids_by_insertion(self, idList:IdList) -> None
        C++: void export_all_point_ids_by_insertion(IdList *idList)
        Export all the indices of the points (contained in or under this
        node) by inserting them to an allocated IdList via
        IdList::InsertNextId().
        """
        my_args = deref_array(args, [['vtkIdList']])
        ret = self._wrap_call(self._vtk_obj.ExportAllPointIdsByInsertion, *my_args)
        return ret

    def insert_point(self, *args):
        """
        insert_point(self, points:Points, newPnt:(float, float, float),
            maxPts:int, pntId:[int, ...], ptMode:int) -> int
        C++: int insert_point(Points *points, const double newPnt[3],
            int maxPts, IdType *pntId, int ptMode)
        insert_point(self, points:Points, newPnt:(float, float, float),
            maxPts:int, pntId:[int, ...], ptMode:int, numberOfNodes:int)
            -> int
        C++: int insert_point(Points *points, const double newPnt[3],
            int maxPts, IdType *pntId, int ptMode, int &numberOfNodes)
        This function is called after a successful point-insertion check
        and only applies to a leaf node. Prior to a call to this
        function, the octree should have been retrieved top-down to find
        the specific leaf node in which this new point (newPt) will be
        inserted. The actual index of the new point (to be inserted to
        points) is stored in pntId. Argument ptMode specifies whether the
        point is not inserted at all but instead only the point index is
        provided upon 0, the point is inserted via Points::
        insert_point() upon 1, or it is inserted via
        Points::InsertNextPoint() upon 2. For case 0, pntId needs to
        be specified. For cases 1 and 2, the actual point index is
        returned via pntId. Note that this function always returns 1 to
        indicate the success of point insertion. numberof_nodes is the
        number of nodes present in the tree at this time. it is used to
        assign an ID to each node which can be used to associate
        application specifc information with each node. It is updated if
        new nodes are added to the tree.
        """
        my_args = deref_array(args, [('vtkPoints', ('float', 'float', 'float'), 'int', ['int', Ellipsis], 'int'), ('vtkPoints', ('float', 'float', 'float'), 'int', ['int', Ellipsis], 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.InsertPoint, *my_args)
        return ret

    def is_leaf(self):
        """
        is_leaf(self) -> int
        C++: int is_leaf()
        Determine whether or not this node is a leaf.
        """
        ret = self._vtk_obj.IsLeaf()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(IncrementalOctreeNode, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit IncrementalOctreeNode properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit IncrementalOctreeNode properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit IncrementalOctreeNode properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

