# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.field_data import FieldData


class DataSetAttributes(FieldData):
    """
    DataSetAttributes - represent and manipulate attribute data in a
    dataset
    
    Superclass: FieldData
    
    DataSetAttributes is a class that is used to represent and
    manipulate attribute data (e.g., scalars, vectors, normals, texture
    coordinates, tensors, global ids, pedigree ids, and field data).
    
    This adds to FieldData the ability to pick one of the arrays from
    the field as the currently active array for each attribute type. In
    other words, you pick one array to be called "THE" Scalars, and then
    filters down the pipeline will treat that array specially. For
    example ContourFilter will contour "THE" Scalar array unless a
    different array is asked for.
    
    Additionally DataSetAttributes provides methods that filters call
    to pass data through, copy data into, and interpolate from Fields.
    pass_data passes entire arrays from the source to the destination.
    Copy passes through some subset of the tuples from the source to the
    destination. Interpolate interpolates from the chosen tuple(s) in the
    source data, using the provided weights, to produce new tuples in the
    destination. Each attribute type has pass, copy and interpolate
    "copy" flags that can be set in the destination to choose which
    attribute arrays will be transferred from the source to the
    destination.
    
    Finally this class provides a mechanism to determine which attributes
    a group of sources have in common, and to copy tuples from a source
    into the destination, for only those attributes that are held by all.
    
    @warning
    DataSetAttributes is not in general thread safe due to the use of
    its FieldData::BasicIterator required_arrays data member. The class
    ArrayListTemplate augments DataSetAttributes for thread safety.
    
    @sa ArrayListTemplate
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDataSetAttributes, obj, update, **traits)
    
    copy_higher_order_degrees = tvtk_base.true_bool_trait(desc=\
        """
        @copydoc DataSetAttributes::SetCopyAttribute()
        """
    )

    def _copy_higher_order_degrees_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCopyHigherOrderDegrees,
                        self.copy_higher_order_degrees_)

    copy_rational_weights = tvtk_base.true_bool_trait(desc=\
        """
        @copydoc DataSetAttributes::SetCopyAttribute()
        """
    )

    def _copy_rational_weights_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCopyRationalWeights,
                        self.copy_rational_weights_)

    copy_tangents = tvtk_base.true_bool_trait(desc=\
        """
        @copydoc DataSetAttributes::SetCopyAttribute()
        """
    )

    def _copy_tangents_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCopyTangents,
                        self.copy_tangents_)

    def get_attribute(self, *args):
        """
        get_attribute(self, attributeType:int) -> DataArray
        C++: DataArray *get_attribute(int attributeType)
        Return an attribute given the attribute type (see
        DataSetAttributes::AttributeTypes). Some attributes (such as
        PEDIGREEIDS) may not be DataArray subclass, so in that case
        use get_abstract_attribute().
        """
        ret = self._wrap_call(self._vtk_obj.GetAttribute, *args)
        return wrap_vtk(ret)

    def set_attribute(self, *args):
        """
        set_attribute(self, aa:AbstractArray, attributeType:int) -> int
        C++: int set_attribute(AbstractArray *aa, int attributeType)
        Set an array to use as the given attribute type (i.e.,
        DataSetAttributes::SCALAR, DataSetAttributes::VECTOR,
        DataSetAttributes::TENSOR, etc.). If this attribute was
        previously set to another array, that array is removed from the
        DataSetAttributes object and the array aa is used as the
        attribute.
        
        * Returns the index of aa within the DataSetAttributes object
        * (i.e., the index to pass to the method get_array(int) to obtain
        * aa) if the attribute was set to aa successfully. If aa was
        * already set as the given attributeType, returns the index of
        * aa.
        
        * Returns -1 in the following cases:
        
        * - aa is nullptr (used to unset an attribute; not an error
          indicator)
        * - aa is not a subclass of DataArray, unless the
          attributeType
        * is DataSetAttributes::PEDIGREEIDS (error indicator)
        * - aa has a number of components incompatible with the attribute
        type
        * (error indicator)
        """
        my_args = deref_array(args, [('vtkAbstractArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.SetAttribute, *my_args)
        return ret

    def get_copy_attribute(self, *args):
        """
        get_copy_attribute(self, index:int, ctype:int) -> int
        C++: int get_copy_attribute(int index, int ctype)
        Get the attribute copy flag for copy operation ctype of
        attributeindex.
        """
        ret = self._wrap_call(self._vtk_obj.GetCopyAttribute, *args)
        return ret

    def set_copy_attribute(self, *args):
        """
        set_copy_attribute(self, index:int, value:int, ctype:int=...)
            -> None
        C++: void set_copy_attribute(int index, int value,
            int ctype=ALLCOPY)
        Turn on/off the copying of attribute data. ctype is one of the
        attribute_copy_operations, and controls copy, interpolate and
        passdata behavior. For set, ctype=ALLCOPY means set all three
        flags to the same value. For get, ctype=ALLCOPY returns true only
        if all three flags are true.
        
        * During copying, interpolation and passdata, the following rules
        are
        * followed for each array:
        * 1. If the copy/interpolate/pass flag for an attribute is set
          (on or off),
        * it is applied. This overrides rules 2 and 3.
        * 2. If the copy flag for an array is set (on or off), it is
          applied
        * This overrides rule 3.
        * 3. If copy_all_on is set, copy the array.
        * If copy_all_off is set, do not copy the array
        
        * For interpolation, the flag values can be as follows:
        * 0: Do not interpolate.
        * 1: Weighted interpolation.
        * 2: Nearest neighbor interpolation.
        """
        ret = self._wrap_call(self._vtk_obj.SetCopyAttribute, *args)
        return ret

    copy_global_ids = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        @copydoc DataSetAttributes::SetCopyAttribute()
        """
    )

    def _copy_global_ids_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCopyGlobalIds,
                        self.copy_global_ids)

    copy_normals = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        @copydoc DataSetAttributes::SetCopyAttribute()
        """
    )

    def _copy_normals_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCopyNormals,
                        self.copy_normals)

    copy_pedigree_ids = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        @copydoc DataSetAttributes::SetCopyAttribute()
        """
    )

    def _copy_pedigree_ids_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCopyPedigreeIds,
                        self.copy_pedigree_ids)

    copy_scalars = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        @copydoc DataSetAttributes::SetCopyAttribute()
        """
    )

    def _copy_scalars_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCopyScalars,
                        self.copy_scalars)

    copy_t_coords = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        @copydoc DataSetAttributes::SetCopyAttribute()
        """
    )

    def _copy_t_coords_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCopyTCoords,
                        self.copy_t_coords)

    copy_tensors = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        @copydoc DataSetAttributes::SetCopyAttribute()
        """
    )

    def _copy_tensors_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCopyTensors,
                        self.copy_tensors)

    copy_vectors = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        @copydoc DataSetAttributes::SetCopyAttribute()
        """
    )

    def _copy_vectors_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCopyVectors,
                        self.copy_vectors)

    def _get_global_ids(self):
        return wrap_vtk(self._vtk_obj.GetGlobalIds())
    def _set_global_ids(self, arg):
        old_val = self._get_global_ids()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetGlobalIds,
                        my_arg[0])
        self.trait_property_changed('global_ids', old_val, arg)
    global_ids = traits.Property(_get_global_ids, _set_global_ids, desc=\
        """
        
        """
    )

    def _get_higher_order_degrees(self):
        return wrap_vtk(self._vtk_obj.GetHigherOrderDegrees())
    def _set_higher_order_degrees(self, arg):
        old_val = self._get_higher_order_degrees()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetHigherOrderDegrees,
                        my_arg[0])
        self.trait_property_changed('higher_order_degrees', old_val, arg)
    higher_order_degrees = traits.Property(_get_higher_order_degrees, _set_higher_order_degrees, desc=\
        """
        
        """
    )

    def _get_normals(self):
        return wrap_vtk(self._vtk_obj.GetNormals())
    def _set_normals(self, arg):
        old_val = self._get_normals()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetNormals,
                        my_arg[0])
        self.trait_property_changed('normals', old_val, arg)
    normals = traits.Property(_get_normals, _set_normals, desc=\
        """
        
        """
    )

    def _get_pedigree_ids(self):
        return wrap_vtk(self._vtk_obj.GetPedigreeIds())
    def _set_pedigree_ids(self, arg):
        old_val = self._get_pedigree_ids()
        my_arg = deref_array([arg], [['vtkAbstractArray']])
        self._wrap_call(self._vtk_obj.SetPedigreeIds,
                        my_arg[0])
        self.trait_property_changed('pedigree_ids', old_val, arg)
    pedigree_ids = traits.Property(_get_pedigree_ids, _set_pedigree_ids, desc=\
        """
        
        """
    )

    def _get_rational_weights(self):
        return wrap_vtk(self._vtk_obj.GetRationalWeights())
    def _set_rational_weights(self, arg):
        old_val = self._get_rational_weights()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetRationalWeights,
                        my_arg[0])
        self.trait_property_changed('rational_weights', old_val, arg)
    rational_weights = traits.Property(_get_rational_weights, _set_rational_weights, desc=\
        """
        
        """
    )

    def _get_scalars(self):
        return wrap_vtk(self._vtk_obj.GetScalars())
    def _set_scalars(self, arg):
        old_val = self._get_scalars()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetScalars,
                        my_arg[0])
        self.trait_property_changed('scalars', old_val, arg)
    scalars = traits.Property(_get_scalars, _set_scalars, desc=\
        """
        
        """
    )

    def _get_t_coords(self):
        return wrap_vtk(self._vtk_obj.GetTCoords())
    def _set_t_coords(self, arg):
        old_val = self._get_t_coords()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetTCoords,
                        my_arg[0])
        self.trait_property_changed('t_coords', old_val, arg)
    t_coords = traits.Property(_get_t_coords, _set_t_coords, desc=\
        """
        
        """
    )

    def _get_tangents(self):
        return wrap_vtk(self._vtk_obj.GetTangents())
    def _set_tangents(self, arg):
        old_val = self._get_tangents()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetTangents,
                        my_arg[0])
        self.trait_property_changed('tangents', old_val, arg)
    tangents = traits.Property(_get_tangents, _set_tangents, desc=\
        """
        
        """
    )

    def _get_tensors(self):
        return wrap_vtk(self._vtk_obj.GetTensors())
    def _set_tensors(self, arg):
        old_val = self._get_tensors()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetTensors,
                        my_arg[0])
        self.trait_property_changed('tensors', old_val, arg)
    tensors = traits.Property(_get_tensors, _set_tensors, desc=\
        """
        
        """
    )

    def _get_vectors(self):
        return wrap_vtk(self._vtk_obj.GetVectors())
    def _set_vectors(self, arg):
        old_val = self._get_vectors()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetVectors,
                        my_arg[0])
        self.trait_property_changed('vectors', old_val, arg)
    vectors = traits.Property(_get_vectors, _set_vectors, desc=\
        """
        
        """
    )

    def get_abstract_attribute(self, *args):
        """
        get_abstract_attribute(self, attributeType:int) -> AbstractArray
        C++: AbstractArray *get_abstract_attribute(int attributeType)
        Return an attribute given the attribute type (see
        DataSetAttributes::AttributeTypes). This is the same as
        get_attribute(), except that the returned array is a
        AbstractArray instead of DataArray. Some attributes (such
        as PEDIGREEIDS) may not be DataArray subclass.
        """
        ret = self._wrap_call(self._vtk_obj.GetAbstractAttribute, *args)
        return wrap_vtk(ret)

    def get_attribute_indices(self, *args):
        """
        get_attribute_indices(self, indexArray:[int, ...]) -> None
        C++: void get_attribute_indices(int *indexArray)
        Get the field data array indices corresponding to scalars,
        vectors, tensors, etc.
        """
        ret = self._wrap_call(self._vtk_obj.GetAttributeIndices, *args)
        return ret

    def get_attribute_type_as_string(self, *args):
        """
        get_attribute_type_as_string(attributeType:int) -> str
        C++: static const char *get_attribute_type_as_string(
            int attributeType)
        Given an integer attribute type, this static method returns a
        string type for the attribute (i.e. type = 0: returns "Scalars").
        """
        ret = self._wrap_call(self._vtk_obj.GetAttributeTypeAsString, *args)
        return ret

    def get_long_attribute_type_as_string(self, *args):
        """
        get_long_attribute_type_as_string(attributeType:int) -> str
        C++: static const char *get_long_attribute_type_as_string(
            int attributeType)"""
        ret = self._wrap_call(self._vtk_obj.GetLongAttributeTypeAsString, *args)
        return ret

    def copy_allocate(self, *args):
        """
        copy_allocate(self, pd:DataSetAttributes, sze:int=0,
            ext:int=1000) -> None
        C++: void copy_allocate(DataSetAttributes *pd, IdType sze=0,
            IdType ext=1000)
        copy_allocate(self, pd:DataSetAttributes, sze:int, ext:int,
            shallowCopyArrays:int) -> None
        C++: void copy_allocate(DataSetAttributes *pd, IdType sze,
            IdType ext, int shallowCopyArrays)
        copy_allocate(self, list:DataSetAttributesFieldList, sze:int=0,
            ext:int=1000) -> None
        C++: void copy_allocate(DataSetAttributes::FieldList &list,
            IdType sze=0, IdType ext=1000)
        Allocates point data for point-by-point (or cell-by-cell) copy
        operation. If sze=0, then use the input data_set_attributes to
        create (i.e., find initial size of) new objects; otherwise use
        the sze variable. Note that pd HAS to be the DataSetAttributes
        object which will later be used with copy_data. If this is not the
        case, consider using the alternative forms of copy_allocate and
        copy_data. ext is no longer used. If shallowcopy_arrays is true,
        input arrays are copied to the output instead of new ones being
        allocated.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CopyAllocate, *my_args)
        return ret

    def copy_data(self, *args):
        """
        copy_data(self, fromPd:DataSetAttributes, fromId:int, toId:int)
            -> None
        C++: void copy_data(DataSetAttributes *fromPd, IdType fromId,
             IdType toId)
        copy_data(self, fromPd:DataSetAttributes, fromIds:IdList,
            toIds:IdList) -> None
        C++: void copy_data(DataSetAttributes *fromPd,
            IdList *fromIds, IdList *toIds)
        copy_data(self, fromPd:DataSetAttributes, dstStart:int, n:int,
            srcStart:int) -> None
        C++: void copy_data(DataSetAttributes *fromPd,
            IdType dstStart, IdType n, IdType srcStart)
        copy_data(self, list:DataSetAttributesFieldList,
            dsa:DataSetAttributes, idx:int, fromId:int, toId:int)
            -> None
        C++: void copy_data(DataSetAttributes::FieldList &list,
            DataSetAttributes *dsa, int idx, IdType fromId,
            IdType toId)
        copy_data(self, list:DataSetAttributesFieldList,
            dsa:DataSetAttributes, idx:int, dstStart:int, n:int,
            srcStart:int) -> None
        C++: void copy_data(DataSetAttributes::FieldList &list,
            DataSetAttributes *dsa, int idx, IdType dstStart,
            IdType n, IdType srcStart)
        Copy the attribute data from one id to another. Make sure
        copy_allocate() has been invoked before using this method. When
        copying a field, the following copying rules are followed: 1)
        Check if a field is an attribute, if yes and if there is a
        COPYTUPLE copy flag for that attribute (on or off), obey the flag
        for that attribute, ignore (2) and (3), 2) if there is a copy
        field for that field (on or off), obey the flag, ignore (3) 3)
        obey copy_all_on/Off
        """
        my_args = deref_array(args, [('vtkDataSetAttributes', 'int', 'int'), ('vtkDataSetAttributes', 'vtkIdList', 'vtkIdList'), ('vtkDataSetAttributes', 'int', 'int', 'int'), ('vtkDataSetAttributesFieldList', 'vtkDataSetAttributes', 'int', 'int', 'int'), ('vtkDataSetAttributesFieldList', 'vtkDataSetAttributes', 'int', 'int', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.CopyData, *my_args)
        return ret

    def copy_global_ids_off(self):
        """
        copy_global_ids_off(self) -> None
        C++: virtual void copy_global_ids_off()"""
        ret = self._vtk_obj.CopyGlobalIdsOff()
        return ret
        

    def copy_global_ids_on(self):
        """
        copy_global_ids_on(self) -> None
        C++: virtual void copy_global_ids_on()"""
        ret = self._vtk_obj.CopyGlobalIdsOn()
        return ret
        

    def copy_normals_off(self):
        """
        copy_normals_off(self) -> None
        C++: virtual void copy_normals_off()"""
        ret = self._vtk_obj.CopyNormalsOff()
        return ret
        

    def copy_normals_on(self):
        """
        copy_normals_on(self) -> None
        C++: virtual void copy_normals_on()"""
        ret = self._vtk_obj.CopyNormalsOn()
        return ret
        

    def copy_pedigree_ids_off(self):
        """
        copy_pedigree_ids_off(self) -> None
        C++: virtual void copy_pedigree_ids_off()"""
        ret = self._vtk_obj.CopyPedigreeIdsOff()
        return ret
        

    def copy_pedigree_ids_on(self):
        """
        copy_pedigree_ids_on(self) -> None
        C++: virtual void copy_pedigree_ids_on()"""
        ret = self._vtk_obj.CopyPedigreeIdsOn()
        return ret
        

    def copy_scalars_off(self):
        """
        copy_scalars_off(self) -> None
        C++: virtual void copy_scalars_off()"""
        ret = self._vtk_obj.CopyScalarsOff()
        return ret
        

    def copy_scalars_on(self):
        """
        copy_scalars_on(self) -> None
        C++: virtual void copy_scalars_on()"""
        ret = self._vtk_obj.CopyScalarsOn()
        return ret
        

    def copy_structured_data(self, *args):
        """
        copy_structured_data(self, inDsa:DataSetAttributes, inExt:(int,
            ...), outExt:(int, ...), setSize:bool=True) -> None
        C++: void copy_structured_data(DataSetAttributes *inDsa,
            const int *inExt, const int *outExt, bool setSize=true)
        This method is used to copy data arrays in images. You should
        call copy_allocate or setup_for_copy before calling this method. If
        setSize is true, this method will set the size of the output
        arrays according to the output extent. This is required when
        copy_allocate() was used to setup output arrays.
        """
        ret = self._wrap_call(self._vtk_obj.CopyStructuredData, *args)
        return ret

    def copy_t_coords_off(self):
        """
        copy_t_coords_off(self) -> None
        C++: virtual void copy_t_coords_off()"""
        ret = self._vtk_obj.CopyTCoordsOff()
        return ret
        

    def copy_t_coords_on(self):
        """
        copy_t_coords_on(self) -> None
        C++: virtual void copy_t_coords_on()"""
        ret = self._vtk_obj.CopyTCoordsOn()
        return ret
        

    def copy_tensors_off(self):
        """
        copy_tensors_off(self) -> None
        C++: virtual void copy_tensors_off()"""
        ret = self._vtk_obj.CopyTensorsOff()
        return ret
        

    def copy_tensors_on(self):
        """
        copy_tensors_on(self) -> None
        C++: virtual void copy_tensors_on()"""
        ret = self._vtk_obj.CopyTensorsOn()
        return ret
        

    def copy_tuple(self, *args):
        """
        copy_tuple(self, fromData:AbstractArray,
            toData:AbstractArray, fromId:int, toId:int) -> None
        C++: void copy_tuple(AbstractArray *fromData,
            AbstractArray *toData, IdType fromId, IdType toId)
        Copy a tuple (or set of tuples) of data from one data array to
        another. This method assumes that the fromData and toData objects
        are of the same type, and have the same number of components.
        This is true if you invoke copy_allocate() or
        interpolate_allocate().
        """
        my_args = deref_array(args, [('vtkAbstractArray', 'vtkAbstractArray', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.CopyTuple, *my_args)
        return ret

    def copy_tuples(self, *args):
        """
        copy_tuples(self, fromData:AbstractArray,
            toData:AbstractArray, fromIds:IdList, toIds:IdList)
            -> None
        C++: void copy_tuples(AbstractArray *fromData,
            AbstractArray *toData, IdList *fromIds,
            IdList *toIds)
        copy_tuples(self, fromData:AbstractArray,
            toData:AbstractArray, dstStart:int, n:int, srcStart:int)
            -> None
        C++: void copy_tuples(AbstractArray *fromData,
            AbstractArray *toData, IdType dstStart, IdType n,
            IdType srcStart)"""
        my_args = deref_array(args, [('vtkAbstractArray', 'vtkAbstractArray', 'vtkIdList', 'vtkIdList'), ('vtkAbstractArray', 'vtkAbstractArray', 'int', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.CopyTuples, *my_args)
        return ret

    def copy_vectors_off(self):
        """
        copy_vectors_off(self) -> None
        C++: virtual void copy_vectors_off()"""
        ret = self._vtk_obj.CopyVectorsOff()
        return ret
        

    def copy_vectors_on(self):
        """
        copy_vectors_on(self) -> None
        C++: virtual void copy_vectors_on()"""
        ret = self._vtk_obj.CopyVectorsOn()
        return ret
        

    def ghost_array_name(self):
        """
        ghost_array_name() -> str
        C++: static const char *ghost_array_name()"""
        ret = self._vtk_obj.GhostArrayName()
        return ret
        

    def interpolate_allocate(self, *args):
        """
        interpolate_allocate(self, pd:DataSetAttributes, sze:int=0,
            ext:int=1000) -> None
        C++: void interpolate_allocate(DataSetAttributes *pd,
            IdType sze=0, IdType ext=1000)
        interpolate_allocate(self, pd:DataSetAttributes, sze:int,
            ext:int, shallowCopyArrays:int) -> None
        C++: void interpolate_allocate(DataSetAttributes *pd,
            IdType sze, IdType ext, int shallowCopyArrays)
        interpolate_allocate(self, list:DataSetAttributesFieldList,
            sze:int=0, ext:int=1000) -> None
        C++: void interpolate_allocate(
            DataSetAttributes::FieldList &list, IdType sze=0,
            IdType ext=1000)
        Initialize point interpolation method. Note that pd HAS to be the
        DataSetAttributes object which will later be used with
        interpolate_point or interpolate_edge. ext is no longer used. If
        shallowcopy_arrays is true, input arrays are copied to the output
        instead of new ones being allocated.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InterpolateAllocate, *my_args)
        return ret

    def interpolate_edge(self, *args):
        """
        interpolate_edge(self, fromPd:DataSetAttributes, toId:int,
            p1:int, p2:int, t:float) -> None
        C++: void interpolate_edge(DataSetAttributes *fromPd,
            IdType toId, IdType p1, IdType p2, double t)
        Interpolate data from the two points p1,p2 (forming an edge) and
        an interpolation factor, t, along the edge. The weight ranges
        from (0,1), with t=0 located at p1. Make sure that the method
        interpolate_allocate() has been invoked before using this method.
        If the INTERPOLATION copy flag is set to 0 for an array,
        interpolation is prevented. If the flag is set to 1, weighted
        interpolation occurs. If the flag is set to 2, nearest neighbor
        interpolation is used.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InterpolateEdge, *my_args)
        return ret

    def interpolate_point(self, *args):
        """
        interpolate_point(self, fromPd:DataSetAttributes, toId:int,
            ids:IdList, weights:[float, ...]) -> None
        C++: void interpolate_point(DataSetAttributes *fromPd,
            IdType toId, IdList *ids, double *weights)
        interpolate_point(self, list:DataSetAttributesFieldList,
            fromPd:DataSetAttributes, idx:int, toId:int, ids:IdList,
             weights:[float, ...]) -> None
        C++: void interpolate_point(DataSetAttributes::FieldList &list,
            DataSetAttributes *fromPd, int idx, IdType toId,
            IdList *ids, double *weights)
        Interpolate data set attributes from other data set attributes
        given cell or point ids and associated interpolation weights. If
        the INTERPOLATION copy flag is set to 0 for an array,
        interpolation is prevented. If the flag is set to 1, weighted
        interpolation occurs. If the flag is set to 2, nearest neighbor
        interpolation is used.
        """
        my_args = deref_array(args, [('vtkDataSetAttributes', 'int', 'vtkIdList', 'tuple'), ('vtkDataSetAttributesFieldList', 'vtkDataSetAttributes', 'int', 'int', 'vtkIdList', 'tuple')])
        ret = self._wrap_call(self._vtk_obj.InterpolatePoint, *my_args)
        return ret

    def interpolate_time(self, *args):
        """
        interpolate_time(self, from1:DataSetAttributes,
            from2:DataSetAttributes, id:int, t:float) -> None
        C++: void interpolate_time(DataSetAttributes *from1,
            DataSetAttributes *from2, IdType id, double t)
        Interpolate data from the same id (point or cell) at different
        points in time (parameter t). Two input data set attributes
        objects are input. The parameter t lies between (0<=t<=1).
        IMPORTANT: it is assumed that the number of attributes and number
        of components is the same for both from1 and from2, and the type
        of data for from1 and from2 are the same. Make sure that the
        method interpolate_allocate() has been invoked before using this
        method. If the INTERPOLATION copy flag is set to 0 for an array,
        interpolation is prevented. If the flag is set to 1, weighted
        interpolation occurs. If the flag is set to 2, nearest neighbor
        interpolation is used.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InterpolateTime, *my_args)
        return ret

    def is_array_an_attribute(self, *args):
        """
        is_array_an_attribute(self, idx:int) -> int
        C++: int is_array_an_attribute(int idx)
        Determine whether a data array of index idx is considered a data
        set attribute (i.e., scalar, vector, tensor, etc). Return
        less-than zero if it is, otherwise an index 0<=idx<NUM_ATTRIBUTES
        to indicate which attribute.
        """
        ret = self._wrap_call(self._vtk_obj.IsArrayAnAttribute, *args)
        return ret

    def set_active_attribute(self, *args):
        """
        set_active_attribute(self, name:str, attributeType:int) -> int
        C++: int set_active_attribute(const char *name, int attributeType)
        set_active_attribute(self, index:int, attributeType:int) -> int
        C++: int set_active_attribute(int index, int attributeType)
        Make the array with the given name the active attribute.
        Attribute types are: DataSetAttributes::SCALARS = 0
        DataSetAttributes::VECTORS = 1 DataSetAttributes::NORMALS =
        2 DataSetAttributes::TCOORDS = 3 DataSetAttributes::TENSORS
        = 4 DataSetAttributes::GLOBALIDS = 5
        DataSetAttributes::PEDIGREEIDS = 6
        DataSetAttributes::EDGEFLAG = 7 DataSetAttributes::TANGENTS
        = 8 Returns the index of the array if successful, -1 if the array
        is not in the list of arrays.
        """
        ret = self._wrap_call(self._vtk_obj.SetActiveAttribute, *args)
        return ret

    def set_active_global_ids(self, *args):
        """
        set_active_global_ids(self, name:str) -> int
        C++: int set_active_global_ids(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.SetActiveGlobalIds, *args)
        return ret

    def set_active_higher_order_degrees(self, *args):
        """
        set_active_higher_order_degrees(self, name:str) -> int
        C++: int set_active_higher_order_degrees(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.SetActiveHigherOrderDegrees, *args)
        return ret

    def set_active_normals(self, *args):
        """
        set_active_normals(self, name:str) -> int
        C++: int set_active_normals(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.SetActiveNormals, *args)
        return ret

    def set_active_pedigree_ids(self, *args):
        """
        set_active_pedigree_ids(self, name:str) -> int
        C++: int set_active_pedigree_ids(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.SetActivePedigreeIds, *args)
        return ret

    def set_active_rational_weights(self, *args):
        """
        set_active_rational_weights(self, name:str) -> int
        C++: int set_active_rational_weights(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.SetActiveRationalWeights, *args)
        return ret

    def set_active_scalars(self, *args):
        """
        set_active_scalars(self, name:str) -> int
        C++: int set_active_scalars(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.SetActiveScalars, *args)
        return ret

    def set_active_t_coords(self, *args):
        """
        set_active_t_coords(self, name:str) -> int
        C++: int set_active_t_coords(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.SetActiveTCoords, *args)
        return ret

    def set_active_tangents(self, *args):
        """
        set_active_tangents(self, name:str) -> int
        C++: int set_active_tangents(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.SetActiveTangents, *args)
        return ret

    def set_active_tensors(self, *args):
        """
        set_active_tensors(self, name:str) -> int
        C++: int set_active_tensors(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.SetActiveTensors, *args)
        return ret

    def set_active_vectors(self, *args):
        """
        set_active_vectors(self, name:str) -> int
        C++: int set_active_vectors(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.SetActiveVectors, *args)
        return ret

    def setup_for_copy(self, *args):
        """
        setup_for_copy(self, pd:DataSetAttributes) -> None
        C++: void setup_for_copy(DataSetAttributes *pd)
        Create a mapping between the input attributes and this object so
        that methods like copy_data() and copy_structured_data() can be
        called. This method assumes that this object has the same arrays
        as the input and that they are ordered the same way (same array
        indices).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetupForCopy, *my_args)
        return ret

    def update(self):
        """
        update(self) -> None
        C++: virtual void update()
        Attributes have a chance to bring themselves up to date; right
        now this is ignored.
        """
        ret = self._vtk_obj.Update()
        return ret
        

    _updateable_traits_ = \
    (('copy_higher_order_degrees', 'GetCopyHigherOrderDegrees'),
    ('copy_rational_weights', 'GetCopyRationalWeights'), ('copy_tangents',
    'GetCopyTangents'), ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('copy_global_ids', 'GetCopyGlobalIds'),
    ('copy_normals', 'GetCopyNormals'), ('copy_pedigree_ids',
    'GetCopyPedigreeIds'), ('copy_scalars', 'GetCopyScalars'),
    ('copy_t_coords', 'GetCopyTCoords'), ('copy_tensors',
    'GetCopyTensors'), ('copy_vectors', 'GetCopyVectors'),
    ('number_of_tuples', 'GetNumberOfTuples'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['copy_higher_order_degrees', 'copy_rational_weights',
    'copy_tangents', 'debug', 'global_warning_display', 'copy_global_ids',
    'copy_normals', 'copy_pedigree_ids', 'copy_scalars', 'copy_t_coords',
    'copy_tensors', 'copy_vectors', 'number_of_tuples'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DataSetAttributes, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DataSetAttributes properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['copy_higher_order_degrees', 'copy_rational_weights',
            'copy_tangents'], [], ['copy_global_ids', 'copy_normals',
            'copy_pedigree_ids', 'copy_scalars', 'copy_t_coords', 'copy_tensors',
            'copy_vectors', 'number_of_tuples']),
            title='Edit DataSetAttributes properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DataSetAttributes properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

