# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object import DataObject


class DataSet(DataObject):
    """
    DataSet - abstract class to specify dataset behavior
    
    Superclass: DataObject
    
    DataSet is an abstract class that specifies an interface for
    dataset objects. DataSet also provides methods to provide
    information about the data, such as center, bounding box, and
    representative length.
    
    In vtk a dataset consists of a structure (geometry and topology) and
    attribute data. The structure is defined implicitly or explicitly as
    a collection of cells. The geometry of the structure is contained in
    point coordinates plus the cell interpolation functions. The topology
    of the dataset structure is defined by cell types and how the cells
    share their defining points.
    
    Attribute data in vtk is either point data (data at points) or cell
    data (data at cells). Typically filters operate on point data, but
    some may operate on cell data, both cell and point data, either one,
    or none.
    
    @sa
    PointSet StructuredPoints StructuredGrid UnstructuredGrid
    RectilinearGrid PolyData PointData CellData DataObject
    FieldData
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDataSet, obj, update, **traits)
    
    def _get_bounds(self):
        return self._vtk_obj.GetBounds()
    bounds = traits.Property(_get_bounds, desc=\
        """
        Return a pointer to the geometry bounding box in the form
        (xmin,xmax, ymin,ymax, zmin,zmax). THIS METHOD IS NOT THREAD
        SAFE.
        """
    )

    def get_bounds(self, *args):
        """
        get_bounds(self) -> (float, float, float, float, float, float)
        C++: double *get_bounds()
        get_bounds(self, bounds:[float, float, float, float, float, float])
             -> None
        C++: void get_bounds(double bounds[6])
        Return a pointer to the geometry bounding box in the form
        (xmin,xmax, ymin,ymax, zmin,zmax). THIS METHOD IS NOT THREAD
        SAFE.
        """
        ret = self._wrap_call(self._vtk_obj.GetBounds, *args)
        return ret

    def get_cell(self, *args):
        """
        get_cell(self, cellId:int) -> Cell
        C++: virtual Cell *get_cell(IdType cellId)
        get_cell(self, i:int, j:int, k:int) -> Cell
        C++: virtual Cell *get_cell(int i, int j, int k)
        get_cell(self, cellId:int, cell:GenericCell) -> None
        C++: virtual void get_cell(IdType cellId, GenericCell *cell)
        Get cell with cellId such that: 0 <= cellId < number_of_cells. The
        returned Cell is an object owned by this instance, hence the
        return value must not be deleted by the caller.
        
        @warning Repeat calls to this function for different face ids
            will change
        the data stored in the internal member object whose pointer is
        returned by this function.
        
        @warning THIS METHOD IS NOT THREAD SAFE. For a thread-safe
            version, please use
        void get_cell(vtkid_type cellId, GenericCell* cell).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetCell, *my_args)
        return wrap_vtk(ret)

    def get_cell_bounds(self, *args):
        """
        get_cell_bounds(self, cellId:int, bounds:[float, float, float,
            float, float, float]) -> None
        C++: virtual void get_cell_bounds(IdType cellId,
            double bounds[6])
        Get the bounds of the cell with cellId such that: 0 <= cellId <
        number_of_cells. A subclass may be able to determine the bounds of
        cell without using an expensive get_cell() method. A default
        implementation is provided that actually uses a get_cell() call. 
        This is to ensure the method is available to all datasets. 
        Subclasses should override this method to provide an efficient
        implementation. THIS METHOD IS THREAD SAFE IF FIRST CALLED FROM A
        SINGLE THREAD AND THE DATASET IS NOT MODIFIED
        """
        ret = self._wrap_call(self._vtk_obj.GetCellBounds, *args)
        return ret

    def _get_cell_data(self):
        return wrap_vtk(self._vtk_obj.GetCellData())
    cell_data = traits.Property(_get_cell_data, desc=\
        """
        Return a pointer to this dataset's cell data. THIS METHOD IS
        THREAD SAFE
        """
    )

    def _get_cell_ghost_array(self):
        return wrap_vtk(self._vtk_obj.GetCellGhostArray())
    cell_ghost_array = traits.Property(_get_cell_ghost_array, desc=\
        """
        Get the array that defines the ghost type of each cell. We cache
        the pointer to the array to save a lookup involving string
        comparisons
        """
    )

    def get_cell_neighbors(self, *args):
        """
        get_cell_neighbors(self, cellId:int, ptIds:IdList,
            cellIds:IdList) -> None
        C++: virtual void get_cell_neighbors(IdType cellId,
            IdList *ptIds, IdList *cellIds)
        Topological inquiry to get all cells using list of points
        exclusive of cell specified (e.g., cellId). Note that the list
        consists of only cells that use ALL the points provided. THIS
        METHOD IS THREAD SAFE IF FIRST CALLED FROM A SINGLE THREAD AND
        THE DATASET IS NOT MODIFIED
        """
        my_args = deref_array(args, [('int', 'vtkIdList', 'vtkIdList')])
        ret = self._wrap_call(self._vtk_obj.GetCellNeighbors, *my_args)
        return ret

    def get_cell_points(self, *args):
        """
        get_cell_points(self, cellId:int, ptIds:IdList) -> None
        C++: virtual void get_cell_points(IdType cellId,
            IdList *ptIds)
        Topological inquiry to get points defining cell. THIS METHOD IS
        THREAD SAFE IF FIRST CALLED FROM A SINGLE THREAD AND THE DATASET
        IS NOT MODIFIED
        """
        my_args = deref_array(args, [('int', 'vtkIdList')])
        ret = self._wrap_call(self._vtk_obj.GetCellPoints, *my_args)
        return ret

    def get_cell_type(self, *args):
        """
        get_cell_type(self, cellId:int) -> int
        C++: virtual int get_cell_type(IdType cellId)
        Get type of cell with cellId such that: 0 <= cellId <
        number_of_cells. THIS METHOD IS THREAD SAFE IF FIRST CALLED FROM A
        SINGLE THREAD AND THE DATASET IS NOT MODIFIED
        """
        ret = self._wrap_call(self._vtk_obj.GetCellType, *args)
        return ret

    def get_cell_types(self, *args):
        """
        get_cell_types(self, types:CellTypes) -> None
        C++: virtual void get_cell_types(CellTypes *types)
        Get a list of types of cells in a dataset. The list consists of
        an array of types (not necessarily in any order), with a single
        entry per type. For example a dataset 5 triangles, 3 lines, and
        100 hexahedra would result a list of three entries, corresponding
        to the types VTK_TRIANGLE, VTK_LINE, and VTK_HEXAHEDRON. THIS
        METHOD IS THREAD SAFE IF FIRST CALLED FROM A SINGLE THREAD AND
        THE DATASET IS NOT MODIFIED
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetCellTypes, *my_args)
        return ret

    def _get_center(self):
        return self._vtk_obj.GetCenter()
    center = traits.Property(_get_center, desc=\
        """
        Get the center of the bounding box. THIS METHOD IS NOT THREAD
        SAFE.
        """
    )

    def get_center(self, *args):
        """
        get_center(self) -> (float, float, float)
        C++: double *get_center()
        get_center(self, center:[float, float, float]) -> None
        C++: void get_center(double center[3])
        Get the center of the bounding box. THIS METHOD IS NOT THREAD
        SAFE.
        """
        ret = self._wrap_call(self._vtk_obj.GetCenter, *args)
        return ret

    def _get_length(self):
        return self._vtk_obj.GetLength()
    length = traits.Property(_get_length, desc=\
        """
        Return the length of the diagonal of the bounding box. THIS
        METHOD IS THREAD SAFE IF FIRST CALLED FROM A SINGLE THREAD AND
        THE DATASET IS NOT MODIFIED
        """
    )

    def _get_max_cell_size(self):
        return self._vtk_obj.GetMaxCellSize()
    max_cell_size = traits.Property(_get_max_cell_size, desc=\
        """
        Convenience method returns largest cell size in dataset. This is
        generally used to allocate memory for supporting data structures.
        THIS METHOD IS THREAD SAFE
        """
    )

    def _get_number_of_cells(self):
        return self._vtk_obj.GetNumberOfCells()
    number_of_cells = traits.Property(_get_number_of_cells, desc=\
        """
        Determine the number of cells composing the dataset. THIS METHOD
        IS THREAD SAFE
        """
    )

    def _get_number_of_points(self):
        return self._vtk_obj.GetNumberOfPoints()
    number_of_points = traits.Property(_get_number_of_points, desc=\
        """
        Determine the number of points composing the dataset. THIS METHOD
        IS THREAD SAFE
        """
    )

    def get_point(self, *args):
        """
        get_point(self, ptId:int) -> (float, float, float)
        C++: virtual double *get_point(IdType ptId)
        get_point(self, id:int, x:[float, float, float]) -> None
        C++: virtual void get_point(IdType id, double x[3])
        Get point coordinates with ptId such that: 0 <= ptId <
        number_of_points. THIS METHOD IS NOT THREAD SAFE.
        """
        ret = self._wrap_call(self._vtk_obj.GetPoint, *args)
        return ret

    def get_point_cells(self, *args):
        """
        get_point_cells(self, ptId:int, cellIds:IdList) -> None
        C++: virtual void get_point_cells(IdType ptId,
            IdList *cellIds)
        Topological inquiry to get cells using point. THIS METHOD IS
        THREAD SAFE IF FIRST CALLED FROM A SINGLE THREAD AND THE DATASET
        IS NOT MODIFIED
        """
        my_args = deref_array(args, [('int', 'vtkIdList')])
        ret = self._wrap_call(self._vtk_obj.GetPointCells, *my_args)
        return ret

    def _get_point_data(self):
        return wrap_vtk(self._vtk_obj.GetPointData())
    point_data = traits.Property(_get_point_data, desc=\
        """
        Return a pointer to this dataset's point data. THIS METHOD IS
        THREAD SAFE
        """
    )

    def _get_point_ghost_array(self):
        return wrap_vtk(self._vtk_obj.GetPointGhostArray())
    point_ghost_array = traits.Property(_get_point_ghost_array, desc=\
        """
        Gets the array that defines the ghost type of each point. We
        cache the pointer to the array to save a lookup involving string
        comparisons
        """
    )

    def _get_scalar_range(self):
        return self._vtk_obj.GetScalarRange()
    scalar_range = traits.Property(_get_scalar_range, desc=\
        """
        Convenience method to get the range of the first component (and
        only the first component) of any scalars in the data set.  If the
        data has both point data and cell data, it returns the (min/max)
        range of combined point and cell data.  If there are no point or
        cell scalars the method will return (0,1).  Note: It might be
        necessary to call Update to create or refresh the scalars before
        calling this method. THIS METHOD IS THREAD SAFE IF FIRST CALLED
        FROM A SINGLE THREAD AND THE DATASET IS NOT MODIFIED
        """
    )

    def get_scalar_range(self, *args):
        """
        get_scalar_range(self, range:[float, float]) -> None
        C++: virtual void get_scalar_range(double range[2])
        get_scalar_range(self) -> (float, float)
        C++: double *get_scalar_range()
        Convenience method to get the range of the first component (and
        only the first component) of any scalars in the data set.  If the
        data has both point data and cell data, it returns the (min/max)
        range of combined point and cell data.  If there are no point or
        cell scalars the method will return (0,1).  Note: It might be
        necessary to call Update to create or refresh the scalars before
        calling this method. THIS METHOD IS THREAD SAFE IF FIRST CALLED
        FROM A SINGLE THREAD AND THE DATASET IS NOT MODIFIED
        """
        ret = self._wrap_call(self._vtk_obj.GetScalarRange, *args)
        return ret

    def allocate_cell_ghost_array(self):
        """
        allocate_cell_ghost_array(self) -> UnsignedCharArray
        C++: UnsignedCharArray *allocate_cell_ghost_array()
        Allocate ghost array for cells.
        """
        ret = wrap_vtk(self._vtk_obj.AllocateCellGhostArray())
        return ret
        

    def allocate_point_ghost_array(self):
        """
        allocate_point_ghost_array(self) -> UnsignedCharArray
        C++: UnsignedCharArray *allocate_point_ghost_array()
        Allocate ghost array for points.
        """
        ret = wrap_vtk(self._vtk_obj.AllocatePointGhostArray())
        return ret
        

    def check_attributes(self):
        """
        check_attributes(self) -> int
        C++: int check_attributes()
        This method checks to see if the cell and point attributes match
        the geometry.  Many filters will crash if the number of tuples in
        an array is less than the number of points/cells. This method
        returns 1 if there is a mismatch, and 0 if everything is ok.  It
        prints an error if an array is too short, and a warning if an
        array is too long.
        """
        ret = self._vtk_obj.CheckAttributes()
        return ret
        

    def compute_bounds(self):
        """
        compute_bounds(self) -> None
        C++: virtual void compute_bounds()
        Compute the data bounding box from data points. THIS METHOD IS
        NOT THREAD SAFE.
        """
        ret = self._vtk_obj.ComputeBounds()
        return ret
        

    def copy_attributes(self, *args):
        """
        copy_attributes(self, ds:DataSet) -> None
        C++: virtual void copy_attributes(DataSet *ds)
        Copy the attributes associated with the specified dataset to this
        instance of DataSet. THIS METHOD IS NOT THREAD SAFE.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CopyAttributes, *my_args)
        return ret

    def copy_structure(self, *args):
        """
        copy_structure(self, ds:DataSet) -> None
        C++: virtual void copy_structure(DataSet *ds)
        Copy the geometric and topological structure of an object. Note
        that the invoking object and the object pointed to by the
        parameter ds must be of the same type. THIS METHOD IS NOT THREAD
        SAFE.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CopyStructure, *my_args)
        return ret

    def find_and_get_cell(self, *args):
        """
        find_and_get_cell(self, x:[float, float, float], cell:Cell,
            cellId:int, tol2:float, subId:int, pcoords:[float, float,
            float], weights:[float, ...]) -> Cell
        C++: virtual Cell *find_and_get_cell(double x[3], Cell *cell,
            IdType cellId, double tol2, int &subId, double pcoords[3],
            double *weights)
        Locate the cell that contains a point and return the cell. Also
        returns the subcell id, parametric coordinates and weights for
        subsequent interpolation. This method combines the derived class
        methods int find_cell and Cell *get_cell. Derived classes may
        provide a more efficient implementation. See for example
        StructuredPoints. THIS METHOD IS NOT THREAD SAFE.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.FindAndGetCell, *my_args)
        return wrap_vtk(ret)

    def find_cell(self, *args):
        """
        find_cell(self, x:[float, float, float], cell:Cell, cellId:int,
            tol2:float, subId:int, pcoords:[float, float, float],
            weights:[float, ...]) -> int
        C++: virtual IdType find_cell(double x[3], Cell *cell,
            IdType cellId, double tol2, int &subId, double pcoords[3],
            double *weights)
        find_cell(self, x:[float, float, float], cell:Cell,
            gencell:GenericCell, cellId:int, tol2:float, subId:int,
            pcoords:[float, float, float], weights:[float, ...]) -> int
        C++: virtual IdType find_cell(double x[3], Cell *cell,
            GenericCell *gencell, IdType cellId, double tol2,
            int &subId, double pcoords[3], double *weights)
        Locate cell based on global coordinate x and tolerance squared.
        If cell and cellId is non-nullptr, then search starts from this
        cell and looks at immediate neighbors.  Returns cellId >= 0 if
        inside, < 0 otherwise.  The parametric coordinates are provided
        in pcoords[3]. The interpolation weights are returned in
        weights[]. (The number of weights is equal to the number of
        points in the found cell). Tolerance is used to control how close
        the point is to be considered "in" the cell. THIS METHOD IS NOT
        THREAD SAFE.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.FindCell, *my_args)
        return ret

    def find_point(self, *args):
        """
        find_point(self, x:float, y:float, z:float) -> int
        C++: IdType find_point(double x, double y, double z)
        find_point(self, x:[float, float, float]) -> int
        C++: virtual IdType find_point(double x[3])
        Locate the closest point to the global coordinate x. Return the
        point id. If point id < 0; then no point found. (This may arise
        when point is outside of dataset.) THIS METHOD IS THREAD SAFE IF
        FIRST CALLED FROM A SINGLE THREAD AND THE DATASET IS NOT MODIFIED
        """
        ret = self._wrap_call(self._vtk_obj.FindPoint, *args)
        return ret

    def generate_ghost_array(self, *args):
        """
        generate_ghost_array(self, zeroExt:[int, int, int, int, int, int])
            -> None
        C++: virtual void generate_ghost_array(int zeroExt[6])
        generate_ghost_array(self, zeroExt:[int, int, int, int, int, int],
            cellOnly:bool) -> None
        C++: virtual void generate_ghost_array(int zeroExt[6],
            bool cellOnly)
        Normally called by pipeline executives or algorithms only. This
        method computes the ghost arrays for a given dataset. The zeroExt
        argument specifies the extent of the region which ghost type = 0.
        """
        ret = self._wrap_call(self._vtk_obj.GenerateGhostArray, *args)
        return ret

    def has_any_blank_cells(self):
        """
        has_any_blank_cells(self) -> bool
        C++: virtual bool has_any_blank_cells()
        Returns 1 if there are any blanking cells 0 otherwise. Blanking
        is supported only for StructuredGrid and UniformGrid
        """
        ret = self._vtk_obj.HasAnyBlankCells()
        return ret
        

    def has_any_blank_points(self):
        """
        has_any_blank_points(self) -> bool
        C++: virtual bool has_any_blank_points()
        Returns 1 if there are any blanking points 0 otherwise. Blanking
        is supported only for StructuredGrid and UniformGrid
        """
        ret = self._vtk_obj.HasAnyBlankPoints()
        return ret
        

    def has_any_ghost_cells(self):
        """
        has_any_ghost_cells(self) -> bool
        C++: bool has_any_ghost_cells()
        Returns 1 if there are any ghost cells 0 otherwise.
        """
        ret = self._vtk_obj.HasAnyGhostCells()
        return ret
        

    def has_any_ghost_points(self):
        """
        has_any_ghost_points(self) -> bool
        C++: bool has_any_ghost_points()
        Returns 1 if there are any ghost points 0 otherwise.
        """
        ret = self._vtk_obj.HasAnyGhostPoints()
        return ret
        

    def new_cell_iterator(self):
        """
        new_cell_iterator(self) -> CellIterator
        C++: virtual CellIterator *new_cell_iterator()
        Return an iterator that traverses the cells in this data set.
        """
        ret = wrap_vtk(self._vtk_obj.NewCellIterator())
        return ret
        

    def set_cell_order_and_rational_weights(self, *args):
        """
        set_cell_order_and_rational_weights(self, cellId:int,
            cell:GenericCell) -> None
        C++: void set_cell_order_and_rational_weights(IdType cellId,
            GenericCell *cell)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetCellOrderAndRationalWeights, *my_args)
        return ret

    def squeeze(self):
        """
        squeeze(self) -> None
        C++: virtual void squeeze()
        Reclaim any extra memory used to store data. THIS METHOD IS NOT
        THREAD SAFE.
        """
        ret = self._vtk_obj.Squeeze()
        return ret
        

    def update_cell_ghost_array_cache(self):
        """
        update_cell_ghost_array_cache(self) -> None
        C++: void update_cell_ghost_array_cache()
        Updates the pointer to the cell ghost array.
        """
        ret = self._vtk_obj.UpdateCellGhostArrayCache()
        return ret
        

    def update_point_ghost_array_cache(self):
        """
        update_point_ghost_array_cache(self) -> None
        C++: void update_point_ghost_array_cache()
        Updates the pointer to the point ghost array.
        """
        ret = self._vtk_obj.UpdatePointGhostArrayCache()
        return ret
        

    _updateable_traits_ = \
    (('global_release_data_flag', 'GetGlobalReleaseDataFlag'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_release_data_flag', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DataSet, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DataSet properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['global_release_data_flag'], [], []),
            title='Edit DataSet properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DataSet properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

