# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class Curvatures(PolyDataAlgorithm):
    """
    Curvatures - compute curvatures (Gauss and mean) of a Polydata
    object
    
    Superclass: PolyDataAlgorithm
    
    Curvatures takes a polydata input and computes the curvature of
    the mesh at each point. Four possible methods of computation are
    available :
    
    Gauss Curvature discrete Gauss curvature ( $ K $),$K_v =
    2\pi-n_vf_v(\alpha) $, where $K_v $ is the curvature at vertex $v $,
    $n_v $ the facet neighbours of the vertex $v $ and $f_v(\alpha) $ is
    the angle of $f $ at vertex $v $. The contribution of every facet is
    for the moment weighted by the (area of each facet)/3 The units of
    Gaussian Curvature are $m^{-2} $.
    
    Mean Curvature $H_v = \overline{H_e} $, where $\overline{H_e} $ is
    the average over the edge neighbours of $H_e $.$H_e = l(e)*\alpha(e) $
    where $e $ is an edge, $l $ is the length and $\alpha $ is the
    dihederal angle such that$-\pi < \alpha < \pi $. This means that the
    surface is assumed to be orientable and the computation creates the
    orientation. The units of Mean Curvature are $m^{-1} $.
    
    Maximum ( $k_{max} $) and Minimum ( $k_{min} $) Principal Curvatures
     are $k_{max} = H + \sqrt{H^2 - K} $ and$k_{min} = H - \sqrt{H^2 - K}
    $. Excepting spherical and planar surfaces which have equal principal
    curvatures, the curvature at a point on a surface varies with the
    direction one "sets off" from the point. For all directions, the
    curvature will pass through two extrema: a minimum ( $k_{min} $) and
    a maximum ( $k_{max} $) which occur at mutually orthogonal directions
    to each other.
    
    The sign of the Gauss curvature is a geometric ivariant, it should be
    positive when the surface looks like a sphere, negative when it looks
    like a saddle, however, the sign of the Mean curvature is not, it
    depends on the convention for normals, This code assumes that normals
    point outwards (ie from the surface of a sphere outwards). If a given
    mesh produces curvatures of opposite senses then the flag
    invert_mean_curvature
     can be set and the Curvature reported by the Mean calculation will
    be inverted.
    
    For a little more information see <a
    href="https://public.kitware.com/pipermail/vtkusers/2002-July/012198.html"
    >Computing curvature of a surface
    
    @par Thanks: <a
    href="https://en.wikipedia.org/wiki/Philip_Batchelor">Philip
    Batchelor for creating and contributing the class and Andrew Maclean
    for cleanups and fixes. Thanks also to John Biddiscombe for adding
    the class and Goodwin Lawlor for contributing a patch to calculate
    principal curvatures
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCurvatures, obj, update, **traits)
    
    invert_mean_curvature = tvtk_base.false_bool_trait(desc=\
        """
        Set/Get the flag which inverts the mean curvature calculation for
        meshes with inward pointing normals (default false)
        """
    )

    def _invert_mean_curvature_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInvertMeanCurvature,
                        self.invert_mean_curvature_)

    curvature_type = tvtk_base.RevPrefixMap({'gaussian': 0, 'maximum': 2, 'mean': 1, 'minimum': 3}, default_value='gaussian', desc=\
        """
        Set/Get Curvature type VTK_CURVATURE_GAUSS: Gaussian curvature,
        stored as data_array "Gauss_Curvature" VTK_CURVATURE_MEAN : Mean
        curvature, stored as data_array "Mean_Curvature"
        """
    )

    def _curvature_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCurvatureType,
                        self.curvature_type_)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('invert_mean_curvature', 'GetInvertMeanCurvature'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('curvature_type', 'GetCurvatureType'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'invert_mean_curvature', 'release_data_flag', 'curvature_type',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Curvatures, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Curvatures properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['invert_mean_curvature'], ['curvature_type'], []),
            title='Edit Curvatures properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Curvatures properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

