# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class AbstractCellLinks(Object):
    """
    AbstractCellLinks - an abstract base class for classes that build
    topological links from points to cells
    
    Superclass: Object
    
    AbstractCellLinks is a family of supplemental objects to
    CellArray and CellTypes, enabling fast access from points to
    the cells using the points. AbstractCellLinks is an array of
    links, each link representing a list of cell ids using a particular
    point. The information provided by this object can be used to
    determine neighbors and construct other local topological
    information.
    
    @sa
    CellLinks StaticCellLinks StaticCellLinksTemplate
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAbstractCellLinks, obj, update, **traits)
    
    sequential_processing = tvtk_base.false_bool_trait(desc=\
        """
        Force sequential processing (i.e. single thread) of the link
        building process. By default, sequential processing is off. Note
        this flag only applies if the class has been compiled with
        VTK_SMP_IMPLEMENTATION_TYPE set to something other than
        Sequential. (If set to Sequential, then the filter always runs in
        serial mode.) This flag is typically used for benchmarking
        purposes.
        """
    )

    def _sequential_processing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSequentialProcessing,
                        self.sequential_processing_)

    def _get_actual_memory_size(self):
        return self._vtk_obj.GetActualMemorySize()
    actual_memory_size = traits.Property(_get_actual_memory_size, desc=\
        """
        Return the memory in kibibytes (1024 bytes) consumed by this cell
        links array. Used to support streaming and reading/writing data.
        The value returned is guaranteed to be greater than or equal to
        the memory required to actually represent the data represented by
        this object. The information returned is valid only after the
        pipeline has been updated.
        """
    )

    def _get_type(self):
        return self._vtk_obj.GetType()
    type = traits.Property(_get_type, desc=\
        """
        Return the type of locator (see enum above).
        """
    )

    def build_links(self, *args):
        """
        build_links(self, data:DataSet) -> None
        C++: virtual void build_links(DataSet *data)
        Build the link list array. All subclasses must implement this
        method.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.BuildLinks, *my_args)
        return ret

    def compute_type(self, *args):
        """
        compute_type(maxPtId:int, maxCellId:int, ca:CellArray) -> int
        C++: static int compute_type(IdType maxPtId,
            IdType maxCellId, CellArray *ca)
        Based on the input (i.e., number of points, number of cells, and
        length of connectivity array) this helper method returns the
        integral type to use when instantiating cell link-related classes
        in order to properly represent the data.  The return value is one
        of the types defined in the enum cell_links_type enum defined
        previously. Subclasses may choose to instantiate themselves with
        different integral types for performance and/or memory reasons.
        This method is useful when instantiating a
        StaticCellLinksTemplate; when instantiating a CellLinks the
        class is hardwired for IdType.
        """
        my_args = deref_array(args, [('int', 'int', 'vtkCellArray')])
        ret = self._wrap_call(self._vtk_obj.ComputeType, *my_args)
        return ret

    def deep_copy(self, *args):
        """
        deep_copy(self, src:AbstractCellLinks) -> None
        C++: virtual void deep_copy(AbstractCellLinks *src)
        Standard deep_copy method.  Since this object contains no
        reference to other objects, there is no shallow_copy.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DeepCopy, *my_args)
        return ret

    def initialize(self):
        """
        initialize(self) -> None
        C++: virtual void initialize()
        Release memory and revert to empty state.
        """
        ret = self._vtk_obj.Initialize()
        return ret
        

    def reset(self):
        """
        reset(self) -> None
        C++: virtual void reset()
        Reset to a state of no entries without freeing the memory.
        """
        ret = self._vtk_obj.Reset()
        return ret
        

    def select_cells(self, *args):
        """
        select_cells(self, minMaxDegree:[int, int], cellSelection:[int,
            ...]) -> None
        C++: virtual void select_cells(IdType minMaxDegree[2],
            unsigned char *cellSelection)
        Select all cells with a point degree in the range
        [minDegree,maxDegree). The degree is the number of cells using a
        point. The selection is indicated through the provided unsigned
        char array, with a non-zero value indicates selection. The memory
        allocated for cellSelection must be the maximum cell id
        referenced in the links.
        """
        ret = self._wrap_call(self._vtk_obj.SelectCells, *args)
        return ret

    def squeeze(self):
        """
        squeeze(self) -> None
        C++: virtual void squeeze()
        Reclaim any unused memory.
        """
        ret = self._vtk_obj.Squeeze()
        return ret
        

    _updateable_traits_ = \
    (('sequential_processing', 'GetSequentialProcessing'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'sequential_processing'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AbstractCellLinks, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AbstractCellLinks properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['sequential_processing'], [], []),
            title='Edit AbstractCellLinks properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AbstractCellLinks properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

