# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.xml_writer import XMLWriter


class XMLDataWriterHelper(XMLWriter):
    """
    XMLDataWriterHelper - helper for XMLWriter2 and subclasses
    
    Superclass: XMLWriter
    
    XMLDataWriterHelper is intended to be a helper class used by
    XMLWriter2 and subclasses to use to write the XML to a file.
    Currently, this is simply a subclass of XMLWriter with some
    minimal API exposed. The ultimate goal is to move logic to write XML
    data to this class and remove the reliance on XMLWriter. To get
    things off the ground quickly, this is kept as a subclass of
    XMLWriter for now.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkXMLDataWriterHelper, obj, update, **traits)
    
    def _get_writer(self):
        return wrap_vtk(self._vtk_obj.GetWriter())
    def _set_writer(self, arg):
        old_val = self._get_writer()
        self._wrap_call(self._vtk_obj.SetWriter,
                        deref_vtk(arg))
        self.trait_property_changed('writer', old_val, arg)
    writer = traits.Property(_get_writer, _set_writer, desc=\
        """
        
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)
        get_input(self) -> DataObject
        C++: DataObject *get_input()"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def add_global_field_data(self, *args):
        """
        add_global_field_data(self, dataset:CompositeDataSet) -> bool
        C++: bool add_global_field_data(CompositeDataSet *dataset)
        Adds global field data for composite dataset.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddGlobalFieldData, *my_args)
        return ret

    def add_xml(self, *args):
        """
        add_xml(self, xmlElement:XMLDataElement) -> bool
        C++: bool add_xml(XMLDataElement *xmlElement)
        Serialize and add an XML dom described by the `xmlElement` to the
        file.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddXML, *my_args)
        return ret

    def begin_writing(self):
        """
        begin_writing(self) -> bool
        C++: bool begin_writing()"""
        ret = self._vtk_obj.BeginWriting()
        return ret
        

    def end_writing(self):
        """
        end_writing(self) -> bool
        C++: bool end_writing()"""
        ret = self._vtk_obj.EndWriting()
        return ret
        

    def open_file(self):
        """
        open_file(self) -> bool
        C++: bool open_file()
        The writing process is split into 4 parts:
        1. `open_file` opens the file for writing.
        2. `begin_writing` begins writing by adding header.
        3. Write the contents. API calls like `add_global_field_data`,
           `add_xml` can be used for this.
        4. `end_writing` ends the writing, adding any footers as needed.
        """
        ret = self._vtk_obj.OpenFile()
        return ret
        

    def set_data_set_name(self, *args):
        """
        set_data_set_name(self, name:str) -> None
        C++: void set_data_set_name(const std::string &name)
        These methods should be used by the caller to provide necessary
        information to the helper to generate a valid header. This is
        currently necessary since we are making this class reused parts
        of XMLWriter. When than dependence is severed, this API will
        likely change.
        """
        ret = self._wrap_call(self._vtk_obj.SetDataSetName, *args)
        return ret

    def set_data_set_version(self, *args):
        """
        set_data_set_version(self, major:int, minor:int) -> None
        C++: void set_data_set_version(int major, int minor)"""
        ret = self._wrap_call(self._vtk_obj.SetDataSetVersion, *args)
        return ret

    _updateable_traits_ = \
    (('encode_appended_data', 'GetEncodeAppendedData'),
    ('write_to_output_string', 'GetWriteToOutputString'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('byte_order',
    'GetByteOrder'), ('data_mode', 'GetDataMode'), ('header_type',
    'GetHeaderType'), ('id_type', 'GetIdType'), ('number_of_time_steps',
    'GetNumberOfTimeSteps'), ('block_size', 'GetBlockSize'),
    ('compression_level', 'GetCompressionLevel'), ('file_name',
    'GetFileName'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'encode_appended_data',
    'global_warning_display', 'release_data_flag',
    'write_to_output_string', 'byte_order', 'data_mode', 'header_type',
    'id_type', 'block_size', 'compression_level', 'file_name',
    'number_of_time_steps', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(XMLDataWriterHelper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit XMLDataWriterHelper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['encode_appended_data', 'write_to_output_string'],
            ['byte_order', 'data_mode', 'header_type', 'id_type'], ['block_size',
            'compression_level', 'file_name', 'number_of_time_steps']),
            title='Edit XMLDataWriterHelper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit XMLDataWriterHelper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

