# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.python_algorithm import PythonAlgorithm


class VTKPythonAlgorithmBase(PythonAlgorithm):
    """
    This is a superclass which can be derived to implement
        Python classes that act as VTK algorithms in a VTK pipeline.
        It implements process_request(), fill_input_port_information() and
        fill_output_port_information().
    
        process_request() calls request_xxx() methods to implement
        various pipeline passes.
    
        fill_input_port_information() and fill_output_port_information() set
        the input and output types based on data members.
    
        Common use is something like this:
    
        class HDf5_source(VTKpython_algorithm_base):
            def __init__(self):
                VTKpython_algorithm_base.__init__(self,
                    ninput_ports=0,
                    noutput_ports=1, outputType='vtkimage_data')
    
            def request_information(self, request, inInfo, outInfo):
                f = h5py.File("foo.h5", 'r')
                dims = f['RTData'].shape[::-1]
                info = outInfo.get_information_object(0)
                info.Set(vtkmodules.vtkcommon_execution_model.vtkstreaming_demand_driven_pipeline.WHOLE_EXTENT(),
                    (0, dims[0]-1, 0, dims[1]-1, 0, dims[2]-1), 6)
                return 1
    
            def request_data(self, request, inInfo, outInfo):
                f = h5py.File("foo.h5", 'r')
                data = f['RTData'][:]
                output = dsa.wrap_data_object(vtkmodules.vtkcommon_data_model.vtkimage_data.get_data(outInfo))
                output.set_dimensions(data.shape)
                output.point_data.append(data.flatten(), 'RTData')
                output.point_data.set_active_scalars('RTData')
                return 1
    
        alg = HDf5_source()
    
        cf = vtkmodules.FiltersCore.vtkContourFilter()
        cf.set_input_connection(alg.get_output_port())
        cf.Update()
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.VTKPythonAlgorithmBase, obj, update, **traits)
    
    def get_input_data(self, *args):
        """
        Convenience method that returns an input data object
                given a vector of information objects and two indices
        onvenience method that returns an input data object
                given a vector of information objects and two indices."""
        ret = self._wrap_call(self._vtk_obj.GetInputData, *args)
        return ret

    def get_output_data(self, *args):
        """
        Convenience method that returns an output data object
                given an information object and an index
        onvenience method that returns an output data object
                given an information object and an index."""
        ret = self._wrap_call(self._vtk_obj.GetOutputData, *args)
        return ret

    def fill_input_port_information(self, *args):
        """
        Sets the required input type to InputType
        ets the required input type to input_type."""
        ret = self._wrap_call(self._vtk_obj.FillInputPortInformation, *args)
        return ret

    def fill_output_port_information(self, *args):
        """
        Sets the default output type to OutputType
        ets the default output type to output_type."""
        ret = self._wrap_call(self._vtk_obj.FillOutputPortInformation, *args)
        return ret

    def internal_algorithm(self, *args):
        """
        Internal class. Do not use
        nternal class. Do not use."""
        ret = self._wrap_call(self._vtk_obj.InternalAlgorithm, *args)
        return ret

    def request_data(self, *args):
        """
        Overwritten by subclass to execute the algorithm
        verwritten by subclass to execute the algorithm."""
        ret = self._wrap_call(self._vtk_obj.RequestData, *args)
        return ret

    def request_data_object(self, *args):
        """
        Overwritten by subclass to manage data object creation.
                There is not need to overwrite this class if the output can
                be created based on the OutputType data member
        verwritten by subclass to manage data object creation.
                There is not need to overwrite this class if the output can
                be created based on the output_type data member."""
        ret = self._wrap_call(self._vtk_obj.RequestDataObject, *args)
        return ret

    def request_information(self, *args):
        """
        Overwritten by subclass to provide meta-data to downstream
                pipeline
        verwritten by subclass to provide meta-data to downstream
                pipeline."""
        ret = self._wrap_call(self._vtk_obj.RequestInformation, *args)
        return ret

    def request_update_extent(self, *args):
        """
        Overwritten by subclass to modify data request going
                to upstream pipeline
        verwritten by subclass to modify data request going
                to upstream pipeline."""
        ret = self._wrap_call(self._vtk_obj.RequestUpdateExtent, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('number_of_input_ports', 'GetNumberOfInputPorts'),
    ('number_of_output_ports', 'GetNumberOfOutputPorts'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'number_of_input_ports',
    'number_of_output_ports', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(VTKPythonAlgorithmBase, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit VTKPythonAlgorithmBase properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['number_of_input_ports', 'number_of_output_ports']),
            title='Edit VTKPythonAlgorithmBase properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit VTKPythonAlgorithmBase properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

