# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.hyper_tree_grid import HyperTreeGrid


class UniformHyperTreeGrid(HyperTreeGrid):
    """
    UniformHyperTreeGrid - A specifalized type of HyperTreeGrid for
    the case when root cells have uniform sizes in each direction
    
    Superclass: HyperTreeGrid
    
    @sa
    HyperTree HyperTreeGrid RectilinearGrid
    
    @par Thanks: This class was written by Philippe Pebay, nex_gen
    Analytics 2017 JB modify for introduce Scales by Jacques-Bernard
    Lekien, CEA 2018. This work was supported by Commissariat a l'Energie
    Atomique CEA, DAM, DIF, F-91297 Arpajon, France.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkUniformHyperTreeGrid, obj, update, **traits)
    
    grid_scale = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(1.0, 1.0, 1.0), cols=3, desc=\
        """
        Set/Get scale of root cells along each direction
        """
    )

    def _grid_scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGridScale,
                        self.grid_scale)

    origin = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        """
        Set/Get origin of grid
        """
    )

    def _origin_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOrigin,
                        self.origin)

    def get_tree(self):
        """
        get_tree(self, __a:int, create:bool=False) -> HyperTree
        
        Return tree located at given index of hyper tree grid NB: This
        will construct a new hyper_tree if grid slot is empty.
        """
        ret = self._vtk_obj.GetTree()
        return ret
        

    def set_tree(self, *args):
        """
        set_tree(self, __a:int, __b:HyperTree) -> None
        C++: void set_tree(IdType, HyperTree *)
        Assign given tree to given index of hyper tree grid NB: This will
        create a new slot in the grid if needed.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetTree, *my_args)
        return ret

    def _get_x_coordinates(self):
        return wrap_vtk(self._vtk_obj.GetXCoordinates())
    def _set_x_coordinates(self, arg):
        old_val = self._get_x_coordinates()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetXCoordinates,
                        my_arg[0])
        self.trait_property_changed('x_coordinates', old_val, arg)
    x_coordinates = traits.Property(_get_x_coordinates, _set_x_coordinates, desc=\
        """
        
        """
    )

    def _get_y_coordinates(self):
        return wrap_vtk(self._vtk_obj.GetYCoordinates())
    def _set_y_coordinates(self, arg):
        old_val = self._get_y_coordinates()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetYCoordinates,
                        my_arg[0])
        self.trait_property_changed('y_coordinates', old_val, arg)
    y_coordinates = traits.Property(_get_y_coordinates, _set_y_coordinates, desc=\
        """
        
        """
    )

    def _get_z_coordinates(self):
        return wrap_vtk(self._vtk_obj.GetZCoordinates())
    def _set_z_coordinates(self, arg):
        old_val = self._get_z_coordinates()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetZCoordinates,
                        my_arg[0])
        self.trait_property_changed('z_coordinates', old_val, arg)
    z_coordinates = traits.Property(_get_z_coordinates, _set_z_coordinates, desc=\
        """
        
        """
    )

    _updateable_traits_ = \
    (('has_interface', 'GetHasInterface'), ('global_release_data_flag',
    'GetGlobalReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('grid_scale',
    'GetGridScale'), ('origin', 'GetOrigin'), ('branch_factor',
    'GetBranchFactor'), ('depth_limiter', 'GetDepthLimiter'),
    ('dimensions', 'GetDimensions'), ('extent', 'GetExtent'),
    ('interface_intercepts_name', 'GetInterfaceInterceptsName'),
    ('interface_normals_name', 'GetInterfaceNormalsName'),
    ('mode_squeeze', 'GetModeSqueeze'), ('transposed_root_indexing',
    'GetTransposedRootIndexing'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_release_data_flag', 'global_warning_display',
    'has_interface', 'branch_factor', 'depth_limiter', 'dimensions',
    'extent', 'grid_scale', 'interface_intercepts_name',
    'interface_normals_name', 'mode_squeeze', 'origin',
    'transposed_root_indexing'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(UniformHyperTreeGrid, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit UniformHyperTreeGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['global_release_data_flag', 'has_interface'], [],
            ['branch_factor', 'depth_limiter', 'dimensions', 'extent',
            'grid_scale', 'interface_intercepts_name', 'interface_normals_name',
            'mode_squeeze', 'origin', 'transposed_root_indexing']),
            title='Edit UniformHyperTreeGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit UniformHyperTreeGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

