# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Transform2D(Object):
    """
    Transform2D - describes linear transformations via a 3x3 matrix
    
    Superclass: Object
    
    A Transform2D can be used to describe the full range of linear
    (also known as affine) coordinate transformations in two dimensions,
    which are internally represented as a 3x3 homogeneous transformation
    matrix.  When you create a new Transform2D, it is always
    initialized to the identity transformation.
    
    All multiplicitive operations (Translate, Rotate, Scale, etc) are
    post-multiplied in this class (i.e. add them in the reverse of the
    order that they should be applied).
    
    This class performs all of its operations in a right handed
    coordinate system with right handed rotations. Some other graphics
    libraries use left handed coordinate systems and rotations.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTransform2D, obj, update, **traits)
    
    def _get_matrix(self):
        return wrap_vtk(self._vtk_obj.GetMatrix())
    def _set_matrix(self, arg):
        old_val = self._get_matrix()
        self._wrap_call(self._vtk_obj.SetMatrix,
                        deref_vtk(arg))
        self.trait_property_changed('matrix', old_val, arg)
    matrix = traits.Property(_get_matrix, _set_matrix, desc=\
        """
        Get the underlying 3x3 matrix.
        """
    )

    def get_inverse(self, *args):
        """
        get_inverse(self, inverse:Matrix3x3) -> None
        C++: void get_inverse(Matrix3x3 *inverse)
        Return a matrix which is the inverse of the current
        transformation matrix.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetInverse, *my_args)
        return ret

    def get_position(self, *args):
        """
        get_position(self, pos:[float, float]) -> None
        C++: void get_position(double pos[2])
        Return the position from the current transformation matrix as an
        array of two floating point numbers. This is simply returning the
        translation component of the 3x3 matrix.
        """
        ret = self._wrap_call(self._vtk_obj.GetPosition, *args)
        return ret

    def get_scale(self, *args):
        """
        get_scale(self, scale:[float, float]) -> None
        C++: void get_scale(double scale[2])
        Return the x and y scale from the current transformation matrix
        as an array of two floating point numbers. This is simply
        returning the scale component of the 3x3 matrix.
        """
        ret = self._wrap_call(self._vtk_obj.GetScale, *args)
        return ret

    def get_transpose(self, *args):
        """
        get_transpose(self, transpose:Matrix3x3) -> None
        C++: void get_transpose(Matrix3x3 *transpose)
        Return a matrix which is the transpose of the current
        transformation matrix.  This is equivalent to the inverse if and
        only if the transformation is a pure rotation with no translation
        or scale.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetTranspose, *my_args)
        return ret

    def identity(self):
        """
        identity(self) -> None
        C++: void identity()
        Set the transformation to the identity transformation.
        """
        ret = self._vtk_obj.Identity()
        return ret
        

    def inverse(self):
        """
        inverse(self) -> None
        C++: void inverse()
        Invert the transformation.
        """
        ret = self._vtk_obj.Inverse()
        return ret
        

    def inverse_transform_points(self, *args):
        """
        inverse_transform_points(self, inPts:(float, ...), outPts:[float,
            ...], n:int) -> None
        C++: void inverse_transform_points(const double *inPts,
            double *outPts, int n)
        inverse_transform_points(self, inPts:Points2D,
            outPts:Points2D) -> None
        C++: void inverse_transform_points(Points2D *inPts,
            Points2D *outPts)
        Apply the transformation to a series of points, and append the
        results to outPts. Where n is the number of points, and the float
        pointers are of length 2*n.
        """
        my_args = deref_array(args, [('tuple', ['float', Ellipsis], 'int'), ('vtkPoints2D', 'vtkPoints2D')])
        ret = self._wrap_call(self._vtk_obj.InverseTransformPoints, *my_args)
        return ret

    def multiply_point(self, *args):
        """
        multiply_point(self, in_:(float, float, float), out:[float, float,
            float]) -> None
        C++: void multiply_point(const double in[3], double out[3])"""
        ret = self._wrap_call(self._vtk_obj.MultiplyPoint, *args)
        return ret

    def rotate(self, *args):
        """
        rotate(self, angle:float) -> None
        C++: void rotate(double angle)
        Create a rotation matrix and concatenate it with the current
        transformation. The angle is in degrees.
        """
        ret = self._wrap_call(self._vtk_obj.Rotate, *args)
        return ret

    def scale(self, *args):
        """
        scale(self, x:float, y:float) -> None
        C++: void scale(double x, double y)
        scale(self, s:(float, float)) -> None
        C++: void scale(const double s[2])
        Create a scale matrix (i.e. set the diagonal elements to x, y)
        and concatenate it with the current transformation.
        """
        ret = self._wrap_call(self._vtk_obj.Scale, *args)
        return ret

    def transform_points(self, *args):
        """
        transform_points(self, inPts:(float, ...), outPts:[float, ...],
            n:int) -> None
        C++: void transform_points(const double *inPts, double *outPts,
            int n)
        transform_points(self, inPts:Points2D, outPts:Points2D)
            -> None
        C++: void transform_points(Points2D *inPts, Points2D *outPts)
        Apply the transformation to a series of points, and append the
        results to outPts. Where n is the number of points, and the float
        pointers are of length 2*n.
        """
        my_args = deref_array(args, [(('float', Ellipsis), 'tuple', 'int'), ('vtkPoints2D', 'vtkPoints2D')])
        ret = self._wrap_call(self._vtk_obj.TransformPoints, *my_args)
        return ret

    def translate(self, *args):
        """
        translate(self, x:float, y:float) -> None
        C++: void translate(double x, double y)
        translate(self, x:(float, float)) -> None
        C++: void translate(const double x[2])
        Create a translation matrix and concatenate it with the current
        transformation.
        """
        ret = self._wrap_call(self._vtk_obj.Translate, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Transform2D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Transform2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit Transform2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Transform2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

