# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class TextureUnitManager(Object):
    """
    TextureUnitManager - allocate/free texture units.
    
    Superclass: Object
    
    TextureUnitManager is a central place used by shaders to reserve a
    texture unit ( Allocate() ) or release it ( Free() ).
    
    Don't create a TextureUnitManager, query it from the
    OpenGLRenderWindow
    
    @sa
    OpenGLRenderWindow
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTextureUnitManager, obj, update, **traits)
    
    def _get_number_of_texture_units(self):
        return self._vtk_obj.GetNumberOfTextureUnits()
    number_of_texture_units = traits.Property(_get_number_of_texture_units, desc=\
        """
        Number of texture units supported by the open_gl context.
        """
    )

    def allocate(self, *args):
        """
        allocate(self) -> int
        C++: virtual int allocate()
        allocate(self, unit:int) -> int
        C++: virtual int allocate(int unit)
        Reserve a texture unit. It returns its number. It returns -1 if
        the allocation failed (because there are no more texture units
        left).
        \\post valid_result: result==-1 || result>=0 &&
            result<this->get_number_of_texture_units())
        \\post allocated: result==-1 || this->is_allocated(result)
        """
        ret = self._wrap_call(self._vtk_obj.Allocate, *args)
        return ret

    def free(self, *args):
        """
        free(self, textureUnitId:int) -> None
        C++: virtual void free(int textureUnitId)
        Release a texture unit.
        \\pre valid_textureunit_id: textureunit_id>=0 &&
            textureunit_id<this->get_number_of_texture_units()
        \\pre allocated_textureunit_id: this->is_allocated(textureunit_id)
        """
        ret = self._wrap_call(self._vtk_obj.Free, *args)
        return ret

    def initialize(self):
        """
        initialize(self) -> None
        C++: void initialize()
        Update the number of hardware texture units for the current
        context
        """
        ret = self._vtk_obj.Initialize()
        return ret
        

    def is_allocated(self, *args):
        """
        is_allocated(self, textureUnitId:int) -> bool
        C++: bool is_allocated(int textureUnitId)
        Tell if texture unit `textureunit_id' is already allocated.
        \\pre valid_textureunit_id_range : textureunit_id>=0 &&
        textureunit_id<this->get_number_of_texture_units()
        """
        ret = self._wrap_call(self._vtk_obj.IsAllocated, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(TextureUnitManager, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit TextureUnitManager properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit TextureUnitManager properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit TextureUnitManager properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

