# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.cell3d import Cell3D


class Tetra(Cell3D):
    """
    Tetra - a 3D cell that represents a tetrahedron
    
    Superclass: Cell3D
    
    Tetra is a concrete implementation of Cell to represent a 3D
    tetrahedron. Tetra uses the standard isoparametric shape functions
    for a linear tetrahedron. The tetrahedron is defined by the four
    points (0-3); where (0,1,2) is the base of the tetrahedron which,
    using the right hand rule, forms a triangle whose normal points in
    the direction of the fourth point.
    
    @sa
    ConvexPointSet Hexahedron Pyramid Voxel Wedge
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTetra, obj, update, **traits)
    
    def get_edge_array(self, *args):
        """
        get_edge_array(edgeId:int) -> (int, int)
        C++: static const IdType *get_edge_array(IdType edgeId)
        Return the ids of the vertices defining edge/face
        (`edgeId`/`faceId'). Ids are related to the cell, not to the
        dataset.
        
        ote The return type changed. It used to be int*, it is now const
        IdType*. This is so ids are unified between Cell and
        Points, and so Cell ids can be used as inputs in algorithms
        such as Polygon::ComputeNormal.
        """
        ret = self._wrap_call(self._vtk_obj.GetEdgeArray, *args)
        return ret

    def get_edge_to_adjacent_faces_array(self, *args):
        """
        get_edge_to_adjacent_faces_array(edgeId:int) -> (int, int)
        C++: static const IdType *get_edge_to_adjacent_faces_array(
            IdType edgeId)
        Static method version of get_edge_to_adjacent_faces.
        """
        ret = self._wrap_call(self._vtk_obj.GetEdgeToAdjacentFacesArray, *args)
        return ret

    def get_face_array(self, *args):
        """
        get_face_array(faceId:int) -> (int, int, int)
        C++: static const IdType *get_face_array(IdType faceId)"""
        ret = self._wrap_call(self._vtk_obj.GetFaceArray, *args)
        return ret

    def get_face_to_adjacent_faces_array(self, *args):
        """
        get_face_to_adjacent_faces_array(faceId:int) -> (int, int, int)
        C++: static const IdType *get_face_to_adjacent_faces_array(
            IdType faceId)
        Static method version of get_face_to_adjacent_faces.
        """
        ret = self._wrap_call(self._vtk_obj.GetFaceToAdjacentFacesArray, *args)
        return ret

    def get_point_to_incident_edges_array(self, *args):
        """
        get_point_to_incident_edges_array(pointId:int) -> (int, int, int)
        C++: static const IdType *get_point_to_incident_edges_array(
            IdType pointId)
        Static method version of get_point_to_incident_edges_array.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointToIncidentEdgesArray, *args)
        return ret

    def get_point_to_incident_faces_array(self, *args):
        """
        get_point_to_incident_faces_array(pointId:int) -> (int, int, int)
        C++: static const IdType *get_point_to_incident_faces_array(
            IdType pointId)
        Static method version of get_point_to_incident_faces_array.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointToIncidentFacesArray, *args)
        return ret

    def get_point_to_one_ring_points_array(self, *args):
        """
        get_point_to_one_ring_points_array(pointId:int) -> (int, int, int)
        C++: static const IdType *get_point_to_one_ring_points_array(
            IdType pointId)
        Static method version of get_point_to_one_ring_points.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointToOneRingPointsArray, *args)
        return ret

    def get_triangle_cases(self, *args):
        """
        get_triangle_cases(caseId:int) -> Pointer
        C++: static int *get_triangle_cases(int caseId)
        Return the case table for table-based isocontouring (aka marching
        cubes style implementations). A linear 3D cell with N vertices
        will have 2**N cases. The returned case array lists three edges
        in order to produce one output triangle which may be repeated to
        generate multiple triangles. The list of cases terminates with a
        -1 entry.
        """
        ret = self._wrap_call(self._vtk_obj.GetTriangleCases, *args)
        return ret

    def barycentric_coords(self, *args):
        """
        barycentric_coords(x:[float, float, float], x1:[float, float,
            float], x2:[float, float, float], x3:[float, float, float],
            x4:[float, float, float], bcoords:[float, float, float,
            float]) -> int
        C++: static int barycentric_coords(double x[3], double x1[3],
            double x2[3], double x3[3], double x4[3], double bcoords[4])
        Given a 3D point x[3], determine the barycentric coordinates of
        the point. Barycentric coordinates are a natural coordinate
        system for simplices that express a position as a linear
        combination of the vertices. For a tetrahedron, there are four
        barycentric coordinates (because there are four vertices), and
        the sum of the coordinates must equal 1. If a point x is inside a
        simplex, then all four coordinates will be strictly positive.  If
        three coordinates are zero (so the fourth =1), then the point x
        is on a vertex. If two coordinates are zero, the point x is on an
        edge (and so on). In this method, you must specify the vertex
        coordinates x1->x4. Returns 0 if tetrahedron is degenerate.
        """
        ret = self._wrap_call(self._vtk_obj.BarycentricCoords, *args)
        return ret

    def circumsphere(self, *args):
        """
        circumsphere(x1:[float, float, float], x2:[float, float, float],
            x3:[float, float, float], x4:[float, float, float],
            center:[float, float, float]) -> float
        C++: static double circumsphere(double x1[3], double x2[3],
            double x3[3], double x4[3], double center[3])
        Compute the circumcenter (center[3]) and radius squared (method
        return value) of a tetrahedron defined by the four points x1, x2,
        x3, and x4.
        """
        ret = self._wrap_call(self._vtk_obj.Circumsphere, *args)
        return ret

    def compute_centroid(self, *args):
        """
        compute_centroid(points:Points, pointIds:(int, ...),
            centroid:[float, float, float]) -> bool
        C++: static bool compute_centroid(Points *points,
            const IdType *pointIds, double centroid[3])
        Static method version of get_centroid.
        """
        my_args = deref_array(args, [('vtkPoints', ('int', Ellipsis), ['float', 'float', 'float'])])
        ret = self._wrap_call(self._vtk_obj.ComputeCentroid, *my_args)
        return ret

    def compute_volume(self, *args):
        """
        compute_volume(p1:[float, float, float], p2:[float, float, float],
            p3:[float, float, float], p4:[float, float, float]) -> float
        C++: static double compute_volume(double p1[3], double p2[3],
            double p3[3], double p4[3])
        Compute the volume of a tetrahedron defined by the four points
        p1, p2, p3, and p4.
        """
        ret = self._wrap_call(self._vtk_obj.ComputeVolume, *args)
        return ret

    def insphere(self, *args):
        """
        insphere(p1:[float, float, float], p2:[float, float, float],
            p3:[float, float, float], p4:[float, float, float],
            center:[float, float, float]) -> float
        C++: static double insphere(double p1[3], double p2[3],
            double p3[3], double p4[3], double center[3])
        Compute the center (center[3]) and radius (method return value)
        of a sphere that just fits inside the faces of a tetrahedron
        defined by the four points x1, x2, x3, and x4.
        """
        ret = self._wrap_call(self._vtk_obj.Insphere, *args)
        return ret

    def interpolation_derivs(self, *args):
        """
        interpolation_derivs(pcoords:(float, float, float), derivs:[float,
            float, float, float, float, float, float, float, float, float,
             float, float]) -> None
        C++: static void interpolation_derivs(const double pcoords[3],
            double derivs[12])"""
        ret = self._wrap_call(self._vtk_obj.InterpolationDerivs, *args)
        return ret

    def interpolation_functions(self, *args):
        """
        interpolation_functions(pcoords:(float, float, float),
            weights:[float, float, float, float]) -> None
        C++: static void interpolation_functions(const double pcoords[3],
            double weights[4])"""
        ret = self._wrap_call(self._vtk_obj.InterpolationFunctions, *args)
        return ret

    def tetra_center(self, *args):
        """
        tetra_center(p1:[float, float, float], p2:[float, float, float],
            p3:[float, float, float], p4:[float, float, float],
            center:[float, float, float]) -> None
        C++: static void tetra_center(double p1[3], double p2[3],
            double p3[3], double p4[3], double center[3])
        Compute the center of the tetrahedron,
        """
        ret = self._wrap_call(self._vtk_obj.TetraCenter, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('merge_tolerance', 'GetMergeTolerance'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'merge_tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Tetra, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Tetra properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['merge_tolerance']),
            title='Edit Tetra properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Tetra properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

