# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.widget_representation import WidgetRepresentation


class TensorRepresentation(WidgetRepresentation):
    """
    TensorRepresentation - class defining a representation for the
    TensorWidget
    
    Superclass: WidgetRepresentation
    
    This class is a concrete representation for the TensorWidget. In
    summary, it allows the editing of a tensor glyph (by modifying the
    underlying tensor value). This includes controlling the position,
    scaling, and rotation of the glyph. The representation is simply an
    oriented, scaled box which can be manipulated to transform the
    tensor. Optionally, an ellipsoid defined by the tensor eigenvectors
    can be shown for informational purposes.
    
    To use this representation, specify a 3x3 real, symmetric matrix
    defining the tensor. (This implicitly defines an orthogonal basis
    from the three tensor eigenvectors.) Then use place_widget() to define
    a bounding box: the bounding box defines a position for the tensor
    from its center point, and the representation is scaled to fit in the
    bounding box.
    
    Note: typical usage is to place a tensor glyph inside of the
    representation (i.e., the box) which is updated as the representation
    is manipulated by the user. The built-in ellipsoid can be used for
    this; alternatively through callbacks and such, it is possible to
    place other glyph types such as superquadrics.
    
    @sa
    TensorWidget BoxRepresentation
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTensorRepresentation, obj, update, **traits)
    
    outline_cursor_wires = tvtk_base.true_bool_trait(desc=\
        """
        Control the representation of the outline. This flag enables the
        cursor lines running between the handles. By default cursor wires
        are on.
        """
    )

    def _outline_cursor_wires_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutlineCursorWires,
                        self.outline_cursor_wires_)

    outline_face_wires = tvtk_base.false_bool_trait(desc=\
        """
        Control the representation of the outline. This flag enables face
        wires. By default face wires are off.
        """
    )

    def _outline_face_wires_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutlineFaceWires,
                        self.outline_face_wires_)

    tensor_ellipsoid = tvtk_base.true_bool_trait(desc=\
        """
        Indicate whether to show the tensor ellipsoid. By default it is
        on.
        """
    )

    def _tensor_ellipsoid_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTensorEllipsoid,
                        self.tensor_ellipsoid_)

    interaction_state = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        The interaction state may be set from a widget (e.g.,
        TensorWidget) or other object. This controls how the
        interaction with the widget proceeds. Normally this method is
        used as part of a handshaking process with the widget: First
        compute_interaction_state() is invoked that returns a state based
        on geometric considerations (i.e., cursor near a widget feature),
        then based on events, the widget may modify this further.
        """
    )

    def _interaction_state_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInteractionState,
                        self.interaction_state)

    def get_position(self, *args):
        """
        get_position(self, pos:[float, float, float]) -> None
        C++: void get_position(double pos[3])"""
        ret = self._wrap_call(self._vtk_obj.GetPosition, *args)
        return ret

    def set_position(self, *args):
        """
        set_position(self, pos:[float, float, float]) -> None
        C++: void set_position(double pos[3])
        Set/Get a position for the location of the tensor. Of course a
        tensor inherently has no position, but this is for the purpose of
        placing this widget representation.
        """
        ret = self._wrap_call(self._vtk_obj.SetPosition, *args)
        return ret

    snap_to_axes = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _snap_to_axes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSnapToAxes,
                        self.snap_to_axes)

    def get_symmetric_tensor(self, *args):
        """
        get_symmetric_tensor(self, symTensor:[float, float, float, float,
            float, float]) -> None
        C++: void get_symmetric_tensor(double symTensor[6])"""
        ret = self._wrap_call(self._vtk_obj.GetSymmetricTensor, *args)
        return ret

    def set_symmetric_tensor(self, *args):
        """
        set_symmetric_tensor(self, symTensor:[float, float, float, float,
            float, float]) -> None
        C++: void set_symmetric_tensor(double symTensor[6])"""
        ret = self._wrap_call(self._vtk_obj.SetSymmetricTensor, *args)
        return ret

    def get_tensor(self, *args):
        """
        get_tensor(self, tensor:[float, float, float, float, float, float,
            float, float, float]) -> None
        C++: void get_tensor(double tensor[9])"""
        ret = self._wrap_call(self._vtk_obj.GetTensor, *args)
        return ret

    def set_tensor(self, *args):
        """
        set_tensor(self, tensor:[float, float, float, float, float, float,
            float, float, float]) -> None
        C++: void set_tensor(double tensor[9])
        These are the basic methods used to define the tensor (these
        methods coordinate with the overloaded place_widget() method). The
        methods enable specification of a 3x3 symmetric tensor. This
        information is used to construct an oriented, appropriately
        ellipsoid that is (initially) centered and fits inside the
        bounding box defined by place_widget(). As this widget is modified
        during user interaction, the tensor data member is continuously
        updated and can be queried. Note that a symmetric tensor can be
        defined with only six components. If a full 3x3 tensor is
        specified, only the symmetrical part of the tensor is used since
        the extracted eigenvalues/eigenvecters are required to be real
        valued. When a tensor is specified, the derived information
        (e.g., eigenvalues/vectors and position) are immediately updated.
        """
        ret = self._wrap_call(self._vtk_obj.SetTensor, *args)
        return ret

    translation_axis = traits.Trait(-1, traits.Range(-1, 2, enter_set=True, auto_set=False), desc=\
        """
        
        """
    )

    def _translation_axis_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTranslationAxis,
                        self.translation_axis)

    def get_eigenvalues(self, *args):
        """
        get_eigenvalues(self, evals:[float, float, float]) -> None
        C++: void get_eigenvalues(double evals[3])
        These are methods used to retrieve derived information about the
        tensor. Specify (0<=i<3) to retrieve the ith eigenvector. The
        eigenvalues and associated eigenvectors are sorted in decreasing
        order.
        """
        ret = self._wrap_call(self._vtk_obj.GetEigenvalues, *args)
        return ret

    def get_eigenvector(self, *args):
        """
        get_eigenvector(self, n:int, ev:[float, float, float]) -> None
        C++: void get_eigenvector(int n, double ev[3])"""
        ret = self._wrap_call(self._vtk_obj.GetEigenvector, *args)
        return ret

    def _get_ellipsoid_property(self):
        return wrap_vtk(self._vtk_obj.GetEllipsoidProperty())
    ellipsoid_property = traits.Property(_get_ellipsoid_property, desc=\
        """
        Get the tensor ellipsoid properties. If visibility is enabled,
        the ellipsoid will be rendered with this property.
        """
    )

    def _get_face_property(self):
        return wrap_vtk(self._vtk_obj.GetFaceProperty())
    face_property = traits.Property(_get_face_property, desc=\
        """
        Get the face properties (the faces of the box). The properties of
        the face when selected and normal can be set.
        """
    )

    def _get_handle_property(self):
        return wrap_vtk(self._vtk_obj.GetHandleProperty())
    handle_property = traits.Property(_get_handle_property, desc=\
        """
        Get the handle properties (the little balls are the handles). The
        properties of the handles, when selected or normal, can be
        specified.
        """
    )

    def _get_outline_property(self):
        return wrap_vtk(self._vtk_obj.GetOutlineProperty())
    outline_property = traits.Property(_get_outline_property, desc=\
        """
        Get the outline properties (the outline of the box). The
        properties of the outline when selected and normal can be set.
        """
    )

    def get_poly_data(self, *args):
        """
        get_poly_data(self, pd:PolyData) -> None
        C++: void get_poly_data(PolyData *pd)
        Grab the polydata (including points) that define the
        representation. The polydata consists of 6 quadrilateral faces
        and 15 points. The first eight points define the eight corner
        vertices; the next six define the
        -x,+x, -y,+y, -z,+z face points; and the final point (the 15th
            out of 15 points) defines the center of the box. These point
            values are guaranteed to be up-to-date when either the
            widget's corresponding interaction_event or
            end_interaction_event events are invoked. The user provides the
            PolyData and the points and cells are added to it.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetPolyData, *my_args)
        return ret

    def _get_selected_face_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedFaceProperty())
    selected_face_property = traits.Property(_get_selected_face_property, desc=\
        """
        
        """
    )

    def _get_selected_handle_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedHandleProperty())
    selected_handle_property = traits.Property(_get_selected_handle_property, desc=\
        """
        
        """
    )

    def _get_selected_outline_property(self):
        return wrap_vtk(self._vtk_obj.GetSelectedOutlineProperty())
    selected_outline_property = traits.Property(_get_selected_outline_property, desc=\
        """
        
        """
    )

    def handles_off(self):
        """
        handles_off(self) -> None
        C++: virtual void handles_off()"""
        ret = self._vtk_obj.HandlesOff()
        return ret
        

    def handles_on(self):
        """
        handles_on(self) -> None
        C++: virtual void handles_on()
        Switches handles (the spheres) on or off by manipulating the
        underlying actor visibility.
        """
        ret = self._vtk_obj.HandlesOn()
        return ret
        

    def is_translation_constrained(self):
        """
        is_translation_constrained(self) -> bool
        C++: bool is_translation_constrained()
        Returns true if contrained_axis
        """
        ret = self._vtk_obj.IsTranslationConstrained()
        return ret
        

    def place_tensor(self, *args):
        """
        place_tensor(self, tensor:[float, float, float, float, float,
            float, float, float, float], position:[float, float, float])
            -> None
        C++: void place_tensor(double tensor[9], double position[3])
        This is a specialized place widget method for a tensor. Specify
        the tensor (an array of 9 components) and the position to place
        the tensor. Note that the place_factor (defined in superclass) can
        be used to scale the representation when placed.
        """
        ret = self._wrap_call(self._vtk_obj.PlaceTensor, *args)
        return ret

    def set_translation_axis_off(self):
        """
        set_translation_axis_off(self) -> None
        C++: void set_translation_axis_off()"""
        ret = self._vtk_obj.SetTranslationAxisOff()
        return ret
        

    def set_x_translation_axis_on(self):
        """
        set_x_translation_axis_on(self) -> None
        C++: void set_x_translation_axis_on()
        Toggles constraint translation axis on/off.
        """
        ret = self._vtk_obj.SetXTranslationAxisOn()
        return ret
        

    def set_y_translation_axis_on(self):
        """
        set_y_translation_axis_on(self) -> None
        C++: void set_y_translation_axis_on()"""
        ret = self._vtk_obj.SetYTranslationAxisOn()
        return ret
        

    def set_z_translation_axis_on(self):
        """
        set_z_translation_axis_on(self) -> None
        C++: void set_z_translation_axis_on()"""
        ret = self._vtk_obj.SetZTranslationAxisOn()
        return ret
        

    def step_backward(self):
        """
        step_backward(self) -> None
        C++: void step_backward()"""
        ret = self._vtk_obj.StepBackward()
        return ret
        

    def step_forward(self):
        """
        step_forward(self) -> None
        C++: void step_forward()
        For complex events should we snap orientations to be aligned with
        the x y z axes
        """
        ret = self._vtk_obj.StepForward()
        return ret
        

    _updateable_traits_ = \
    (('outline_cursor_wires', 'GetOutlineCursorWires'),
    ('outline_face_wires', 'GetOutlineFaceWires'), ('tensor_ellipsoid',
    'GetTensorEllipsoid'), ('need_to_render', 'GetNeedToRender'),
    ('picking_managed', 'GetPickingManaged'), ('dragable', 'GetDragable'),
    ('pickable', 'GetPickable'), ('use_bounds', 'GetUseBounds'),
    ('visibility', 'GetVisibility'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('interaction_state', 'GetInteractionState'), ('snap_to_axes',
    'GetSnapToAxes'), ('translation_axis', 'GetTranslationAxis'),
    ('handle_size', 'GetHandleSize'), ('place_factor', 'GetPlaceFactor'),
    ('estimated_render_time', 'GetEstimatedRenderTime'),
    ('render_time_multiplier', 'GetRenderTimeMultiplier'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'dragable', 'global_warning_display', 'need_to_render',
    'outline_cursor_wires', 'outline_face_wires', 'pickable',
    'picking_managed', 'tensor_ellipsoid', 'use_bounds', 'visibility',
    'estimated_render_time', 'handle_size', 'interaction_state',
    'place_factor', 'render_time_multiplier', 'snap_to_axes',
    'translation_axis'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(TensorRepresentation, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit TensorRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['need_to_render', 'outline_cursor_wires', 'outline_face_wires',
            'picking_managed', 'tensor_ellipsoid', 'use_bounds', 'visibility'],
            [], ['estimated_render_time', 'handle_size', 'interaction_state',
            'place_factor', 'render_time_multiplier', 'snap_to_axes',
            'translation_axis']),
            title='Edit TensorRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit TensorRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

