# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.table_algorithm import TableAlgorithm


class TableFFT(TableAlgorithm):
    """
    TableFFT - FFT for table columns
    
    Superclass: TableAlgorithm
    
    TableFFT performs the Fast Fourier Transform on the columns of a
    table. It can perform the FFT per block in order to resample the
    input and have a smaller output, and also offer a interface for
    windowing the input signal.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTableFFT, obj, update, **traits)
    
    average_fft = tvtk_base.false_bool_trait(desc=\
        """
        Specify if the input should be split in multiple blocks to
        compute an average fft across all blocks.
        
        Default is false
        """
    )

    def _average_fft_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAverageFft,
                        self.average_fft_)

    create_frequency_column = tvtk_base.false_bool_trait(desc=\
        """
        Specify if the filter should create a frequency column based on a
        column named "time" (not case sensitive). An evenly-spaced time
        array is expected.
        
        Default is false
        """
    )

    def _create_frequency_column_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCreateFrequencyColumn,
                        self.create_frequency_column_)

    normalize = tvtk_base.false_bool_trait(desc=\
        """
        Specify if the output should be normalized.
        
        Default is false
        """
    )

    def _normalize_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormalize,
                        self.normalize_)

    optimize_for_real_input = tvtk_base.false_bool_trait(desc=\
        """
        Specify if the filter should use the optimized discrete fourier
        transform for real values. This will cause output columns to have
        from n to ((n / 2) + 1) rows.
        
        Default is false
        """
    )

    def _optimize_for_real_input_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOptimizeForRealInput,
                        self.optimize_for_real_input_)

    block_size = traits.Int(1024, enter_set=True, auto_set=False, desc=\
        """
        Only used if average_fft is true
        
        Specify the number of samples to use for each block. This should
        be a power of 2. If not, the closest power of two will be used
        anyway.
        
        Default is 1024
        """
    )

    def _block_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBlockSize,
                        self.block_size)

    number_of_block = traits.Int(2, enter_set=True, auto_set=False, desc=\
        """
        Only used if average_fft is true
        
        Specify the number of blocks to use when computing the average
        fft over the whole input sample array. If number_of_block == 1, no
        average is done and we only compute the fft on the first
        block_size samples of the input data.
        
        This parameter is ignored if block_size is superior to the number
        of samples of the input array.
        
        Default is 2.
        """
    )

    def _number_of_block_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfBlock,
                        self.number_of_block)

    windowing_function = traits.Int(4, enter_set=True, auto_set=False, desc=\
        """
        Specify the windowing function to apply on the input. If
        average_fft is true the windowing function will be applied per
        block and not on the whole input
        
        Default is RECTANGULAR (does nothing).
        """
    )

    def _windowing_function_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWindowingFunction,
                        self.windowing_function)

    _updateable_traits_ = \
    (('average_fft', 'GetAverageFft'), ('create_frequency_column',
    'GetCreateFrequencyColumn'), ('normalize', 'GetNormalize'),
    ('optimize_for_real_input', 'GetOptimizeForRealInput'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('block_size',
    'GetBlockSize'), ('number_of_block', 'GetNumberOfBlock'),
    ('windowing_function', 'GetWindowingFunction'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'average_fft', 'create_frequency_column', 'debug',
    'global_warning_display', 'normalize', 'optimize_for_real_input',
    'release_data_flag', 'block_size', 'number_of_block', 'progress_text',
    'windowing_function'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(TableFFT, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit TableFFT properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['average_fft', 'create_frequency_column', 'normalize',
            'optimize_for_real_input'], [], ['block_size', 'number_of_block',
            'windowing_function']),
            title='Edit TableFFT properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit TableFFT properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

