# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class StaticCleanPolyData(PolyDataAlgorithm):
    """
    StaticCleanPolyData - merge duplicate points, and/or remove unused
    points and/or remove degenerate cells
    
    Superclass: PolyDataAlgorithm
    
    StaticCleanPolyData is a filter that takes polygonal data as input
    and generates polygonal data as output. StaticCleanPolyData will
    merge duplicate points (within specified tolerance), and if enabled,
    transform degenerate cells into appropriate forms (for example, a
    triangle is converted into a line if two points of triangle are
    merged).
    
    Conversion of degenerate cells is controlled by the flags
    convert_lines_to_points, convert_polys_to_lines, convert_strips_to_polys which
    act cumulatively such that a degenerate strip may become a poly. The
    full set is Line with 1 points -> Vert (if convert_lines_to_points) Poly
    with 2 points -> Line (if convert_polys_to_lines) Poly with 1 points ->
    Vert (if convert_polys_to_lines && convert_lines_to_points) Strp with 3
    points -> Poly (if convert_strips_to_polys) Strp with 2 points -> Line
    (if convert_strips_to_polys && convert_polys_to_lines) Strp with 1 points
    -> Vert (if convert_strips_to_polys && convert_polys_to_lines
      && convert_lines_to_points)
    
    Internally this class uses StaticPointLocator, which is a
    threaded, and much faster locator than the incremental locators that
    CleanPolyData uses. Note because of these and other differences,
    the output of this filter may be different than CleanPolyData.
    
    Note that if you want to remove points that aren't used by any cells
    (i.e., disable point merging), then use CleanPolyData.
    
    @warning
    Merging points can alter topology, including introducing non-manifold
    forms. The tolerance should be chosen carefully to avoid these
    problems. Large tolerances (of size > locator bin width) may generate
    poor results.
    
    @warning
    Merging close points with tolerance >0.0 is inherently an unstable
    problem because the results are order dependent (e.g., the order in
    which points are processed). When parallel computing, the order of
    processing points is unpredictable, hence the results may vary
    between runs.
    
    @warning
    If you wish to operate on a set of coordinates that has no cells, you
    must add a PolyVertex cell with all of the points to the poly_data
    (or use a VertexGlyphFilter) before using the
    StaticCleanPolyData filter.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    CleanPolyData
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkStaticCleanPolyData, obj, update, **traits)
    
    convert_lines_to_points = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off conversion of degenerate lines to points. Default is
        On.
        """
    )

    def _convert_lines_to_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConvertLinesToPoints,
                        self.convert_lines_to_points_)

    convert_polys_to_lines = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off conversion of degenerate polys to lines. Default is
        On.
        """
    )

    def _convert_polys_to_lines_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConvertPolysToLines,
                        self.convert_polys_to_lines_)

    convert_strips_to_polys = tvtk_base.true_bool_trait(desc=\
        """
        Turn on/off conversion of degenerate strips to polys. Default is
        On.
        """
    )

    def _convert_strips_to_polys_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConvertStripsToPolys,
                        self.convert_strips_to_polys_)

    piece_invariant = tvtk_base.true_bool_trait(desc=\
        """
        
        """
    )

    def _piece_invariant_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPieceInvariant,
                        self.piece_invariant_)

    tolerance_is_absolute = tvtk_base.false_bool_trait(desc=\
        """
        By default tolerance_is_absolute is false and Tolerance is a
        fraction of Bounding box diagonal, if true, absolute_tolerance is
        used when adding points to locator (merging)
        """
    )

    def _tolerance_is_absolute_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetToleranceIsAbsolute,
                        self.tolerance_is_absolute_)

    absolute_tolerance = traits.Trait(1.0, traits.Range(0.0, 1e+299, enter_set=True, auto_set=False), desc=\
        """
        Specify tolerance in absolute terms. Default is 1.0.
        """
    )

    def _absolute_tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAbsoluteTolerance,
                        self.absolute_tolerance)

    output_points_precision = traits.Int(2, enter_set=True, auto_set=False, desc=\
        """
        Set/get the desired precision for the output types. See the
        documentation for the Algorithm::DesiredOutputPrecision enum
        for an explanation of the available precision settings.
        """
    )

    def _output_points_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPointsPrecision,
                        self.output_points_precision)

    tolerance = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        """
        Specify tolerance in terms of fraction of bounding box length. 
        Default is 0.0. This takes effect only if tolerance_is_absolute is
        false.
        """
    )

    def _tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTolerance,
                        self.tolerance)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_locator(self):
        return wrap_vtk(self._vtk_obj.GetLocator())
    locator = traits.Property(_get_locator, desc=\
        """
        Retrieve the internal locator to manually configure it, for
        example specifying the number of points per bucket. This method
        is generally used for debugging or testing purposes.
        """
    )

    _updateable_traits_ = \
    (('convert_lines_to_points', 'GetConvertLinesToPoints'),
    ('convert_polys_to_lines', 'GetConvertPolysToLines'),
    ('convert_strips_to_polys', 'GetConvertStripsToPolys'),
    ('piece_invariant', 'GetPieceInvariant'), ('tolerance_is_absolute',
    'GetToleranceIsAbsolute'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('absolute_tolerance', 'GetAbsoluteTolerance'),
    ('output_points_precision', 'GetOutputPointsPrecision'), ('tolerance',
    'GetTolerance'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'convert_lines_to_points',
    'convert_polys_to_lines', 'convert_strips_to_polys', 'debug',
    'global_warning_display', 'piece_invariant', 'release_data_flag',
    'tolerance_is_absolute', 'absolute_tolerance',
    'output_points_precision', 'progress_text', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(StaticCleanPolyData, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit StaticCleanPolyData properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['convert_lines_to_points', 'convert_polys_to_lines',
            'convert_strips_to_polys', 'piece_invariant',
            'tolerance_is_absolute'], [], ['absolute_tolerance',
            'output_points_precision', 'tolerance']),
            title='Edit StaticCleanPolyData properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit StaticCleanPolyData properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

